/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ManualSealLabelPanel
extends DefaultPanel
implements ButtonListener,
UIStateLoadable {
    private static final long serialVersionUID = 1L;
    private TitledItem<RadioButton> useSealsOfFlight;
    private TitledItem<RadioButton> generateDefaults;
    private TitledItem<CheckBox> includeBoundSeals;
    private Table2 seals;

    public ManualSealLabelPanel() {
        this.setLayout(new Layout());
        this.useSealsOfFlight = new TitledItem<RadioButton>(new RadioButton(), Words.USE_SEALS_OF_FLIGHT, TitledItem.TitledItemOrientation.EAST);
        this.generateDefaults = new TitledItem<RadioButton>(new RadioButton(), Words.GENERATE_DEFAULTS, TitledItem.TitledItemOrientation.EAST);
        this.includeBoundSeals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_EQUIPMENT_SEALS, TitledItem.TitledItemOrientation.EAST);
        this.useSealsOfFlight.getElement().addButtonListener(this);
        this.generateDefaults.getElement().addButtonListener(this);
        this.useSealsOfFlight.getElement().setChecked(true);
        this.seals = new Table2(true, Words.ADD, true, true, Words.SEALS);
        this.seals.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                DTOProxyNode colorNode = new DTOProxyNode();
                colorNode.setName("name");
                Node countNode = new Node();
                countNode.setName("count");
                Node group = new Node();
                group.addChild((Node)colorNode, 0L);
                group.addChild(countNode, 0L);
                ManualSealLabelPanel.this.seals.getModel().getNode().addChild(group, System.currentTimeMillis());
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.COLOR, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.seals.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        this.seals.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.seals.getModel().setNode((Node)new ListNode());
        this.add(this.useSealsOfFlight);
        this.add(this.generateDefaults);
        this.add(this.seals);
        this.add(this.includeBoundSeals);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.includeBoundSeals);
        CheckedListAdder.addToList(a, this.useSealsOfFlight);
        CheckedListAdder.addToList(a, this.generateDefaults);
        CheckedListAdder.addToList(a, this.seals);
        return a;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.includeBoundSeals.setEnabled(isEnabled);
        this.useSealsOfFlight.setEnabled(isEnabled);
        this.generateDefaults.setEnabled(isEnabled);
        this.seals.setEditable(isEnabled && this.generateDefaults.getElement().isChecked());
        this.seals.setEnabled(isEnabled && this.generateDefaults.getElement().isChecked());
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    public boolean getUseFlightSeals() {
        return this.useSealsOfFlight.getElement().isChecked();
    }

    public boolean getUseEquipmentLabels() {
        return this.includeBoundSeals.getElement().isChecked();
    }

    public Map<ColorComplete, Integer> getSealsCount() {
        HashMap<ColorComplete, Integer> map = new HashMap<ColorComplete, Integer>();
        Iterator it = this.seals.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Node color = node.getChildNamed(DtoFieldConstants.name);
            Node text = node.getChildNamed(DtoFieldConstants.count);
            if (color.getValue() == null || text.getValue() == null) continue;
            Integer iCount = null;
            ColorComplete iColor = (ColorComplete)color.getValue();
            try {
                iCount = Integer.valueOf((String)text.getValue());
            }
            catch (Exception e) {
                continue;
            }
            map.put(iColor, iCount);
        }
        return map;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.setEnabled(this.isEnabled());
    }

    @Override
    public String getPersistString() {
        return null;
    }

    @Override
    public void loadState(String state, String id) {
    }

    @Override
    public String getID() {
        return null;
    }

    @Override
    public boolean shouldPersist() {
        return false;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox color;
        private TextField count;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.color = new ComboBox(m.getNode().getChildNamed(DtoFieldConstants.name), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), false, true);
            this.count = new TextField(m.getNode().getChildNamed(DtoFieldConstants.count));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new InnerLayout());
            this.add(this.color);
            this.add(this.count);
            this.add(this.delete);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.color);
            CheckedListAdder.addToList(a, this.count);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.getModel().getNode().getParent().removeChild(this.getModel().getNode(), 0L);
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.color.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.color.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.color.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.color.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                TableRowImpl.this.setControlsX(currentX += w);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container arg0) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        int border = 10;

        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            h = (int)((double)h + ManualSealLabelPanel.this.includeBoundSeals.getPreferredSize().getHeight());
            h += this.border;
            h = (int)((double)h + ManualSealLabelPanel.this.useSealsOfFlight.getPreferredSize().getHeight());
            h += this.border / 2;
            h = (int)((double)h + ManualSealLabelPanel.this.generateDefaults.getPreferredSize().getHeight());
            h += this.border / 2;
            return new Dimension(0, h += 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ManualSealLabelPanel.this.includeBoundSeals.setLocation(0, 0);
            ManualSealLabelPanel.this.includeBoundSeals.setSize(parent.getWidth(), (int)ManualSealLabelPanel.this.includeBoundSeals.getPreferredSize().getHeight());
            ManualSealLabelPanel.this.useSealsOfFlight.setLocation(0, ManualSealLabelPanel.this.includeBoundSeals.getY() + ManualSealLabelPanel.this.includeBoundSeals.getHeight() + this.border);
            ManualSealLabelPanel.this.useSealsOfFlight.setSize(parent.getWidth(), (int)ManualSealLabelPanel.this.useSealsOfFlight.getPreferredSize().getHeight());
            ManualSealLabelPanel.this.generateDefaults.setLocation(0, ManualSealLabelPanel.this.useSealsOfFlight.getY() + ManualSealLabelPanel.this.useSealsOfFlight.getHeight() + this.border / 2);
            ManualSealLabelPanel.this.generateDefaults.setSize(parent.getWidth(), (int)ManualSealLabelPanel.this.generateDefaults.getPreferredSize().getHeight());
            ManualSealLabelPanel.this.seals.setLocation(0, ManualSealLabelPanel.this.generateDefaults.getY() + ManualSealLabelPanel.this.generateDefaults.getHeight() + this.border / 2);
            ManualSealLabelPanel.this.seals.setSize(parent.getWidth(), parent.getHeight() - ManualSealLabelPanel.this.seals.getY());
        }
    }
}

