/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.rightdependant;

import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDField;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import java.awt.Color;
import java.awt.Dimension;

public class RDTextField
extends RDField<TextField, TextLabel> {
    private static final long serialVersionUID = 1L;
    private TextFieldType type;
    private TextFieldListener listener;
    private int maxKommas = -1;

    public RDTextField(RDProvider provider) {
        this(provider, TextFieldType.NORMAL);
    }

    public RDTextField(RDProvider provider, TextFieldType type) {
        super(provider);
        this.type = type;
    }

    @Override
    public Dimension getNodeLessPreferredSize() {
        int h = ((Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin()).getImageLeft(Button.ButtonState.UP).getHeight();
        return new Dimension(h, h);
    }

    public void setEditable(boolean editable) {
        if (this.wField != null) {
            ((TextField)this.wField).setEditable(editable);
            if (editable) {
                ((TextField)this.wField).setForeground(Color.white);
            } else {
                ((TextField)this.wField).setFontColorToDisabled();
            }
        }
    }

    public String getText() {
        if (this.wField != null) {
            return ((TextField)this.wField).getText();
        }
        if (this.rField != null) {
            return ((TextLabel)this.rField).getText();
        }
        return null;
    }

    @Override
    public TextField createEditor(Node<?> n) {
        TextField t = this.type.createTextField(n);
        if (t instanceof NumberTextField && this.maxKommas != -1) {
            ((NumberTextField)t).setMaxKommaStellen(this.maxKommas);
        }
        if (this.listener != null) {
            t.addTextFieldListener(this.listener);
        }
        t.setEnabled(this.isEnabled);
        return t;
    }

    @Override
    public TextLabel createRenderer(Node<?> n) {
        TextLabel t = new TextLabel();
        t.setReadOnlyTextField(true);
        t.setEnabled(this.isEnabled);
        return t;
    }

    public void setValidateAfterTypeing() {
        if (this.wField != null) {
            ((TextField)this.wField).setValidateAfterTypeing();
        }
    }

    public boolean isFieldValid() {
        if (this.wField != null) {
            return ((TextField)this.wField).isFieldValid();
        }
        return true;
    }

    public void setSelectionDelegate(Selectable tableRowImpl) {
        if (this.wField != null) {
            ((TextField)this.wField).setSelectionDelegate(tableRowImpl);
        }
    }

    public void addTextFieldListener(TextFieldListener tableRowImpl) {
        if (this.wField != null) {
            ((TextField)this.wField).addTextFieldListener(tableRowImpl);
        }
        this.listener = tableRowImpl;
    }

    public void setMaxKommaStellen(int i) {
        this.maxKommas = i;
        if (this.wField != null && this.wField instanceof NumberTextField) {
            ((NumberTextField)this.wField).setMaxKommaStellen(this.maxKommas);
        }
    }
}

