/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.searchbox;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;

public class SearchComboBox
extends SearchTextField2 {
    private static final long serialVersionUID = 1L;
    private boolean wasMouseRelease = false;

    public SearchComboBox(boolean isAutoCompletion) {
        super(isAutoCompletion);
        this.initNow();
    }

    public SearchComboBox() {
        this.initNow();
    }

    private void initNow() {
        this.skin = (Skin3Field)DefaultSkins.SearchComboBoxTexture.createDynamicSkin();
        this.setLayout(new SearchTextFieldLayout());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            int w = this.skin.getImageRight(this.state).getWidth();
            if (e.getX() > this.getWidth() - w && e.getX() < this.getWidth() && e.getY() > 0 && e.getY() < this.getHeight()) {
                this.wasMouseRelease = true;
                this.initPopup();
            }
            super.mouseReleased(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this) && this.state != Button.ButtonState.FOCUS && this.state != Button.ButtonState.ERROR) {
            if (this.isDown) {
                this.setState(Button.ButtonState.DOWN);
            } else {
                this.setState(Button.ButtonState.OVER);
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED && this.state != Button.ButtonState.FOCUS && this.state != Button.ButtonState.ERROR) {
            this.setState(Button.ButtonState.UP);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            Button.pressedItem = this;
            if (e.getSource() == this) {
                if (e.getX() < this.getWidth() && e.getX() > this.getWidth() - this.skin.getImageRight(this.paintState).getWidth()) {
                    this.isDown = true;
                    this.setState(Button.ButtonState.DOWN);
                } else {
                    this.textField.requestFocusInWindow();
                }
            }
        }
    }

    private void initPopup() {
        if (this.textField.hasFocus()) {
            this.wasMouseRelease = false;
            this.filterValueChanged("");
        } else {
            this.textField.requestFocusInWindow();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED && this.state != Button.ButtonState.ERROR) {
            SelectionManager.getSelectionManager().focusGained(this);
            this.textField.setSelectionStart(0);
            this.textField.setSelectionEnd(this.textField.getText().length());
            this.setState(Button.ButtonState.FOCUS);
            if (this.wasMouseRelease) {
                this.wasMouseRelease = false;
                this.filterValueChanged("");
            } else if (!this.isDown && this.visibleContainer != null) {
                this.visibleContainer.scrollTo(this);
            }
        }
    }

    private class SearchTextFieldLayout
    extends DefaultLayout {
        private SearchTextFieldLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int tailing = 0;
            if (SearchComboBox.this.isSearchActiv) {
                SearchComboBox.this.loaderAnimation.setLocation((int)((double)SearchComboBox.this.getWidth() - (SearchComboBox.this.loaderAnimation.getPreferredSize().getWidth() + 3.0 + (double)SearchComboBox.this.skin.getImageRight(SearchComboBox.this.paintState).getWidth())), (int)(((double)parent.getHeight() - SearchComboBox.this.loaderAnimation.getPreferredSize().getHeight()) / 2.0));
                SearchComboBox.this.loaderAnimation.setSize(SearchComboBox.this.loaderAnimation.getPreferredSize());
                tailing = SearchComboBox.this.loaderAnimation.getWidth() + 5;
            }
            if (SearchComboBox.this.deleteSearchButton != null && SearchComboBox.this.node != null && SearchComboBox.this.node.getValue() != null) {
                if (!SearchComboBox.this.deleteSearchButton.isVisible()) {
                    SearchComboBox.this.deleteSearchButton.fadeIn();
                }
                SearchComboBox.this.deleteSearchButton.setLocation((int)((double)SearchComboBox.this.getWidth() - (SearchComboBox.this.deleteSearchButton.getPreferredSize().getWidth() + 3.0 + (double)SearchComboBox.this.skin.getImageRight(SearchComboBox.this.state).getWidth())), (int)(((double)parent.getHeight() - SearchComboBox.this.deleteSearchButton.getPreferredSize().getHeight()) / 2.0));
                SearchComboBox.this.deleteSearchButton.setSize(SearchComboBox.this.deleteSearchButton.getPreferredSize());
                tailing = SearchComboBox.this.deleteSearchButton.getWidth() + 5;
            } else if (SearchComboBox.this.node != null && SearchComboBox.this.node.getValue() == null && SearchComboBox.this.deleteSearchButton != null) {
                SearchComboBox.this.deleteSearchButton.setVisible(false);
            }
            SearchComboBox.this.textField.setLocation(SearchComboBox.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + 2 + SearchComboBox.this.xOffset, 3);
            SearchComboBox.this.textField.setSize(parent.getWidth() - (SearchComboBox.this.skin.getImageLeft(Button.ButtonState.DISABLED).getWidth() + SearchComboBox.this.skin.getImageRight(Button.ButtonState.DISABLED).getWidth() + 2 + tailing), SearchComboBox.this.skin.getImageMiddle(Button.ButtonState.DISABLED).getHeight() - 6);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(SearchComboBox.this.minWidth, SearchComboBox.this.skin.getImageLeft(Button.ButtonState.DISABLED).getHeight());
        }
    }
}

