/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.skins;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.ISkin;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public abstract class Skin3Field
extends ISkin {
    public void loadNewImages(String left, String right, String middle) {
    }

    public BufferedImage getImage(Button.ButtonState state, Skin3FieldDirection direction) {
        switch (direction) {
            case Left: {
                return this.getImageLeft(state);
            }
            case Middle: {
                return this.getImageMiddle(state);
            }
            case Right: {
                return this.getImageRight(state);
            }
        }
        return null;
    }

    public abstract BufferedImage getImageLeft(Button.ButtonState var1);

    public abstract BufferedImage getImageMiddle(Button.ButtonState var1);

    public abstract BufferedImage getImageRight(Button.ButtonState var1);

    public void paint(Graphics2D g, int _x, int _y, int _width, Button.ButtonState state) {
        int aHeight = 0;
        int theLeftBorder = this.getImageLeft(state).getWidth();
        int theRightBorder = this.getImageRight(state).getWidth();
        aHeight = this.getImage(state, Skin3FieldDirection.Middle).getHeight();
        Graphics2D g2 = g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.drawImage(this.getImage(state, Skin3FieldDirection.Left), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, _x, _y), null);
        Rectangle middle = new Rectangle(0, 0, this.getImageMiddle(state).getWidth(), aHeight);
        g2.setPaint(new TexturePaint(this.getImage(state, Skin3FieldDirection.Middle), middle));
        g2.fillRect(theLeftBorder + _x, _y, _width - (theLeftBorder + theRightBorder), aHeight);
        g2.drawImage(this.getImage(state, Skin3FieldDirection.Right), new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, _width - theRightBorder + _x, _y), null);
    }

    public static enum Skin3FieldDirection {
        Left,
        Middle,
        Right;


        public String toString() {
            switch (this) {
                case Left: {
                    return "11";
                }
                case Middle: {
                    return "12";
                }
                case Right: {
                    return "13";
                }
            }
            return "";
        }
    }
}

