/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tabbed;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.tabbed.TabButton;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import java.awt.Container;
import java.awt.Dimension;

public class TabPaxTypeCheckBoxButton
extends TabButton
implements ButtonListener,
NodeListener {
    private static final long serialVersionUID = 1L;
    private CheckBox selectedPaxType;
    private PaxFigureTypeComplete type;
    private Node<FlightComplete> flight;

    public TabPaxTypeCheckBoxButton(String text, PaxFigureTypeComplete paxType, Node<FlightComplete> currentFlight) {
        super(text);
        this.type = paxType;
        this.flight = currentFlight;
        this.selectedPaxType = new CheckBox();
        this.selectedPaxType.addButtonListener(this);
        this.setLayout(new Layout());
        Node selectedPaxType = this.flight.getChildNamed(FlightComplete_.selectedPaxType);
        if (this.type == null && selectedPaxType != null && selectedPaxType.getValue() == null) {
            if (Boolean.TRUE.equals(this.flight.getChildNamed(FlightLight_.invoicePaxSelected).getValue())) {
                this.selectedPaxType.setChecked(true);
            }
        } else if (this.type != null && selectedPaxType != null && this.type.equals(selectedPaxType.getValue())) {
            this.selectedPaxType.setChecked(true);
        } else {
            this.selectedPaxType.setChecked(false);
        }
        if (selectedPaxType != null) {
            selectedPaxType.addNodeListener((NodeListener)this);
        }
        this.add(this.selectedPaxType);
    }

    @Override
    public void loadImages() {
        if (this.image_texture_active == null) {
            this.image_texture_active = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("gc_stowing_tab_texture_active2"));
            this.image_texture_up = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("gc_stowing_tab_texture_up"));
        }
    }

    @Override
    public void kill() {
        super.kill();
        if (this.flight != null && this.flight.getChildNamed(FlightComplete_.selectedPaxType) != null) {
            this.flight.getChildNamed(FlightComplete_.selectedPaxType).removeNodeListener((NodeListener)this);
        }
        this.flight = null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.selectedPaxType && this.selectedPaxType.isChecked()) {
            this.flight.getChildNamed(FlightComplete_.selectedPaxType).setValue((Object)this.type, 0L);
            if (this.type == null) {
                this.flight.getChildNamed(FlightLight_.invoicePaxSelected).setValue((Object)true, 0L);
            } else {
                this.flight.getChildNamed(FlightLight_.invoicePaxSelected).setValue((Object)false, 0L);
            }
        }
    }

    public void valueChanged(Node<?> node) {
        this.selectedPaxType.setChecked(node.getValue() == this.type);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            TabPaxTypeCheckBoxButton.this.text.setLocation(5, (int)(((double)parent.getHeight() - TabPaxTypeCheckBoxButton.this.text.getPreferredSize().getHeight()) / 2.0));
            TabPaxTypeCheckBoxButton.this.text.setSize(TabPaxTypeCheckBoxButton.this.text.getPreferredSize());
            TabPaxTypeCheckBoxButton.this.selectedPaxType.setLocation(TabPaxTypeCheckBoxButton.this.text.getX() + TabPaxTypeCheckBoxButton.this.text.getWidth() + 7, (int)((double)parent.getHeight() - TabPaxTypeCheckBoxButton.this.selectedPaxType.getPreferredSize().getHeight()) / 2);
            TabPaxTypeCheckBoxButton.this.selectedPaxType.setSize(TabPaxTypeCheckBoxButton.this.selectedPaxType.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, TabPaxTypeCheckBoxButton.this.image_texture_active.getHeight());
        }
    }
}

