/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.AirportConverter;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.FlightLevelConverter;
import ch.icit.pegasus.client.converter.HaulTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.limeflight.OverCateringDescriptorComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.limeflight.OverCateringDescriptorComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightLevelComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class EdelweissOverCateringTable
extends Table2 {
    public EdelweissOverCateringTable() {
        super(true, Words.ADD, true, true);
        this.setTitleText("Over Catering");
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                EdelweissOverCateringTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                OverCateringDescriptorComplete e = new OverCateringDescriptorComplete();
                e.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
                e.setClientOId(Long.valueOf(ADTO.getNextId()));
                EdelweissOverCateringTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)e, true, false), 0L);
                EdelweissOverCateringTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("Flight Level", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Haul Type", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Cabin Class", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Destination", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Flight Code", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Overcatering", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Minimum Pax", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Fix Pax", null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo("Validity", null, null, null, "", TableColumnInfo.periodColumnWidth * 2));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.125);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.125);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.125);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.125);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.2);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.1);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.1);
        ((TableColumnInfo)columns.get(7)).setxExpand(0.1);
        ((TableColumnInfo)columns.get(8)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(9)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private ComboBox level;
        private ComboBox haulType;
        private ComboBox clazz;
        private ComboBox location;
        private TextField flightCode;
        private TextField overCatering;
        private TextField minimumPax;
        private TextField fixPax;
        private TitledPeriodEditor periodEditor;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.TWO);
            this.haulType = new ComboBox(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.haulType), NodeToolkit.getAffixList(HaulTypeComplete.class), ConverterRegistry.getConverter(HaulTypeConverter.class), true);
            this.level = new ComboBox(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.level), NodeToolkit.getAffixList(FlightLevelComplete.class), ConverterRegistry.getConverter(FlightLevelConverter.class), true);
            this.clazz = new ComboBox(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.cabinClass), NodeToolkit.getAffixList(CabinClassComplete.class), ConverterRegistry.getConverter(CabinClassConverter.class), true);
            this.location = new ComboBox(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.destination), NodeToolkit.getAffixList(AirportComplete.class), ConverterRegistry.getConverter(AirportConverter.class), true);
            this.overCatering = new TextField(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.overCatering), TextFieldType.INT);
            this.flightCode = new TextField(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.flightCode));
            this.minimumPax = new TextField(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.minimumPax), TextFieldType.INT);
            this.fixPax = new TextField(this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.fixPaxCount), TextFieldType.INT);
            this.periodEditor = new TitledPeriodEditor((Node<PeriodComplete>)this.model.getNode().getChildNamed(OverCateringDescriptorComplete_.validity), EdelweissOverCateringTable.this.getProvider());
            this.periodEditor.setTitleText("", "");
            this.periodEditor.enableInfinity(false, true);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.haulType);
            this.add(this.level);
            this.add(this.clazz);
            this.add(this.location);
            this.add(this.flightCode);
            this.add(this.overCatering);
            this.add(this.minimumPax);
            this.add(this.fixPax);
            this.add(this.periodEditor);
            this.add(this.delete);
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.level);
            CheckedListAdder.addToList(focusList, this.haulType);
            CheckedListAdder.addToList(focusList, this.clazz);
            CheckedListAdder.addToList(focusList, this.location);
            CheckedListAdder.addToList(focusList, this.flightCode);
            CheckedListAdder.addToList(focusList, this.overCatering);
            CheckedListAdder.addToList(focusList, this.minimumPax);
            CheckedListAdder.addToList(focusList, this.fixPax);
            CheckedListAdder.addToList(focusList, this.periodEditor);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.level.setEnabled(isEnabled);
            this.haulType.setEnabled(isEnabled);
            this.clazz.setEnabled(isEnabled);
            this.location.setEnabled(isEnabled);
            this.flightCode.setEnabled(isEnabled);
            this.overCatering.setEnabled(isEnabled);
            this.minimumPax.setEnabled(isEnabled);
            this.fixPax.setEnabled(isEnabled);
            this.periodEditor.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.clazz.kill();
            this.clazz = null;
            this.level.kill();
            this.level = null;
            this.overCatering.kill();
            this.overCatering = null;
            this.flightCode.kill();
            this.flightCode = null;
            this.location.kill();
            this.location = null;
            this.delete.kill();
            this.delete = null;
            this.minimumPax.kill();
            this.minimumPax = null;
            this.fixPax.kill();
            this.fixPax = null;
            this.periodEditor.kill();
            this.periodEditor = null;
            this.haulType.kill();
            this.haulType = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.level.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.level.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.level.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.level.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.haulType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.haulType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.haulType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.haulType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.clazz.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.clazz.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.clazz.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.clazz.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.location.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.location.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.location.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.location.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.flightCode.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightCode.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightCode.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightCode.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.overCatering.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.overCatering.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.overCatering.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.overCatering.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.minimumPax.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.minimumPax.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.minimumPax.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.minimumPax.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(7);
                TableRowImpl.this.fixPax.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.fixPax.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.fixPax.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.fixPax.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(8);
                TableRowImpl.this.periodEditor.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.periodEditor.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.periodEditor.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.periodEditor.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(9);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

