/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.InternalConsumptionItemNameConverter;
import ch.icit.pegasus.client.converter.InternalConsumptionTypeEConverter;
import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.QuantityConverter3Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionComplete_;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementInformationComplete;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionMovementInformationComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InternalConsumptionInfoTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private final DtoField<List<InternalConsumptionMovementInformationComplete>> accessRight;
    private final RDProvider provider;
    private boolean isNoPro;

    public InternalConsumptionInfoTable(DtoField<List<InternalConsumptionMovementInformationComplete>> accessRight, RDProvider provider) {
        super(false, null, false, false);
        this.accessRight = accessRight;
        this.provider = provider;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)settings);
        this.setUseWriteAccessRight(true);
        this.setProvider(provider);
        this.setOverrideName(accessRight);
        this.setRequestFocusOnAdd(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ITEM_TYPE, Words.ITEM_TYPE, InternalConsumptionTypeEConverter.class, null, InternalConsumptionMovementInformationComplete_.type, TableColumnInfo.departmentWidth, TableColumnInfo.departmentWidth, TableColumnInfo.departmentWidth));
        columns.add(new TableColumnInfo(Words.ITEM_NAME, Words.ITEM_NAME, InternalConsumptionItemNameConverter.class, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo(Words.DATE, Words.VALIDITY_DATE, DateConverter.class, null, InternalConsumptionMovementInformationComplete_.consumptionDate, TableColumnInfo.colorColumnWidth, TableColumnInfo.colorColumnWidth, TableColumnInfo.colorColumnWidth));
        columns.add(new TableColumnInfo(Words.QUANTITY, Words.QUANTITY, QuantityConverter3Decimal.class, null, InternalConsumptionMovementInformationComplete_.quantity, TableColumnInfo.dateColumnWidth * 2, TableColumnInfo.dateColumnWidth * 2, TableColumnInfo.dateColumnWidth * 2));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo(Words.DELETE, Words.DELETE, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.setProgress(1.0f);
    }

    public void setNode(Node<?> node) {
        this.getModel().setNode(node.getChildNamed(InternalConsumptionComplete_.movementDetailInformation));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel type;
        private TextLabel item;
        private TextLabel date;
        private TextLabel quantity;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.type = new TextLabel(m.getNode().getChildNamed(InternalConsumptionMovementInformationComplete_.type), ConverterRegistry.getConverter(InternalConsumptionTypeEConverter.class));
            this.item = new TextLabel(m.getNode(), ConverterRegistry.getConverter(InternalConsumptionItemNameConverter.class));
            this.date = new TextLabel(m.getNode().getChildNamed(InternalConsumptionMovementInformationComplete_.consumptionDate), ConverterRegistry.getConverter(DateConverter.class));
            Converter converter = null;
            converter = InternalConsumptionInfoTable.this.isNoPro ? ConverterRegistry.getConverter(QuantityConverter3Decimal.class) : ConverterRegistry.getConverter(QuantityConverter0Decimal.class);
            this.quantity = new TextLabel(m.getNode().getChildNamed(InternalConsumptionMovementInformationComplete_.quantity), converter);
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.type);
            this.add(this.item);
            this.add(this.date);
            this.add(this.quantity);
            this.add(this.deleteButton);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.type.kill();
            this.item.kill();
            this.date.kill();
            this.quantity.kill();
            this.deleteButton.kill();
            this.type = null;
            this.item = null;
            this.date = null;
            this.quantity = null;
            this.deleteButton = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.deleteButton);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean hasAccess = InternalConsumptionInfoTable.this.getProvider().isWritable(InternalConsumptionInfoTable.this.accessRight);
            boolean enabled = isEnabled && hasAccess;
            this.type.setEnabled(enabled);
            this.item.setEnabled(enabled);
            this.date.setEnabled(enabled);
            this.quantity.setEnabled(enabled);
            this.deleteButton.setEnabled(enabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                InternalConsumptionInfoTable.this.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.type.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.item.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.item.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.item.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.item.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }
}

