/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCookingWasteVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCookingWasteVariantComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class RecipeCookingWasteTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public RecipeCookingWasteTable(Node node) {
        super(true, Words.ADD, true, false, Words.RECEIPTS);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                RecipeCookingWasteTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node<RecipeCookingWasteVariantComplete> createNewNode = RecipeCookingWasteTable.this.createNewNode();
                if (createNewNode != null) {
                    RecipeCookingWasteTable.this.getModel().getNode().addChild(createNewNode, 0L);
                }
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int pw = 2 * this.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        columns.add(new TableColumnInfo(Words.START, null, null, null, "", pw, pw, pw));
        pw = 2 * this.getCellPadding() + DateChooser.getPreferredWidth(this, true);
        columns.add(new TableColumnInfo(Words.END, null, null, null, "", pw, pw, pw));
        columns.add(new TableColumnInfo(Words.TENDER_COOKING_WASTE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.PRODUCTIVE_COOKING_WASTE, null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode(node);
    }

    public Node<RecipeCookingWasteVariantComplete> createNewNode() {
        Table2RowPanel table2RowPanel;
        RecipeCookingWasteVariantComplete waste = new RecipeCookingWasteVariantComplete();
        waste.setClientOId(Long.valueOf(ADTO.getNextId()));
        waste.setUseTenderWaste(Boolean.valueOf(false));
        waste.setDefaultTenderCookingWaste(Double.valueOf(0.0));
        Table2RowPanel table2RowPanel2 = table2RowPanel = this.getRowCount() > 0 ? this.getRows().get(this.getRowCount() - 1) : null;
        if (table2RowPanel != null) {
            Date oldEndDate = (Date)table2RowPanel.getModel().getNode().getChildNamed(new DtoField[]{RecipeCookingWasteVariantComplete_.validity, PeriodComplete_.endDate}).getValue();
            PeriodComplete p = new PeriodComplete();
            p.setStartDate(new Date(System.currentTimeMillis()));
            table2RowPanel.getModel().getNode().getChildNamed(new DtoField[]{RecipeCookingWasteVariantComplete_.validity, PeriodComplete_.endDate}).setValue((Object)new Date(p.getStartDate().getTime() - 1L), 0L);
            waste.setValidity(p);
            p.setEndDate(oldEndDate);
        } else {
            waste.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        }
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)waste, true, false);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private DateChooser start;
        private DateChooser end;
        private CheckBox useTenderWaste;
        private TextField tenderWaste;
        private CheckBox useProductiveWaste;
        private TextField productiveWaste;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.start = new DateChooser(m.getNode().getChildNamed(new DtoField[]{RecipeCookingWasteVariantComplete_.validity, PeriodComplete_.startDate}));
            this.end = new DateChooser();
            this.end.setNeverExpires(true, "");
            this.end.setNode(m.getNode().getChildNamed(new DtoField[]{RecipeCookingWasteVariantComplete_.validity, PeriodComplete_.endDate}));
            this.useTenderWaste = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(RecipeCookingWasteVariantComplete_.useTenderWaste));
            this.tenderWaste = new TextField(m.getNode().getChildNamed(RecipeCookingWasteVariantComplete_.defaultTenderCookingWaste), TextFieldType.DOUBLE);
            this.useTenderWaste.addButtonListener(this);
            this.useProductiveWaste = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(RecipeCookingWasteVariantComplete_.useWaste));
            this.productiveWaste = new TextField(m.getNode().getChildNamed(RecipeCookingWasteVariantComplete_.defaultCookingWaste), TextFieldType.DOUBLE);
            this.useProductiveWaste.addButtonListener(this);
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.start);
            this.add(this.end);
            this.add(this.tenderWaste);
            this.add(this.useTenderWaste);
            this.add(this.productiveWaste);
            this.add(this.useProductiveWaste);
            this.add(this.delete);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            } else {
                this.setEnabled(this.isEnabled());
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.start.setEnabled(isEnabled);
            this.end.setEnabled(isEnabled);
            this.useTenderWaste.setEnabled(isEnabled);
            this.tenderWaste.setEnabled(isEnabled && this.useTenderWaste.isChecked());
            this.useProductiveWaste.setEnabled(isEnabled);
            this.productiveWaste.setEnabled(isEnabled && this.useProductiveWaste.isChecked());
            this.delete.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.start.kill();
            this.end.kill();
            this.useTenderWaste.kill();
            this.tenderWaste.kill();
            this.useProductiveWaste.kill();
            this.productiveWaste.kill();
            this.delete.kill();
            this.start = null;
            this.end = null;
            this.useTenderWaste = null;
            this.tenderWaste = null;
            this.useProductiveWaste = null;
            this.productiveWaste = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.start);
            CheckedListAdder.addToList(a, this.end);
            CheckedListAdder.addToList(a, this.useTenderWaste);
            CheckedListAdder.addToList(a, this.tenderWaste);
            CheckedListAdder.addToList(a, this.useProductiveWaste);
            CheckedListAdder.addToList(a, this.productiveWaste);
            CheckedListAdder.addToList(a, this.delete);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.start.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.start.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.start.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.start.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.end.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.end.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.end.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.end.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.useTenderWaste.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.end.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.useTenderWaste.setSize(TableRowImpl.this.useTenderWaste.getPreferredSize());
                TableRowImpl.this.tenderWaste.setLocation(TableRowImpl.this.useTenderWaste.getX() + TableRowImpl.this.useTenderWaste.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.tenderWaste.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.tenderWaste.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.useTenderWaste.getWidth() + TableRowImpl.this.getInnerCellPadding()), (int)TableRowImpl.this.tenderWaste.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.useProductiveWaste.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.useProductiveWaste.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.useProductiveWaste.setSize(TableRowImpl.this.useProductiveWaste.getPreferredSize());
                TableRowImpl.this.productiveWaste.setLocation(TableRowImpl.this.useProductiveWaste.getX() + TableRowImpl.this.useProductiveWaste.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productiveWaste.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productiveWaste.setSize(w - (2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.useProductiveWaste.getWidth() + TableRowImpl.this.getInnerCellPadding()), (int)TableRowImpl.this.productiveWaste.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

