/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.ReturnWagonStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.ReturnWagonComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.ReturnWagonComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.wagon.ReturnWagonStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ReturnWagonTable
extends Table2 {
    private static final long serialVersionUID = 1L;

    public ReturnWagonTable() {
        super(true, Words.ADD, true, false);
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ReturnWagonTable.this.getParent().revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ReturnWagonComplete returnWagonComplete = new ReturnWagonComplete();
                returnWagonComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                returnWagonComplete.setReturnQuantity(Integer.valueOf(0));
                returnWagonComplete.setReturnState(ReturnWagonStateE.OK);
                Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)returnWagonComplete, true, false);
                ReturnWagonTable.this.getModel().getNode().addChild(node, 0L);
                ReturnWagonTable.this.getParent().revalidate();
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CUSTOMER, null, null, null, "", 10, Integer.MAX_VALUE, 10));
        columns.add(new TableColumnInfo(Words.COUNT, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.SHELF_COUNT, null, null, null, "", 150, 150, 150));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 150, 150, 150));
        int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.getCellPadding();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private SearchTextField2 customerSearch;
        private TextField count;
        private TextField shelfCount;
        private ComboBox state;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.customerSearch = SearchTextField2Factory.getCustomerSearchField(true, m.getNode().getChildNamed(ReturnWagonComplete_.fromCustomer));
            if (m.getNode().getValue() != null) {
                this.customerSearch.resetText();
            }
            this.count = new TextField(m.getNode().getChildNamed(ReturnWagonComplete_.returnQuantity), TextFieldType.INT);
            this.shelfCount = new TextField(m.getNode().getChildNamed(ReturnWagonComplete_.returnShelve), TextFieldType.INT);
            this.state = new ComboBox(m.getNode().getChildNamed(ReturnWagonComplete_.returnState), StaticEnumServiceManager.getReturnWagonStates(), ConverterRegistry.getConverter(ReturnWagonStateEConverter.class));
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.customerSearch);
            this.add(this.deleteButton);
            this.add(this.count);
            this.add(this.state);
            this.add(this.shelfCount);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.customerSearch.kill();
            this.count.kill();
            this.state.kill();
            this.deleteButton.kill();
            this.shelfCount.kill();
            this.customerSearch = null;
            this.deleteButton = null;
            this.count = null;
            this.state = null;
            this.shelfCount = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            a.addAll(this.customerSearch.getFocusComponents());
            a.addAll(this.count.getFocusComponents());
            a.addAll(this.shelfCount.getFocusComponents());
            a.addAll(this.state.getFocusComponents());
            a.addAll(this.deleteButton.getFocusComponents());
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.customerSearch.setEnabled(isEnabled);
            this.deleteButton.setEnabled(isEnabled);
            this.shelfCount.setEnabled(isEnabled);
            this.count.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                ReturnWagonTable.this.getModel().getNode().removeChild(this.model.getNode(), 0L);
            }
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.customerSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.customerSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.customerSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.customerSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.count.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.count.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.shelfCount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.shelfCount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.shelfCount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.shelfCount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
            }
        }
    }
}

