/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;

public class QuantityToolkit {
    public static QuantityComplete add(QuantityComplete q1, QuantityComplete q2) throws Exception {
        Double factor = QuantityToolkit.getConversionFactor(q2.getUnit(), q1.getUnit());
        Double newAmount = q1.getQuantity() + q2.getQuantity() * factor;
        return new QuantityComplete(newAmount, q1.getUnit());
    }

    public static Double getConversionFactor(UnitComplete from, UnitComplete to) throws Exception {
        if (from.equals((Object)to)) {
            return 1.0;
        }
        UnitComplete baseUnitFrom = from;
        Double fromFactor = 1.0;
        Double toFactor = 1.0;
        while (baseUnitFrom.getSuperUnit() != null) {
            fromFactor = fromFactor * (double)baseUnitFrom.getConversionFactor().intValue();
            baseUnitFrom = baseUnitFrom.getSuperUnit();
        }
        UnitComplete baseUnitTo = to;
        while (baseUnitTo.getSuperUnit() != null) {
            toFactor = toFactor * (double)baseUnitTo.getConversionFactor().intValue();
            baseUnitTo = baseUnitTo.getSuperUnit();
        }
        if (!baseUnitTo.getShortName().equals(baseUnitFrom.getShortName())) {
            throw new Exception("Not possible to convert the unit '" + from.getShortName() + "' to unit '" + to.getShortName() + "' ");
        }
        return toFactor / fromFactor;
    }
}

