/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.validator;

import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class ValidationUtil {
    public static List<ScreenValidationObject> validatePeriod(Node<Date> startDate, Node<Date> endDate, Validatable ... guiComponent) {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        if (startDate == null) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date is not set"));
        }
        if (endDate == null) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "End Date is not set"));
        }
        if (rets.isEmpty()) {
            long et;
            long st;
            Date sd = (Date)startDate.getValue();
            Date ed = (Date)endDate.getValue();
            if (sd == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date is not set"));
            }
            if (ed == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "End Date is not set"));
            }
            if (rets.isEmpty() && (st = sd.getTime()) > (et = ed.getTime())) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date must be before End Date"));
            }
        }
        if (guiComponent != null && !rets.isEmpty()) {
            for (Validatable v : guiComponent) {
                v.setInvalid();
            }
        }
        return rets;
    }

    public static List<ScreenValidationObject> validatePeriod(Date startDate, Date endDate, Validatable ... guiComponent) {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        if (startDate == null) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date is not set"));
        }
        if (endDate == null) {
            rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "End Date is not set"));
        }
        if (rets.isEmpty()) {
            long et;
            long st;
            Date sd = startDate;
            Date ed = endDate;
            if (sd == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date is not set"));
            }
            if (ed == null) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "End Date is not set"));
            }
            if (rets.isEmpty() && (st = sd.getTime()) > (et = ed.getTime())) {
                rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Start Date must be before End Date"));
            }
        }
        if (guiComponent != null && !rets.isEmpty()) {
            for (Validatable v : guiComponent) {
                v.setInvalid();
            }
        }
        return rets;
    }
}

