/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui;

import ch.icit.pegasus.client.gui.InternationalizedConverter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class InternationalizedDateConverter
extends InternationalizedConverter {
    public InternationalizedDateConverter() {
        this("{**$day}.{**$month}.{****$year}#DD.MM.YYYY$0123456789DMY$0123456789");
    }

    public InternationalizedDateConverter(String pattern) {
        super(pattern);
    }

    public Object inverseConvert(Object o, Object userObj) {
        Time date = null;
        if (userObj instanceof Time) {
            date = (Time)userObj;
        } else if (userObj instanceof Date) {
            date = new Time(((Date)userObj).getTime());
        } else if (userObj instanceof Timestamp) {
            date = new Time(((Timestamp)userObj).getTime());
        }
        String dString = (String)o;
        if (dString == null || dString.trim().equals("")) {
            return null;
        }
        String day = this.getStringValueOfGroupNamed("day", dString);
        String month = this.getStringValueOfGroupNamed("month", dString);
        String year = this.getStringValueOfGroupNamed("year", dString);
        try {
            int aDay = Integer.valueOf(day);
            int aMonth = Integer.valueOf(month);
            int aYear = Integer.valueOf(year);
            --aMonth;
            Calendar c = TimeUtil.createCalendar();
            if (date != null) {
                c.setTimeInMillis(date.getTime());
            }
            c.set(5, aDay);
            c.set(2, aMonth);
            c.set(1, aYear);
            return new Date(c.getTimeInMillis());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String convert(Object o, Node currentNode, Object ... param) {
        Time d = null;
        if (o instanceof Time) {
            d = (Time)o;
        } else if (o instanceof Date) {
            d = new Time(((Date)o).getTime());
        } else if (o instanceof Timestamp) {
            d = new Time(((Timestamp)o).getTime());
        }
        Calendar c = TimeUtil.createCalendar();
        if (d == null) {
            return "";
        }
        c.setTime(d);
        int d1 = c.get(5);
        int m1 = c.get(2);
        int y1 = c.get(1);
        if (d1 == 6 && m1 == 6 && y1 == 6666) {
            return "\u221e";
        }
        String retString = "";
        for (String pat : this.getAllPatterns()) {
            if (pat.contains("$")) {
                String hS;
                int h;
                if (pat.equals("$day")) {
                    h = c.get(5);
                    hS = "" + h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (pat.equals("$month")) {
                    h = c.get(2);
                    hS = "" + ++h;
                    if (hS.length() == 1) {
                        hS = "0" + hS;
                    }
                    retString = retString + hS;
                    continue;
                }
                if (!pat.equals("$year")) continue;
                h = c.get(1);
                hS = "" + h;
                while (hS.length() < 4) {
                    hS = "0" + hS;
                }
                retString = retString + hS;
                continue;
            }
            retString = retString + pat;
        }
        return retString;
    }

    public boolean validateInput(Object input) {
        String dString = (String)input;
        String day = this.getStringValueOfGroupNamed("day", dString);
        String month = this.getStringValueOfGroupNamed("month", dString);
        String year = this.getStringValueOfGroupNamed("year", dString);
        try {
            int aDay = Integer.valueOf(day);
            int aMonth = Integer.valueOf(month);
            int aYear = Integer.valueOf(year);
            if (aDay < 1 || aDay > 31) {
                return false;
            }
            if (aMonth < 1 || aMonth > 12) {
                return false;
            }
            Calendar c = TimeUtil.createCalendar();
            c.set(5, aDay);
            c.set(2, aMonth - 1);
            c.set(1, aYear);
            long time = c.getTimeInMillis();
            c.setTimeInMillis(time);
            int nDay = c.get(5);
            if (nDay != aDay) {
                return false;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

