/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.hud;

import ch.icit.pegasus.client.gui.hud.view.PhantomButton;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class DragAndDropController
extends JPanelFadable
implements ButtonListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private Point dragStartPosition;
    private Point dragStartButtonLocation;
    private boolean dragStarted;
    private PhantomButton phantomButton;
    private JComponent activeTarget;
    private boolean hidePhantomOverTarget = true;
    private boolean smallerRectangleForButtonHide = true;

    protected abstract List<JComponent> getTargetObjects();

    protected abstract void draggedOverTarget(JComponent var1, JComponent var2);

    protected abstract void draggedOutOfTarget(JComponent var1, JComponent var2);

    protected abstract void mouseReleasedOverTarget(JComponent var1, JComponent var2);

    protected abstract void mouseReleasedNotOverTarget(JComponent var1);

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.dragStartPosition = new Point(e.getX(), e.getY());
        this.dragStartButtonLocation = ((JComponent)e.getSource()).getLocation();
        boolean targetFound = false;
        List<JComponent> targets = this.getTargetObjects();
        for (JComponent target : targets) {
            if (target.getParent() != this || !target.getBounds().contains(SwingUtilities.convertPoint(((JComponent)e.getSource()).getParent(), new Point(e.getX() + ((JComponent)e.getSource()).getX(), e.getY() + ((JComponent)e.getSource()).getY()), this))) continue;
            targetFound = true;
            this.activeTarget = target;
        }
        if (!targetFound) {
            this.activeTarget = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.dragStartPosition == null) {
            this.dragStartPosition = new Point(e.getX(), e.getY());
        }
        int dX = this.dragStartPosition.x - e.getX();
        int dY = this.dragStartPosition.y - e.getY();
        if (this.dragStarted || Math.abs(dX) > 15 || Math.abs(dY) > 15) {
            if (!this.dragStarted) {
                this.phantomButton = this.getPhantomButton((JComponent)e.getSource());
                this.add(this.phantomButton);
                this.setComponentZOrder(this.phantomButton, 0);
                this.dragStarted = true;
                this.phantomButton.setVisible(true);
            }
            boolean targetFound = false;
            this.phantomButton.setLocation(SwingUtilities.convertPoint(((JComponent)e.getSource()).getParent(), new Point(((JComponent)e.getSource()).getX() - dX, ((JComponent)e.getSource()).getY() - dY), this));
            this.phantomButton.getParent().repaint(32L);
            List<JComponent> targets = this.getTargetObjects();
            for (JComponent target : targets) {
                Rectangle favoritesRectangle = target.getBounds();
                if (target.getParent() != this || !favoritesRectangle.contains(SwingUtilities.convertPoint(((JComponent)e.getSource()).getParent(), new Point(e.getX() + ((JComponent)e.getSource()).getX(), e.getY() + ((JComponent)e.getSource()).getY()), this))) continue;
                targetFound = true;
                if (this.smallerRectangleForButtonHide) {
                    int quarterWidth = favoritesRectangle.width / 4;
                    int quarterHeight = favoritesRectangle.height / 4;
                    Rectangle favoritesInnerRectangle = new Rectangle(favoritesRectangle.x + quarterWidth, favoritesRectangle.y + quarterHeight, 2 * quarterWidth, 2 * quarterHeight);
                    if (favoritesInnerRectangle.contains(SwingUtilities.convertPoint(((JComponent)e.getSource()).getParent(), new Point(e.getX() + ((JComponent)e.getSource()).getX(), e.getY() + ((JComponent)e.getSource()).getY()), this))) {
                        this.phantomButton.setVisible(false);
                    } else {
                        this.phantomButton.setVisible(true);
                    }
                }
                if (this.activeTarget == target) continue;
                if (this.activeTarget != null) {
                    this.draggedOutOfTarget(this.activeTarget, (JComponent)e.getSource());
                }
                this.draggedOverTarget(target, (JComponent)e.getSource());
                this.activeTarget = target;
                if (this.isHidePhantomOverTarget((JComponent)e.getSource())) {
                    this.phantomButton.setVisible(true);
                    continue;
                }
                this.phantomButton.setVisible(false);
            }
            if (!targetFound && this.activeTarget != null) {
                this.draggedOutOfTarget(this.activeTarget, (JComponent)e.getSource());
                this.phantomButton.setVisible(true);
                this.activeTarget = null;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.dragStarted) {
            e.consume();
            boolean targetFound = false;
            List<JComponent> targets = this.getTargetObjects();
            for (JComponent target : targets) {
                if (target.getParent() != this || !target.getBounds().contains(SwingUtilities.convertPoint(((JComponent)e.getSource()).getParent(), new Point(e.getX() + ((JComponent)e.getSource()).getX(), e.getY() + ((JComponent)e.getSource()).getY()), this))) continue;
                targetFound = true;
                this.mouseReleasedOverTarget(target, (JComponent)e.getSource());
            }
            if (!targetFound && this.activeTarget != null) {
                this.draggedOutOfTarget(this.activeTarget, (JComponent)e.getSource());
                this.activeTarget = null;
            }
            if (!targetFound) {
                this.mouseReleasedNotOverTarget((JComponent)e.getSource());
            }
            this.dragStarted = false;
            this.remove(this.phantomButton);
            this.repaint(32L);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected boolean isHidePhantomOverTarget(JComponent source) {
        return this.hidePhantomOverTarget;
    }

    protected void setHidePhantomOverTarget(boolean hidePhantomOverTarget) {
        this.hidePhantomOverTarget = hidePhantomOverTarget;
    }

    protected PhantomButton getPhantomButton(JComponent source) {
        BufferedImage image = new BufferedImage(source.getWidth(), source.getHeight(), 1);
        source.paint(image.getGraphics());
        this.phantomButton = new PhantomButton(image);
        this.phantomButton.setSize(source.getWidth(), source.getHeight());
        this.phantomButton.setOpaque(true);
        return this.phantomButton;
    }

    public boolean isDragStarted() {
        return this.dragStarted;
    }
}

