/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.article;

import ch.icit.pegasus.client.gui.modules.article.ArticleModule;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.RetailInMotionServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.StepPriceFunctionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AdditiveCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.AllergenCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleMemberShipTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleOriginComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleProcessingTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HalalCertificationTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.NutritionTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.OtherCharacteristicComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PurchasePriceFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityFactorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchTypeE;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleTenderPriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.ProductionDepthComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionCategoryComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionSpecificationComplete;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.supply.kanban.ArticleKanbanConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArticleModuleDataHandler
extends DefaultDataHandler<BasicArticleReference, BasicArticleComplete> {
    private static final Logger log = LoggerFactory.getLogger(ArticleModuleDataHandler.class);

    public ArticleModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleReference ref = (BasicArticleReference)node.getValue(BasicArticleReference.class);
                BasicArticleComplete art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(ref).getValue();
                if (art.getMaterialCostFactorVariants().isEmpty()) {
                    MaterialCostFactorVariantComplete v1 = new MaterialCostFactorVariantComplete();
                    v1.setClientOId(Long.valueOf(ADTO.getNextId()));
                    v1.setValidityPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), CalendarUtil.getInfinityDate()));
                    art.getMaterialCostFactorVariants().add(v1);
                }
                for (SupplierConditionBaseComplete supplier : art.getSuppliers()) {
                    for (SupplierConditionCategoryComplete conditionCategoryComplete : supplier.getSupplierConditionCategory()) {
                        for (SupplierConditionComplete conditionComplete : conditionCategoryComplete.getConditions()) {
                            if (conditionComplete.getMinOrderAmountUnit() != null) continue;
                            conditionComplete.setMinOrderAmountUnit(art.getMainStoreUnit());
                        }
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)art, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public boolean reloadDataAfterClosing(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleLight artL = (BasicArticleLight)node.getValue(BasicArticleLight.class);
                ArticleModule am = (ArticleModule)ArticleModuleDataHandler.this.tableView;
                BasicArticleSearchConfiguration s = (BasicArticleSearchConfiguration)am.getSearchParameters(null, null, false, false, null);
                s.setNumber(artL.getNumber());
                s.setSearchType(BasicArticleSearchTypeE.ARTICLE_NUMBER);
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)s);
                BasicArticleLight art = (BasicArticleLight)r.getSingleResult();
                node.removeExistingValues();
                node.setValue((Object)art, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public void updateData(final Node<BasicArticleReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                BasicArticleComplete dto = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
                Iterator it = node.getChildNamed(BasicArticleComplete_.kanbanConfigurations).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node kanban = (Node)it.next();
                    StorePositionLight position = (StorePositionLight)kanban.getChildNamed(ArticleKanbanConfigurationComplete_.storePosition).getValue();
                    ((ArticleKanbanConfigurationComplete)kanban.getValue()).setStorePosition(position);
                }
                for (SupplierConditionBaseComplete base : dto.getSuppliers()) {
                    ArticleModuleDataHandler.this.ensureSupplierConditions(dto, base);
                    for (SupplierConditionSpecificationComplete sc : base.getSpecifications()) {
                        if (sc.getSpecFile() == null || sc.getSpecFile().getId() != null || sc.getSpecFile().getLocalFile() != null) continue;
                        sc.setSpecFile(null);
                    }
                }
                if (dto.getCustomerArticleNumber() == null) {
                    dto.setCustomerArticleNumber("");
                }
                for (BasicArticlePriceComplete p : dto.getPrices()) {
                    p.setArticle((BasicArticleReference)dto);
                }
                for (BasicArticleTenderPriceComplete tp : dto.getTenderPrices()) {
                    tp.setArticle((BasicArticleReference)dto);
                }
                for (SupplierConditionBaseComplete base : dto.getSuppliers()) {
                    for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                        for (SupplierConditionComplete condition : category.getConditions()) {
                            condition.setSupplier(base.getSupplier());
                        }
                    }
                }
                BasicArticleComplete nDto = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).updateBasicArticle(dto).getValue();
                node.setValue((Object)nDto, nDto.getId().longValue());
                ArticleModule am = (ArticleModule)ArticleModuleDataHandler.this.tableView;
                BasicArticleSearchConfiguration s = (BasicArticleSearchConfiguration)am.getSearchParameters(null, null, false, false, null);
                s.setNumber(nDto.getNumber());
                SearchResult r = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)s);
                try {
                    BasicArticleLight art = (BasicArticleLight)r.getSingleResult();
                    node.setValue((Object)art, 0L);
                    node.updateNode();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void ensureSupplierConditions(BasicArticleComplete dto, SupplierConditionBaseComplete base) {
        for (SupplierConditionCategoryComplete cat : base.getSupplierConditionCategory()) {
            for (SupplierConditionComplete sc : cat.getConditions()) {
                sc.setSupplier(base.getSupplier());
                if (sc.getOrderUnit() == null) {
                    sc.setOrderUnit(dto.getPriceUnit());
                }
                Timestamp startDate = new Timestamp(sc.getValidity().getStartDate().getTime());
                if (UnitConversionToolkit.isUnitContaining((UnitComplete)dto.getPriceUnit(), (UnitComplete)sc.getOrderUnit(), (BasicArticleLight)dto, (Timestamp)startDate) == 11) {
                    sc.setOrderUnit(dto.getPriceUnit());
                }
                for (StepPriceFunctionComplete step : sc.getStepPrice().getSteps()) {
                    if (step.getUpperLimit().getUnit() == null) {
                        step.getUpperLimit().setUnit(dto.getPriceUnit());
                    }
                    if (UnitConversionToolkit.isUnitContaining((UnitComplete)dto.getPriceUnit(), (UnitComplete)step.getUpperLimit().getUnit(), (BasicArticleLight)dto, (Timestamp)startDate) != 11) continue;
                    step.getUpperLimit().setUnit(dto.getPriceUnit());
                }
            }
        }
        for (SupplierConditionCategoryComplete cats : base.getSupplierConditionCategory()) {
            for (SupplierConditionComplete sc : cats.getConditions()) {
                sc.setSupplier(base.getSupplier());
                if (sc.getOrderUnit() == null) {
                    sc.setOrderUnit(dto.getPriceUnit());
                }
                Timestamp startDate = new Timestamp(sc.getValidity().getStartDate().getTime());
                if (UnitConversionToolkit.isUnitContaining((UnitComplete)dto.getPriceUnit(), (UnitComplete)sc.getOrderUnit(), (BasicArticleLight)dto, (Timestamp)startDate) == 11) {
                    sc.setOrderUnit(dto.getPriceUnit());
                }
                for (StepPriceFunctionComplete step : sc.getStepPrice().getSteps()) {
                    if (step.getUpperLimit().getUnit() == null) {
                        step.getUpperLimit().setUnit(dto.getPriceUnit());
                    }
                    if (UnitConversionToolkit.isUnitContaining((UnitComplete)dto.getPriceUnit(), (UnitComplete)step.getUpperLimit().getUnit(), (BasicArticleLight)dto, (Timestamp)startDate) != 11) continue;
                    step.getUpperLimit().setUnit(dto.getPriceUnit());
                }
            }
        }
    }

    @Override
    public void createNewData(final Node<BasicArticleComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(BasicArticleComplete.class);
                BasicArticleComplete dto = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
                for (BasicArticlePriceComplete p : dto.getPrices()) {
                    p.setArticle((BasicArticleReference)dto);
                }
                for (BasicArticleTenderPriceComplete tp : dto.getTenderPrices()) {
                    tp.setArticle((BasicArticleReference)dto);
                }
                for (SupplierConditionBaseComplete sup : dto.getSuppliers()) {
                    ArticleModuleDataHandler.this.ensureSupplierConditions(dto, sup);
                    for (SupplierConditionSpecificationComplete spec : sup.getSpecifications()) {
                        if (spec.getSpecFile() == null || spec.getSpecFile().getId() != null) continue;
                        spec.setSpecFile(null);
                    }
                }
                for (SupplierConditionBaseComplete base : dto.getSuppliers()) {
                    for (SupplierConditionCategoryComplete category : base.getSupplierConditionCategory()) {
                        for (SupplierConditionComplete condition : category.getConditions()) {
                            condition.setSupplier(base.getSupplier());
                        }
                    }
                }
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                BasicArticleComplete nDto = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createBasicArticle(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleModuleDataHandler.this.setCurrentLoadMaximum(28);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllDateDurations();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AllergenCharacteristicComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(QuantityFactorComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(PurchasePriceFactorComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ProductionDepthComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(TaxZoneComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AdditiveCharacteristicComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OtherCharacteristicComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getStoreConditionTypesNode();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllArticleCommissionTypes();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllArticleCommissionBilledBy();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ArticleMemberShipTypeComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((RetailInMotionServiceManager)ServiceManagerRegistry.getService(RetailInMotionServiceManager.class)).getRetailInMotionSettingsCached();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllArticleStates();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(NutritionCategoryComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(NutritionTypeComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllNutritionStates();
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ArticleProcessingTypeComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ArticleOriginComplete.class);
                ArticleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HalalCertificationTypeComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<BasicArticleComplete> resetData(Node<BasicArticleComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<BasicArticleComplete> createEmptyNode() {
        Node settings = NodeToolkit.getAffixClass(SystemSettingsComplete.class);
        BasicArticleComplete article = new BasicArticleComplete();
        article.setBonded(Boolean.valueOf(false));
        article.setRetailInMotionArticle(Boolean.valueOf(false));
        boolean lsgfc = CompanyUtil.isLSGFC((SystemSettingsComplete)((SystemSettingsComplete)settings.getValue()));
        if (lsgfc) {
            article.setCanCreateTransactions(Boolean.valueOf(false));
        } else {
            article.setCanCreateTransactions(Boolean.valueOf(true));
        }
        PriceComplete price = new PriceComplete();
        price.setCurrency(((SystemSettingsComplete)settings.getValue()).getCurrency());
        UnitComplete pieceUnit = ((SystemSettingsComplete)settings.getValue()).getPieceUnit();
        UnitComplete weightUnit = ((SystemSettingsComplete)settings.getValue()).getDefaultCustomsPenaltyUnit();
        article.setPriceUnit(pieceUnit);
        if (lsgfc) {
            article.setBaseUnit(pieceUnit);
        } else {
            article.setBaseUnit(weightUnit);
        }
        article.setFloatStoreUnit(pieceUnit);
        article.setMainStoreUnit(pieceUnit);
        PackagingQuantityBaseComplete base = new PackagingQuantityBaseComplete();
        base.setPeriod(new PeriodComplete(new Date(CalendarUtil.getDefaultStartDate((boolean)false).getTime()), new Date(CalendarUtil.getInfinityDate().getTime())));
        base.setClientOId(Long.valueOf(ADTO.getNextId()));
        PackagingQuantityComplete q1 = new PackagingQuantityComplete();
        q1.setAmount(Integer.valueOf(1));
        q1.setUnit(pieceUnit);
        q1.setSequenceNumber(Integer.valueOf(0));
        base.getPackingQuantities().add(q1);
        q1 = new PackagingQuantityComplete();
        q1.setAmount(Integer.valueOf(1));
        q1.setUnit(weightUnit.getSubUnit());
        q1.setSequenceNumber(Integer.valueOf(1));
        base.getPackingQuantities().add(q1);
        article.getPackingQuantitiesVariants().add(base);
        ArticleCategoryComplete cat = ((SystemSettingsComplete)settings.getValue()).getDefaultArticleCategory();
        article.setCategory((ArticleCategoryLight)cat);
        price.setPrice(Double.valueOf(0.0));
        BasicArticlePriceComplete np = new BasicArticlePriceComplete();
        np.setClientOId(Long.valueOf(ADTO.getNextId()));
        np.setArticle((BasicArticleReference)article);
        np.setPrice(price);
        np.setValidity(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        article.getPrices().add(np);
        article.setIsInUse(Boolean.valueOf(true));
        article.setNutritionBaseAmount(Double.valueOf(1.0));
        article.setNutritionBaseAmountUnit(article.getBaseUnit());
        MaterialCostFactorVariantComplete v1 = new MaterialCostFactorVariantComplete();
        v1.setClientOId(Long.valueOf(ADTO.getNextId()));
        v1.setValidityPeriod(new PeriodComplete(CalendarUtil.getDefaultStartDate((boolean)true), CalendarUtil.getInfinityDate()));
        article.getMaterialCostFactorVariants().add(v1);
        article.setMaxStock(Integer.valueOf(1));
        article.setMinStock(Integer.valueOf(1));
        article.setPurchaseWaste(Double.valueOf(0.0));
        article.setCookingWaste(Double.valueOf(0.0));
        article.setName("");
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)article, false, false);
        return n;
    }

    @Override
    public Class<BasicArticleComplete> getCommittingClass() {
        return BasicArticleComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<BasicArticleReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

