/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.articlegroup;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.articlegroup.ArticleGroupServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupComplete;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupLight;
import ch.icit.pegasus.server.core.dtos.ordering.articlegroup.ArticleGroupReference;
import ch.icit.pegasus.server.core.dtos.search.ArticleGroupSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;

public class ArticleGroupModuleDataHandler
extends DefaultDataHandler<ArticleGroupLight, ArticleGroupComplete> {
    public ArticleGroupModuleDataHandler(long id, ScreenTableView<ArticleGroupLight, ArticleGroupSearchConfiguration.ARTICLE_GROUP_COLUMN> tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<ArticleGroupLight> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleGroupComplete articleGroup = (ArticleGroupComplete)node.getValue(ArticleGroupComplete.class);
                OptionalWrapper dto = ((ArticleGroupServiceManager)ServiceManagerRegistry.getService(ArticleGroupServiceManager.class)).updateArticleGroup(articleGroup);
                node.removeExistingValues();
                node.setValue((Object)dto.getValue(), 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ArticleGroupComplete> createEmptyNode() {
        ArticleGroupComplete d = new ArticleGroupComplete();
        d.setValidity(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<ArticleGroupComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                node.commit(ArticleGroupComplete.class);
                ArticleGroupComplete dto = (ArticleGroupComplete)node.getValue(ArticleGroupComplete.class);
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                OptionalWrapper nDto = ((ArticleGroupServiceManager)ServiceManagerRegistry.getService(ArticleGroupServiceManager.class)).createArticleGroup(dto);
                node.removeExistingValues();
                node.setValue((Object)nDto.getValue(), System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleGroupModuleDataHandler.this.setCurrentLoadMaximum(2);
                ArticleGroupModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                ArticleGroupModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return ArticleGroupModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<ArticleGroupComplete> resetData(Node<ArticleGroupComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleGroupLight groupLight = (ArticleGroupLight)node.getValue(ArticleGroupLight.class);
                OptionalWrapper articleGroup = ((ArticleGroupServiceManager)ServiceManagerRegistry.getService(ArticleGroupServiceManager.class)).getArticleGroup((ArticleGroupReference)groupLight);
                node.removeExistingValues();
                node.setValue((Object)articleGroup.getValue(), 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<ArticleGroupComplete> getCommittingClass() {
        return ArticleGroupComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<ArticleGroupLight> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

