/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.changenotification.utils;

import ch.icit.pegasus.client.converter.ChangeNotificationAgeConverter;
import ch.icit.pegasus.client.converter.ChangeNotificationTimeAndDestinationConverter;
import ch.icit.pegasus.client.converter.IntegerSignedConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.changenotification.utils.ChangeNotificationPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.DefaultIconComponent_NEW;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.notification.ChangeNotificationServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationLight_;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationReference;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationTypeE;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;

public class ChangeNotificationPanelEntry
extends DefaultPanel
implements Nodable,
NodeListener,
MouseListener {
    private Node<ChangeNotificationLight> node;
    private Font ageFont;
    private Font outBoundFont;
    private Font stdFont;
    private Font messageFont;
    private Font creationFont;
    private Font countFont;
    private ChangeNotificationPanel panel;
    private int verticalHeight = 200;
    private TextLabel age;
    private TextLabel flightCode;
    private TextLabel flightTime;
    private DefaultIconComponent_NEW icon;
    private TextLabel message;
    private TextLabel creationUserName;
    private TextLabel count;
    int border = 20;
    int flightCodeWidth = 300;
    int countWidth = 250;

    public ChangeNotificationPanelEntry(ChangeNotificationPanel panel, int verticalHeight) {
        this.panel = panel;
        this.verticalHeight = verticalHeight;
        Font defaultFont = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        this.ageFont = defaultFont.deriveFont(defaultFont.getStyle(), 40.0f);
        this.outBoundFont = defaultFont.deriveFont(defaultFont.getStyle(), 50.0f);
        this.stdFont = defaultFont.deriveFont(defaultFont.getStyle(), 50.0f);
        this.messageFont = defaultFont.deriveFont(defaultFont.getStyle(), 50.0f);
        this.creationFont = defaultFont.deriveFont(defaultFont.getStyle(), 30.0f);
        this.countFont = defaultFont.deriveFont(defaultFont.getStyle(), 65.0f);
        this.age = new TextLabel(null, ConverterRegistry.getConverter(ChangeNotificationAgeConverter.class));
        this.age.setFont(this.ageFont);
        this.flightCode = new TextLabel();
        this.flightCode.setFont(this.outBoundFont);
        this.flightTime = new TextLabel(null, ConverterRegistry.getConverter(ChangeNotificationTimeAndDestinationConverter.class));
        this.flightTime.setFont(this.stdFont);
        this.message = new TextLabel();
        this.message.setFont(this.messageFont);
        this.creationUserName = new TextLabel();
        this.creationUserName.setFont(this.creationFont);
        this.count = new TextLabel(null, ConverterRegistry.getConverter(IntegerSignedConverter.class));
        this.count.setFont(this.countFont);
        this.countWidth = this.count.getFontMetrics(this.countFont).stringWidth("+77777");
        this.setLayout(new Layout());
        this.add(this.age);
        this.add(this.flightCode);
        this.add(this.flightTime);
        this.add(this.message);
        this.add(this.creationUserName);
        this.add(this.count);
        this.getFader().setProgress(0.0f);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ChangeNotificationPanelEntry.this.switchState();
            }
        });
    }

    @Override
    public String toString() {
        if (this.node != null) {
            return ((ChangeNotificationLight)this.node.getValue(ChangeNotificationLight.class)).getRemark();
        }
        return super.toString();
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = node;
        this.age.setNode((Node)node);
        this.icon = this.getIconForType((ChangeNotificationTypeE)node.getChildNamed(ChangeNotificationLight_.type).getValue());
        this.flightCode.setNode(node.getChildNamed(ChangeNotificationLight_.outboundCode));
        this.flightTime.setNode((Node)node);
        this.message.setNode(node.getChildNamed(ChangeNotificationLight_.remark));
        this.creationUserName.setNode(node.getChildNamed(ChangeNotificationLight_.creationUserName));
        this.count.setNode(node.getChildNamed(ChangeNotificationLight_.difference));
        node.getChildNamed(ChangeNotificationLight_.state).addNodeListener((NodeListener)this);
        if (this.icon != null) {
            this.add(this.icon);
        }
        this.updateTextLabelState();
        this.validate();
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    private void updateTextLabelState() {
        ChangeNotificationLight changeNotification = (ChangeNotificationLight)this.node.getValue();
        this.age.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
        this.flightCode.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
        this.flightTime.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
        this.message.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
        this.creationUserName.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
        this.count.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
        this.icon.setEnabled(changeNotification.getState() == ChangeNotificationStateE.OPEN);
    }

    private void switchState() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                ChangeNotificationLight l = (ChangeNotificationLight)ChangeNotificationPanelEntry.this.node.getValue(ChangeNotificationLight.class);
                try {
                    l = (ChangeNotificationLight)((ChangeNotificationServiceManager)ServiceManagerRegistry.getService(ChangeNotificationServiceManager.class)).invertState(new ChangeNotificationReference(l.getId())).getValue();
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
                ChangeNotificationPanelEntry.this.node.removeExistingValues();
                ChangeNotificationPanelEntry.this.node.setValue((Object)l, 0L);
                ChangeNotificationPanelEntry.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        ChangeNotificationPanelEntry.this.updateTextLabelState();
                        ChangeNotificationPanelEntry.this.repaint(32L);
                        ChangeNotificationPanelEntry.this.validate();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ChangeNotificationPanelEntry.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void paint(Graphics g) {
        ChangeNotificationLight changeNotification = (ChangeNotificationLight)this.node.getValue();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color backgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color"));
        Color foreGroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color"));
        Color color1 = new Color(124, 56, 0);
        Color color2 = new Color(197, 107, 18);
        GradientPaint orange = new GradientPaint(this.getHeight() / 2, 0.0f, color1, this.getHeight() / 2, this.getHeight(), color2, false);
        GradientPaint grey = new GradientPaint(this.getHeight() / 2, -20.0f, foreGroundColor, this.getHeight() / 2, this.getHeight() / 2, backgroundColor, true);
        int arc = 20;
        if (changeNotification.getState() == ChangeNotificationStateE.OPEN) {
            g2.setPaint(orange);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), arc, arc);
        } else {
            g2.setPaint(grey);
        }
        g2.setColor(Color.WHITE);
        g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, arc, arc);
        this.paintChildren(g2);
    }

    @Override
    public void kill() {
        super.kill();
        if (this.age != null) {
            this.age.kill();
        }
        if (this.flightCode != null) {
            this.flightCode.kill();
        }
        if (this.flightTime != null) {
            this.flightTime.kill();
        }
        if (this.message != null) {
            this.message.kill();
        }
        if (this.creationUserName != null) {
            this.creationUserName.kill();
        }
        if (this.count != null) {
            this.count.kill();
        }
        this.panel.uninstall(this);
        this.age = null;
        this.flightCode = null;
        this.flightTime = null;
        this.message = null;
        this.creationUserName = null;
        this.count = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.age.setEnabled(isEnabled);
        this.flightCode.setEnabled(isEnabled);
        this.flightTime.setEnabled(isEnabled);
        this.icon.setEnabled(isEnabled);
        this.message.setEnabled(isEnabled);
        this.creationUserName.setEnabled(isEnabled);
        this.count.setEnabled(isEnabled);
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void valueChanged(Node<?> node) {
        this.repaint(32L);
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?>[] nodes) {
    }

    public boolean isSwingOnly() {
        return false;
    }

    private DefaultIconComponent_NEW getIconForType(ChangeNotificationTypeE type) {
        DefaultSkins icon = null;
        switch (type) {
            case PAX: {
                icon = DefaultSkins.ChangeNotificationPaxIcon;
                break;
            }
            case REGULAR: {
                icon = DefaultSkins.ChangeNotificationRegularIcon;
                break;
            }
            case SPML: {
                icon = DefaultSkins.ChangeNotificationSpmlIcon;
                break;
            }
            case ALACARTE: {
                icon = DefaultSkins.ChangeNotificationAlaCarteIcon;
                break;
            }
            case ADDITIONAL: {
                icon = DefaultSkins.ChangeNotificationAdditionalIcon;
                break;
            }
            case STOWING: {
                icon = DefaultSkins.ChangeNotificationStowingUpdateIcon;
                break;
            }
            case MANUAL: {
                icon = DefaultSkins.ChangeNotificationManualIcon;
            }
        }
        DefaultIconComponent_NEW defaultIconComponent_new = new DefaultIconComponent_NEW(icon);
        defaultIconComponent_new.setUseDisabledState(true);
        return defaultIconComponent_new;
    }

    public void updateAge() {
        this.age.updateString();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.switchState();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentX = ChangeNotificationPanelEntry.this.border * 2;
            int ageWidth = (int)ChangeNotificationPanelEntry.this.age.getPreferredSize().getWidth();
            ChangeNotificationPanelEntry.this.age.setLocation(currentX, (int)(((double)parent.getHeight() - ChangeNotificationPanelEntry.this.age.getPreferredSize().getHeight()) / 2.0));
            ChangeNotificationPanelEntry.this.age.setSize(ageWidth, (int)ChangeNotificationPanelEntry.this.age.getPreferredSize().getHeight());
            currentX += ageWidth;
            double codeHeight = (double)(ChangeNotificationPanelEntry.this.flightCode.getFont().getSize() + ChangeNotificationPanelEntry.this.flightTime.getFont().getSize()) + (double)ChangeNotificationPanelEntry.this.border / 2.0;
            ChangeNotificationPanelEntry.this.flightCode.setLocation(currentX += 2 * ChangeNotificationPanelEntry.this.border, (int)((double)parent.getHeight() - codeHeight) / 2);
            ChangeNotificationPanelEntry.this.flightCode.setSize(ChangeNotificationPanelEntry.this.flightCodeWidth, ChangeNotificationPanelEntry.this.flightCode.getFont().getSize());
            ChangeNotificationPanelEntry.this.flightTime.setLocation(currentX, ChangeNotificationPanelEntry.this.flightCode.getY() + ChangeNotificationPanelEntry.this.flightCode.getFont().getSize() + ChangeNotificationPanelEntry.this.border / 2);
            ChangeNotificationPanelEntry.this.flightTime.setSize(ChangeNotificationPanelEntry.this.flightCodeWidth, ChangeNotificationPanelEntry.this.flightTime.getFont().getSize());
            currentX += ChangeNotificationPanelEntry.this.flightCodeWidth;
            ChangeNotificationPanelEntry.this.icon.setLocation(currentX += ChangeNotificationPanelEntry.this.border, (int)(((double)parent.getHeight() - ChangeNotificationPanelEntry.this.icon.getPreferredSize().getHeight()) / 2.0));
            ChangeNotificationPanelEntry.this.icon.setSize(ChangeNotificationPanelEntry.this.icon.getPreferredSize());
            currentX += ChangeNotificationPanelEntry.this.icon.getWidth();
            int messageWidth = parent.getWidth() - ((currentX += ChangeNotificationPanelEntry.this.border) + ChangeNotificationPanelEntry.this.border + ChangeNotificationPanelEntry.this.countWidth);
            ChangeNotificationPanelEntry.this.message.setLocation(currentX, (int)(((double)parent.getHeight() - ChangeNotificationPanelEntry.this.message.getPreferredSize().getHeight()) / 5.0));
            ChangeNotificationPanelEntry.this.message.setSize(messageWidth, (int)ChangeNotificationPanelEntry.this.message.getPreferredSize().getHeight());
            ChangeNotificationPanelEntry.this.creationUserName.setLocation(currentX, (int)(((double)parent.getHeight() - ChangeNotificationPanelEntry.this.creationUserName.getPreferredSize().getHeight()) / 5.0 * 4.0));
            ChangeNotificationPanelEntry.this.creationUserName.setSize(messageWidth, (int)ChangeNotificationPanelEntry.this.creationUserName.getPreferredSize().getHeight());
            int usedWidth = (int)Math.min((double)ChangeNotificationPanelEntry.this.countWidth, ChangeNotificationPanelEntry.this.count.getPreferredSize().getWidth());
            ChangeNotificationPanelEntry.this.count.setLocation(parent.getWidth() - (usedWidth + ChangeNotificationPanelEntry.this.border), (int)(((double)parent.getHeight() - ChangeNotificationPanelEntry.this.count.getPreferredSize().getHeight()) / 2.0));
            ChangeNotificationPanelEntry.this.count.setSize(usedWidth, (int)ChangeNotificationPanelEntry.this.count.getPreferredSize().getHeight());
        }
    }
}

