/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.article;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CustomsDocumentTypeComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupComplete_;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.store.StockCheckinGroupReference;
import ch.icit.pegasus.server.core.dtos.store.transaction.ManualStockCheckinComplete;
import ch.icit.pegasus.server.core.dtos.store.transaction.remark.ManualStockCheckoutRemarkComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.Iterator;

public class GroupStockCheckinModuleDataHandler
extends DefaultDataHandler<StockCheckinGroupComplete, StockCheckinGroupComplete> {
    public GroupStockCheckinModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener progressListener) {
        this.showMessage(progressListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StockCheckinGroupLight group = (StockCheckinGroupLight)node.getValue(StockCheckinGroupLight.class);
                StockCheckinGroupComplete ngroup = (StockCheckinGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStockCheckinGroup(new StockCheckinGroupReference(group.getId())).getValue();
                for (ManualStockCheckinComplete complete : ngroup.getStockCheckins()) {
                    complete.setArticle(complete.getCharge().getBasicArticle());
                }
                node.removeExistingValues();
                node.setValue((Object)ngroup, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    public void reloadArticle(Node<BasicArticleReference> article, RemoteLoader listener) {
        new BasicArticleLoader((BasicArticleReference)article.getValue(BasicArticleLight.class), listener, article, this);
    }

    @Override
    public void updateData(final Node<StockCheckinGroupComplete> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = node.getChildNamed(StockCheckinGroupComplete_.documents).getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node next = (Node)it.next();
                    if (!(next instanceof DTOProxyNode)) continue;
                    next = ((DTOProxyNode)next).getRefNode();
                    next.commitThis(CustomsDocumentComplete.class);
                }
                node.commitThis(StockCheckinGroupComplete.class);
                StockCheckinGroupComplete g = (StockCheckinGroupComplete)node.getValue(StockCheckinGroupComplete.class);
                StockCheckinGroupComplete gn = (StockCheckinGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStockCheckinGroup(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return System.currentTimeMillis();
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<StockCheckinGroupComplete> createEmptyNode() {
        StockCheckinGroupComplete d = new StockCheckinGroupComplete();
        d.setClientOId(Long.valueOf(ADTO.getNextId()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)d, false, false);
        return n;
    }

    @Override
    public void createNewData(final Node<StockCheckinGroupComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StockCheckinGroupComplete g = (StockCheckinGroupComplete)node.getValue(StockCheckinGroupComplete.class);
                Iterator it = g.getStockCheckins().iterator();
                while (it.hasNext()) {
                    ManualStockCheckinComplete c = (ManualStockCheckinComplete)it.next();
                    if (c.getAmount() != null && (c.getAmount().getAmount() == null || c.getAmount().getAmount() == 0L)) {
                        it.remove();
                        continue;
                    }
                    c.setContainingGroup((StockCheckinGroupReference)g);
                }
                if (g.getEligibleLocations().isEmpty()) {
                    g.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                StockCheckinGroupComplete gn = (StockCheckinGroupComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).createStockCheckinGroup(g).getValue();
                node.removeExistingValues();
                node.setValue((Object)gn, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                GroupStockCheckinModuleDataHandler.this.setCurrentLoadMaximum(7);
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CustomsDocumentTypeComplete.class);
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ManualStockCheckoutRemarkComplete.class);
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                GroupStockCheckinModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return GroupStockCheckinModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<StockCheckinGroupComplete> resetData(Node<StockCheckinGroupComplete> node) {
        StockCheckinGroupComplete n = new StockCheckinGroupComplete();
        n.setClientOId(Long.valueOf(ADTO.getNextId()));
        n.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)n, true, false);
    }

    @Override
    public Class<StockCheckinGroupComplete> getCommittingClass() {
        return StockCheckinGroupComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<StockCheckinGroupComplete> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

