/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.checkin.product.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupComplete;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupLight;
import ch.icit.pegasus.server.core.dtos.production_new.store.product.ProductStockCheckinGroupLight_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<ProductStockCheckinGroupLight>
implements InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> number;
    private TitledItem<RDComboBox> department;
    private TitledItem<RDDateChooser> dateChooser;
    private TitledItem<RDTextField> description;
    private TitledItem<RDMultiLocationComboBox> locations;

    public SpecificationDetailsPanel(RowEditor<ProductStockCheckinGroupLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class)), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.dateChooser = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.CHECKIN_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.description = new TitledItem<RDTextField>(new RDTextField(provider), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider, true), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.number);
        this.addToView(this.department);
        this.addToView(this.dateChooser);
        this.addToView(this.description);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.editor.getModel().getNode().getChildNamed(ProductStockCheckinGroupLight_.name).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_NAME_IS_SET));
            this.name.getElement().setInvalid();
        }
        if (this.editor.getModel().getNode().getChildNamed(ProductStockCheckinGroupLight_.checkinDate).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
            this.dateChooser.getElement().setInvalid();
        }
        if (this.editor.getModel().getNode().getChildNamed(ProductStockCheckinGroupLight_.costCenter).getValue() == null) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DEPARTMENT_IS_SET));
            this.department.getElement().setInvalid();
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.name.setEnabled(isEnabled);
        this.number.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.dateChooser.setEnabled(isEnabled);
        this.description.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.name = null;
        this.number.kill();
        this.number = null;
        this.department.kill();
        this.department = null;
        this.dateChooser.kill();
        this.dateChooser = null;
        this.description.kill();
        this.description = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.dateChooser);
        CheckedListAdder.addToList(focusList, this.description);
        CheckedListAdder.addToList(focusList, this.locations);
        return focusList;
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (node.getChildNamed(ProductStockCheckinGroupLight_.checkinDate).getValue() == null) {
            node.getChildNamed(ProductStockCheckinGroupLight_.checkinDate).setValue((Object)new Date(System.currentTimeMillis()), 0L);
        }
        if (this.editor.getModel().isAddRow()) {
            ProductStockCheckinGroupComplete dto = (ProductStockCheckinGroupComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(ProductStockCheckinGroupLight_.name));
        this.number.getElement().setNode(node.getChildNamed(ProductStockCheckinGroupLight_.number));
        this.dateChooser.getElement().setNode(node.getChildNamed(ProductStockCheckinGroupLight_.checkinDate));
        this.department.getElement().setNode(node.getChildNamed(ProductStockCheckinGroupLight_.costCenter));
        this.department.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
        this.description.getElement().setNode(node.getChildNamed(ProductStockCheckinGroupLight_.description));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(ProductStockCheckinGroupLight_.eligibleLocations));
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.dateChooser.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            int wtl = (parent.getWidth() - 3 * SpecificationDetailsPanel.this.horizontalBorder) / 3;
            SpecificationDetailsPanel.this.name.setSize(wtl * 2, (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY());
            SpecificationDetailsPanel.this.number.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.number.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.dateChooser.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.dateChooser.setSize(SpecificationDetailsPanel.this.dateChooser.getPreferredSize());
            SpecificationDetailsPanel.this.description.setLocation(SpecificationDetailsPanel.this.dateChooser.getX() + SpecificationDetailsPanel.this.dateChooser.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.dateChooser.getY());
            SpecificationDetailsPanel.this.description.setSize(parent.getWidth() - (SpecificationDetailsPanel.this.description.getX() + SpecificationDetailsPanel.this.horizontalBorder), (int)SpecificationDetailsPanel.this.description.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.department.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.dateChooser.getY() + SpecificationDetailsPanel.this.dateChooser.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.department.setSize(220, (int)SpecificationDetailsPanel.this.department.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.department.getY() + SpecificationDetailsPanel.this.department.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
            }
        }
    }
}

