/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dailyops;

import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.util.ArrayList;
import java.util.List;

public class FlightDailyOpsModuleDataHandler
extends FlightModuleDataHandler {
    public FlightDailyOpsModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    public static void openFlights(ADtoSearchConfiguration<FlightLight, ?> searchParameters, LoadingAnimation animation) throws ClientServerCallException {
        SearchResult flights = null;
        searchParameters.setNumResults(Integer.MAX_VALUE);
        ScreenValidationList returns = new ScreenValidationList();
        flights = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search(searchParameters);
        if (flights != null) {
            int count = 1;
            for (FlightLight f : flights.getResults()) {
                if (f.getId() == null) {
                    ArrayList innerErrors = new ArrayList();
                    f.setFlightState(FlightStateE.PLANNED);
                    try {
                        FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(f).getValue();
                        if (fc.getFlightState() == FlightStateE.PLANNED) {
                            fc.setFlightState(FlightStateE.OPEN);
                        }
                        fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(fc, new ListWrapper(innerErrors), fc.getActiveStowingList().getAircraft().getMatriculation()).getValue();
                        for (String t : innerErrors) {
                            returns.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
                        }
                    }
                    catch (ClientServerCallException e) {
                        returns.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.UNABLE_TO_OPEN_FLIGHT, (Object[])new Object[]{f.getOutboundCode()})));
                    }
                }
                ++count;
            }
            if (!returns.isEmpty()) {
                throw new ClientExceptionCollection(Words.ERROR_WHILE_OPENING_FLIGHTS, returns);
            }
        }
    }

    public static void closeFlights(ADtoSearchConfiguration<FlightLight, ?> fsc, LoadingAnimation animation) throws ClientServerCallException {
        SearchResult flights = null;
        fsc.setNumResults(Integer.MAX_VALUE);
        animation.stateChanged(Words.LOAD_FLIGHTS_TO_CLOSE);
        ScreenValidationList returns = new ScreenValidationList();
        flights = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search(fsc);
        if (flights != null) {
            int count = 1;
            for (FlightLight f : flights.getResults()) {
                if (f.getId() != null && f.getFlightState() != FlightStateE.CANCELLED && f.getFlightState() != FlightStateE.CLOSED) {
                    animation.stateChanged(Phrase.getPhrase((String)Phrase.CLOSE_FLIGHT, (Object[])new Object[]{f.getOutboundCode(), count, flights.getResults().size()}));
                    ArrayList innerErrors = new ArrayList();
                    try {
                        FlightComplete fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(f.getId())).getValue();
                        fc.setFlightState(FlightStateE.CLOSED);
                        fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(innerErrors), false, false, false, false).getObject();
                        for (String t : innerErrors) {
                            returns.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, t));
                        }
                    }
                    catch (ClientServerCallException e) {
                        returns.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.UNABLE_TO_CLOSE_FLIGHT, (Object[])new Object[]{f.getOutboundCode()})));
                    }
                }
                ++count;
            }
            if (!returns.isEmpty()) {
                throw new ClientExceptionCollection(Words.ERROR_WHILE_CLOSING_FLIGHTS, returns);
            }
        }
    }

    public static List<ScreenValidationObject> printAllDeliverySlips(FlightSearchConfiguration fsc, LoadingAnimation animation) {
        return null;
    }
}

