/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dailyopskitchen.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.production.ItemSubstitutionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.KitchenOpsAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class FlightDataDetailsPanel
extends DefaultDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 394515865024452764L;
    private TitledItem<RDCheckBox> approve;
    private TitledItem<TextLabel> approvedDate;
    private TitledItem<SearchTextField2<CustomerLight>> customerSearch;

    public FlightDataDetailsPanel(RowEditor editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.FLIGHT_DATA);
        this.approve = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.APPROVE, TitledItem.TitledItemOrientation.EAST);
        this.approvedDate = new TitledItem<TextLabel>(new TextLabel(null, ConverterRegistry.getConverter(DateTimeConverter.class)), Words.APPROVED_AT, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, null), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.approve);
        this.addToView(this.approvedDate);
        this.addToView(this.customerSearch);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean enable = isEnabled;
        if (Boolean.TRUE.equals(this.editor.getModel().getNode().getChildNamed(FlightLight_.substitutionsApproved).getValue())) {
            enable &= this.provider.isWritable(KitchenOpsAccess.EDIT_APPROVED_FLIGHT);
        }
        super.setEnabled(enable);
        this.approve.setEnabled(enable);
        this.approvedDate.setEnabled(enable);
        this.customerSearch.setEnabled(enable);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void validateRemote(List<ScreenValidationObject> callBack) throws ClientServerCallException {
    }

    @Override
    public void setNode(Node<?> node) {
        this.approve.getElement().setNode(node.getChildNamed(FlightLight_.substitutionsApproved));
        this.approvedDate.getElement().setNode(node.getChildNamed(FlightLight_.substitutionsApprovedDate));
        Node customerNode = node.getChildNamed(ItemSubstitutionComplete_.customer);
        if (customerNode == null) {
            customerNode = new DTOProxyNode();
            customerNode.setName(ItemSubstitutionComplete_.customer);
            node.addChild(customerNode, 0L);
        }
        this.customerSearch.getElement().setNode(customerNode);
    }

    @Override
    public List getFocusComponents() {
        return new ArrayList();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(200, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            FlightDataDetailsPanel.this.approve.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.approve.setSize(FlightDataDetailsPanel.this.approve.getPreferredSize());
            FlightDataDetailsPanel.this.approvedDate.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.approve.getY() + FlightDataDetailsPanel.this.approve.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.approvedDate.setSize(FlightDataDetailsPanel.this.approvedDate.getPreferredSize());
            FlightDataDetailsPanel.this.customerSearch.setLocation(FlightDataDetailsPanel.this.horizontalBorder, FlightDataDetailsPanel.this.approvedDate.getY() + FlightDataDetailsPanel.this.approvedDate.getHeight() + FlightDataDetailsPanel.this.verticalBorder);
            FlightDataDetailsPanel.this.customerSearch.setSize(150, (int)FlightDataDetailsPanel.this.customerSearch.getPreferredSize().getHeight());
        }
    }
}

