/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts;

import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.KumaUptimeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.KumaUptimeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.KumaUptimeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.TimeUnitE;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class KumaUptimeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> useKumaUptime;
    private TitledItem<TextField> pushingURL1;
    private TitledItem<TextField> pushingURL2;
    private TablePanelAddSaveButton saveButton;
    private TablePanelAddSaveButton pushButton;
    private final DataExchangeModule module;
    protected Node<KumaUptimeSettingsComplete> settings;
    protected KumaUptimeSettingsComplete arisc;

    public KumaUptimeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.useKumaUptime = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(KumaUptimeSettingsComplete_.useKumaUptime)), "Enable Kuma Uptime", TitledItem.TitledItemOrientation.EAST);
        this.useKumaUptime.getElement().addButtonListener(this);
        this.pushingURL1 = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KumaUptimeSettingsComplete_.publishURL1)), "Push URL 1", TitledItem.TitledItemOrientation.NORTH);
        this.pushingURL2 = new TitledItem<TextField>(new TextField(this.settings.getChildNamed(KumaUptimeSettingsComplete_.publishURL2)), "Push URL 2", TitledItem.TitledItemOrientation.NORTH);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.pushButton = new TablePanelAddSaveButton();
        this.pushButton.setText("Push");
        this.pushButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.useKumaUptime);
        this.configPanel.add(this.pushingURL1);
        this.configPanel.add(this.pushingURL2);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.pushButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                try {
                    KumaUptimeInsert.this.arisc = (KumaUptimeSettingsComplete)((KumaUptimeServiceManager)ServiceManagerRegistry.getService(KumaUptimeServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (KumaUptimeInsert.this.arisc == null) {
                    KumaUptimeSettingsComplete s = new KumaUptimeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    KumaUptimeInsert.this.arisc = s;
                }
                KumaUptimeInsert.this.arisc.setTimerServiceSettings(KumaUptimeInsert.this.createTimerService());
                KumaUptimeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)KumaUptimeInsert.this.arisc, false, false);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return KumaUptimeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerService() {
        TimerServiceSettingsComplete ts = new TimerServiceSettingsComplete();
        ts.setClientOId(Long.valueOf(ADTO.getNextId()));
        ts.setTimerServiceConfig((TimerServiceConfigComplete)new TimeDurationComplete(TimeUnitE.MINUTE, Double.valueOf(2.0)));
        ts.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return ts;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.useKumaUptime.setEnabled(isEnabled);
            boolean b = isEnabled && this.useKumaUptime.getElement().isChecked();
            this.pushingURL1.setEnabled(b);
            this.pushingURL2.setEnabled(b);
            this.saveButton.setEnabled(isEnabled);
            this.pushButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.saveButton.kill();
            this.useKumaUptime.kill();
            this.pushingURL1.kill();
            this.pushingURL2.kill();
            this.pushButton.kill();
        }
        this.pushingURL1 = null;
        this.pushingURL2 = null;
        this.sendPanel = null;
        this.configPanel = null;
        this.saveButton = null;
        this.useKumaUptime = null;
        this.pushButton = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "Kuma Uptime Interface";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.saveButton) {
            this.setEnabled(false);
            this.ensureAnimation(Words.SAVE_DATA);
            this.saveConfig();
            this.module.started();
        } else if (source == this.pushButton) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ((KumaUptimeServiceManager)ServiceManagerRegistry.getService(KumaUptimeServiceManager.class)).pushUptime();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            KumaUptimeInsert.this.setEnabled(true);
                            KumaUptimeInsert.this.hideAnimation();
                            InnerPopupFactory.showMessageDialog("Pushed", KumaUptimeInsert.this);
                        }

                        public void errorOccurred(ClientException exception) {
                            KumaUptimeInsert.this.setEnabled(true);
                            KumaUptimeInsert.this.hideAnimation();
                            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)KumaUptimeInsert.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            this.setEnabled(false);
            this.ensureAnimation("Pushing");
            ThreadSafeLoader.run(run);
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                KumaUptimeInsert.this.settings.commit(KumaUptimeSettingsComplete.class);
                KumaUptimeSettingsComplete arisc = (KumaUptimeSettingsComplete)KumaUptimeInsert.this.settings.getValue();
                if (arisc.getUseKumaUptime().booleanValue()) {
                    arisc.setTimerServiceSettings(KumaUptimeInsert.this.createTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(arisc.getTimerServiceSettings()).getValue();
                    arisc.setTimerServiceSettings(ts);
                    arisc = (KumaUptimeSettingsComplete)((KumaUptimeServiceManager)ServiceManagerRegistry.getService(KumaUptimeServiceManager.class)).updateSettings(arisc).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.KUMA_UPTIME, true, ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.KUMA_UPTIME);
                    arisc = (KumaUptimeSettingsComplete)((KumaUptimeServiceManager)ServiceManagerRegistry.getService(KumaUptimeServiceManager.class)).updateSettings(arisc).getValue();
                    Node s = ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsUnCached();
                    Node node = INodeCreator.getDefaultImpl().getNode4DTO((Object)arisc, false, false);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        KumaUptimeInsert.this.hideAnimation();
                        KumaUptimeInsert.this.module.ended();
                        KumaUptimeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)KumaUptimeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            KumaUptimeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            KumaUptimeInsert.this.useKumaUptime.setLocation(border, border + KumaUptimeInsert.this.configPanel.getTitleHeight());
            KumaUptimeInsert.this.useKumaUptime.setSize(KumaUptimeInsert.this.useKumaUptime.getPreferredSize());
            KumaUptimeInsert.this.pushingURL1.setLocation(KumaUptimeInsert.this.useKumaUptime.getX(), KumaUptimeInsert.this.useKumaUptime.getY() + KumaUptimeInsert.this.useKumaUptime.getHeight() + border * 2);
            KumaUptimeInsert.this.pushingURL1.setSize(400, (int)KumaUptimeInsert.this.pushingURL1.getPreferredSize().getHeight());
            KumaUptimeInsert.this.pushingURL2.setLocation(KumaUptimeInsert.this.useKumaUptime.getX(), KumaUptimeInsert.this.pushingURL1.getY() + KumaUptimeInsert.this.pushingURL1.getHeight() + border);
            KumaUptimeInsert.this.pushingURL2.setSize(400, (int)KumaUptimeInsert.this.pushingURL2.getPreferredSize().getHeight());
            KumaUptimeInsert.this.saveButton.setLocation(border, (int)((double)parent.getHeight() - ((double)border + KumaUptimeInsert.this.saveButton.getPreferredSize().getHeight())));
            KumaUptimeInsert.this.saveButton.setSize(KumaUptimeInsert.this.saveButton.getPreferredSize());
            KumaUptimeInsert.this.pushButton.setLocation(KumaUptimeInsert.this.saveButton.getX() + KumaUptimeInsert.this.saveButton.getWidth() + border, (int)((double)parent.getHeight() - ((double)border + KumaUptimeInsert.this.saveButton.getPreferredSize().getHeight())));
            KumaUptimeInsert.this.pushButton.setSize(KumaUptimeInsert.this.pushButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            KumaUptimeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (KumaUptimeInsert.this.animation != null) {
                KumaUptimeInsert.this.animation.setLocation((int)((double)parent.getWidth() - KumaUptimeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - KumaUptimeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                KumaUptimeInsert.this.animation.setSize(KumaUptimeInsert.this.animation.getPreferredSize());
            }
            if (KumaUptimeInsert.this.isInserted) {
                KumaUptimeInsert.this.configPanel.setLocation(border, border);
                KumaUptimeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                KumaUptimeInsert.this.sendPanel.setLocation(KumaUptimeInsert.this.configPanel.getX() + KumaUptimeInsert.this.configPanel.getWidth() + border, border);
                KumaUptimeInsert.this.sendPanel.setSize(KumaUptimeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

