/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.dataexchange.inserts.edelweiss;

import ch.icit.pegasus.client.converter.EdelweissPurchasePDFExchangeLastUpdateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.dataexchange.DataExchangeModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.panels.BorderedInletPanel;
import ch.icit.pegasus.client.gui.utils.panels.FTPDataExchangeSettingsPanel;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.EdelweissPurchasePDFExportSheetListTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissPurchasePDFExchangeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.DataTransferProtocolE;
import ch.icit.pegasus.server.core.dtos.dataexchange.SFTPDataExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissPurchasePDFExchangeSettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.edelweiss.EdelweissPurchasePDFExchangeSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.edelweiss.stocklevel.EdelweissStockLevelExportComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.EncryptedStringComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class EdelweissPurchasePDFExchangeInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BorderedInletPanel sendPanel;
    private BorderedInletPanel configPanel;
    private TitledItem<CheckBox> active;
    private FTPDataExchangeSettingsPanel ftpPanel;
    private TextLabel lastUpdates;
    private TitledItem<SearchTextField2<CustomerLight>> customer;
    private Node<List<EdelweissStockLevelExportComplete>> stockLevelData;
    private EdelweissPurchasePDFExportSheetListTable history;
    private TablePanelAddSaveButton sendButton;
    private TablePanelAddSaveButton saveButton;
    private final DataExchangeModule module;
    private Node<EdelweissPurchasePDFExchangeSettingsComplete> settings;

    public EdelweissPurchasePDFExchangeInsert(DataExchangeModule module) {
        super(module);
        this.module = module;
    }

    @Override
    public void insertElements() {
        this.configPanel = new BorderedInletPanel(true);
        this.configPanel.setTitleText(Words.CONFIG);
        this.configPanel.setHasBackground(true);
        this.active = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.settings.getChildNamed(EdelweissPurchasePDFExchangeSettingsComplete_.active)), Words.ACTIVE, TitledItem.TitledItemOrientation.EAST);
        this.active.getElement().addButtonListener(this);
        this.ftpPanel = new FTPDataExchangeSettingsPanel();
        this.ftpPanel.setNode(this.settings.getChildNamed(EdelweissPurchasePDFExchangeSettingsComplete_.sendDataExchangeSettings));
        this.lastUpdates = new TextLabel(this.settings, ConverterRegistry.getConverter(EdelweissPurchasePDFExchangeLastUpdateConverter.class));
        this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, this.settings.getChildNamed(EdelweissPurchasePDFExchangeSettingsComplete_.customer)), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.history = new EdelweissPurchasePDFExportSheetListTable();
        this.history.setNode(this.stockLevelData);
        this.sendPanel = new BorderedInletPanel(true);
        this.sendPanel.setTitleText(Words.EXCHANGE_HISTORY);
        this.sendPanel.setHasBackground(true);
        this.sendButton = new TablePanelAddSaveButton();
        this.sendButton.setText(Words.SEND);
        this.sendButton.addButtonListener(this);
        this.saveButton = new TablePanelAddSaveButton();
        this.saveButton.setText(Words.SAVE);
        this.saveButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.sendPanel.setLayout(new SendLayout());
        this.configPanel.setLayout(new ConfigLayout());
        this.configPanel.add(this.ftpPanel);
        this.configPanel.add(this.active);
        this.configPanel.add(this.lastUpdates);
        this.configPanel.add(this.saveButton);
        this.configPanel.add(this.customer);
        this.sendPanel.add(this.history);
        this.sendPanel.add(this.sendButton);
        this.add(this.configPanel);
        this.add(this.sendPanel);
    }

    private void ensureAnimation(String text) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(text);
            this.add((Component)this.animation, 0);
        }
        this.animation.start();
        this.animation.fadeIn();
        this.revalidate();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllTimeDurations();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettings();
                EdelweissPurchasePDFExchangeSettingsComplete esc = null;
                try {
                    esc = (EdelweissPurchasePDFExchangeSettingsComplete)((EdelweissPurchasePDFExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissPurchasePDFExchangeServiceManager.class)).getSettings().getValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (esc == null) {
                    EdelweissPurchasePDFExchangeSettingsComplete s = new EdelweissPurchasePDFExchangeSettingsComplete();
                    s.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc = s;
                }
                if (esc.getSendDataExchangeSettings() == null) {
                    SFTPDataExchangeSettingsComplete c = new SFTPDataExchangeSettingsComplete();
                    c.setClientOId(Long.valueOf(ADTO.getNextId()));
                    esc.setSendDataExchangeSettings(c);
                }
                if (esc.getSendDataExchangeSettings().getLoginPwd() == null) {
                    esc.getSendDataExchangeSettings().setLoginPwd(new EncryptedStringComplete());
                }
                esc.setSendTimerServiceSettings(EdelweissPurchasePDFExchangeInsert.this.createTimerServiceConfig());
                EdelweissPurchasePDFExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)esc, false, false);
                EdelweissPurchasePDFExchangeInsert.this.stockLevelData = (Node)new ViewNode("data");
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return EdelweissPurchasePDFExchangeInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createTimerServiceConfig() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setClientOId(Long.valueOf(ADTO.getNextId()));
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(0), Integer.valueOf(45), Integer.valueOf(0)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    private void hideAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.active.setEnabled(isEnabled);
            boolean b = isEnabled && this.active.getElement().isChecked();
            this.sendButton.setEnabled(b);
            this.ftpPanel.setEnabled(b);
            this.customer.setEnabled(b);
            this.lastUpdates.setEnabled(b);
            this.history.setEnabled(isEnabled);
            this.saveButton.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.sendPanel.kill();
            this.configPanel.kill();
            this.sendButton.kill();
            this.ftpPanel.kill();
            this.history.kill();
            this.lastUpdates.kill();
            this.saveButton.kill();
            this.active.kill();
            this.customer.kill();
        }
        this.sendPanel = null;
        this.configPanel = null;
        this.ftpPanel = null;
        this.sendButton = null;
        this.history = null;
        this.lastUpdates = null;
        this.saveButton = null;
        this.active = null;
        this.customer = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "EDW Purchase PDF Exchange";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.sendButton || source == this.saveButton) {
            this.settings.commit();
            this.setEnabled(false);
            if (source == this.sendButton) {
                this.ensureAnimation(Words.EXCHANGE_DATA_WITH_EDELWEISS);
                this.processFiles(false);
            } else if (source == this.saveButton) {
                List<ScreenValidationObject> a = this.validateESpecsConfig();
                if (a.isEmpty()) {
                    this.ensureAnimation(Words.SAVE_DATA);
                    this.saveConfig();
                } else {
                    InnerPopupFactory.showErrorDialog(a, Words.UNABLE_TO_SAVE, (Component)this);
                    this.setEnabled(true);
                    return;
                }
            }
            this.module.started();
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    private List<ScreenValidationObject> validateESpecsConfig() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        return a;
    }

    private void saveConfig() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                EdelweissPurchasePDFExchangeInsert.this.settings.commit(EdelweissPurchasePDFExchangeSettingsComplete.class);
                EdelweissPurchasePDFExchangeSettingsComplete value = (EdelweissPurchasePDFExchangeSettingsComplete)EdelweissPurchasePDFExchangeInsert.this.settings.getValue();
                value.getSendDataExchangeSettings().setDataExchangeProtocol(DataTransferProtocolE.SFTP);
                value.setSendTimerServiceSettings(EdelweissPurchasePDFExchangeInsert.this.createTimerServiceConfig());
                TimerServiceSettingsComplete sendTS = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(value.getSendTimerServiceSettings()).getValue();
                value.setSendTimerServiceSettings(sendTS);
                value = (EdelweissPurchasePDFExchangeSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateSettings((ADTO)value).getValue();
                ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.EDW_PURCHASE_PDF_EXCHANGE, value.getActive().booleanValue(), sendTS, -1L);
                EdelweissPurchasePDFExchangeInsert.this.settings = INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
                EdelweissPurchasePDFExchangeInsert.this.lastUpdates.setNode(EdelweissPurchasePDFExchangeInsert.this.settings);
                EdelweissPurchasePDFExchangeInsert.this.history.setNode(EdelweissPurchasePDFExchangeInsert.this.stockLevelData);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        EdelweissPurchasePDFExchangeInsert.this.hideAnimation();
                        EdelweissPurchasePDFExchangeInsert.this.module.ended();
                        EdelweissPurchasePDFExchangeInsert.this.setEnabled(true);
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, (Component)EdelweissPurchasePDFExchangeInsert.this);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private void processFiles(boolean read) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((EdelweissPurchasePDFExchangeServiceManager)ServiceManagerRegistry.getService(EdelweissPurchasePDFExchangeServiceManager.class)).sendPDFs();
                EdelweissPurchasePDFExchangeInsert.this.lastUpdates.setNode(EdelweissPurchasePDFExchangeInsert.this.settings);
                return EdelweissPurchasePDFExchangeInsert.this.stockLevelData;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        InnerPopupFactory.showMessageDialog(Words.SUCCESSFULLY_EXPORTED, EdelweissPurchasePDFExchangeInsert.this.sendButton);
                        EdelweissPurchasePDFExchangeInsert.this.hideAnimation();
                        EdelweissPurchasePDFExchangeInsert.this.setEnabled(true);
                        EdelweissPurchasePDFExchangeInsert.this.module.ended();
                    }

                    public void errorOccurred(ClientException exception) {
                        InnerPopupFactory.showErrorDialog((Exception)exception, "Export failed", (Component)EdelweissPurchasePDFExchangeInsert.this.sendButton);
                        EdelweissPurchasePDFExchangeInsert.this.hideAnimation();
                        EdelweissPurchasePDFExchangeInsert.this.setEnabled(true);
                        EdelweissPurchasePDFExchangeInsert.this.module.ended();
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private class ConfigLayout
    extends DefaultLayout {
        private ConfigLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissPurchasePDFExchangeInsert.this.configPanel.layoutTitle(parent);
            int border = 10;
            EdelweissPurchasePDFExchangeInsert.this.active.setLocation(border, border + EdelweissPurchasePDFExchangeInsert.this.configPanel.getTitleHeight());
            EdelweissPurchasePDFExchangeInsert.this.active.setSize(EdelweissPurchasePDFExchangeInsert.this.active.getPreferredSize());
            EdelweissPurchasePDFExchangeInsert.this.ftpPanel.setLocation(border, EdelweissPurchasePDFExchangeInsert.this.active.getY() + EdelweissPurchasePDFExchangeInsert.this.active.getHeight() + border);
            EdelweissPurchasePDFExchangeInsert.this.ftpPanel.setSize(450, (int)EdelweissPurchasePDFExchangeInsert.this.ftpPanel.getPreferredSize().getHeight());
            EdelweissPurchasePDFExchangeInsert.this.lastUpdates.setLocation(border, EdelweissPurchasePDFExchangeInsert.this.ftpPanel.getY() + EdelweissPurchasePDFExchangeInsert.this.ftpPanel.getHeight());
            EdelweissPurchasePDFExchangeInsert.this.lastUpdates.setSize(parent.getWidth() - 2 * border, (int)EdelweissPurchasePDFExchangeInsert.this.lastUpdates.getPreferredSize().getHeight());
            EdelweissPurchasePDFExchangeInsert.this.customer.setLocation(border, EdelweissPurchasePDFExchangeInsert.this.lastUpdates.getY() + EdelweissPurchasePDFExchangeInsert.this.lastUpdates.getHeight() + 5);
            EdelweissPurchasePDFExchangeInsert.this.customer.setSize(parent.getWidth() - 2 * border, (int)EdelweissPurchasePDFExchangeInsert.this.customer.getPreferredSize().getHeight());
            EdelweissPurchasePDFExchangeInsert.this.saveButton.setLocation((int)((double)parent.getWidth() - EdelweissPurchasePDFExchangeInsert.this.saveButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ((double)border + EdelweissPurchasePDFExchangeInsert.this.saveButton.getPreferredSize().getHeight())));
            EdelweissPurchasePDFExchangeInsert.this.saveButton.setSize(EdelweissPurchasePDFExchangeInsert.this.saveButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }
    }

    private class SendLayout
    extends DefaultLayout {
        private SendLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            EdelweissPurchasePDFExchangeInsert.this.sendPanel.layoutTitle(parent);
            int border = 10;
            EdelweissPurchasePDFExchangeInsert.this.history.setLocation(0, EdelweissPurchasePDFExchangeInsert.this.sendPanel.getTitleHeight());
            EdelweissPurchasePDFExchangeInsert.this.history.setSize(parent.getWidth(), EdelweissPurchasePDFExchangeInsert.this.sendPanel.getHeight() - (border + EdelweissPurchasePDFExchangeInsert.this.sendPanel.getTitleHeight() + 100));
            EdelweissPurchasePDFExchangeInsert.this.sendButton.setLocation((int)((double)parent.getWidth() - EdelweissPurchasePDFExchangeInsert.this.sendButton.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - (EdelweissPurchasePDFExchangeInsert.this.sendButton.getPreferredSize().getHeight() + (double)border)));
            EdelweissPurchasePDFExchangeInsert.this.sendButton.setSize(EdelweissPurchasePDFExchangeInsert.this.sendButton.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container arg0) {
            return new Dimension();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (EdelweissPurchasePDFExchangeInsert.this.animation != null) {
                EdelweissPurchasePDFExchangeInsert.this.animation.setLocation((int)((double)parent.getWidth() - EdelweissPurchasePDFExchangeInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - EdelweissPurchasePDFExchangeInsert.this.animation.getPreferredSize().getHeight()) / 2);
                EdelweissPurchasePDFExchangeInsert.this.animation.setSize(EdelweissPurchasePDFExchangeInsert.this.animation.getPreferredSize());
            }
            if (EdelweissPurchasePDFExchangeInsert.this.isInserted) {
                EdelweissPurchasePDFExchangeInsert.this.configPanel.setLocation(border, border);
                EdelweissPurchasePDFExchangeInsert.this.configPanel.setSize((parent.getWidth() - 3 * border) / 2, parent.getHeight() - 2 * border);
                EdelweissPurchasePDFExchangeInsert.this.sendPanel.setLocation(EdelweissPurchasePDFExchangeInsert.this.configPanel.getX() + EdelweissPurchasePDFExchangeInsert.this.configPanel.getWidth() + border, border);
                EdelweissPurchasePDFExchangeInsert.this.sendPanel.setSize(EdelweissPurchasePDFExchangeInsert.this.configPanel.getWidth(), parent.getHeight() - 2 * border);
            }
        }
    }
}

