/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.edelweiss;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.EdelweissImportTypeEConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.PeriodDateTimeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.edelweiss.EdelweissModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.edelweiss.details.EDWFlightsDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.EdelweissDataImportSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportLight;
import ch.icit.pegasus.server.core.dtos.edelweiss.EdelweissDataImportLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.EdelweissAccess;
import ch.icit.pegasus.server.core.dtos.search.ADataImportSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.EdelweissDataImportSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class EdelweissModule
extends ScreenTableView<EdelweissDataImportLight, ADataImportSearchConfiguration.DATA_IMPORT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_STATE = "state_filter";
    private PeriodComplete searchCriteria2 = null;
    private Boolean searchFilter;

    public EdelweissModule() {
        super(EdelweissDataImportLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<EdelweissDataImportLight> model) {
        return true;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return EdelweissAccess.MODULE_EDELWEISS_DATA_IMPORT;
    }

    public EdelweissModuleDataHandler getDataHandler() {
        return (EdelweissModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.DATE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        ComboBox b = ComboBoxFactory.getEdelweissStateComboBox(true);
        this.filterChain.addSelectionComboBox(b, FILTER_STATE, Words.STATE, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodSelection = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), null, true);
        periodSelection.setCheckBoxEnabled();
        periodSelection.setCheckBoxChecked(false);
        periodSelection.setCommitOnFocusLost(true);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<EdelweissDataImportLight, ADataImportSearchConfiguration.DATA_IMPORT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria2 = FilterChainConfiguration.getDefaultSearchPeriod();
        } else if (name == FILTER_DATE) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchCriteria2 = per;
        } else if (name == FILTER_STATE) {
            if (Words.ALL.equals(value)) {
                this.searchFilter = null;
            } else if (Words.VALID.equals(value)) {
                this.searchFilter = true;
            } else if (Words.NOT_ALL_MATCHED.equals(value)) {
                this.searchFilter = false;
            }
        }
        EdelweissDataImportSearchConfiguration c = new EdelweissDataImportSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setPeriod(this.searchCriteria2);
        c.setImportValidity(this.searchFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<EdelweissDataImportLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(EdelweissDataImportSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<EdelweissDataImportLight> model) {
        EdelweissDataImportLight ab = (EdelweissDataImportLight)model.getNode().getValue();
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<EdelweissDataImportLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<EdelweissDataImportLight> rowEditor = new MessageProvidedRowEditor<EdelweissDataImportLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            if (!model.isAddRow()) {
                EDWFlightsDetailsPanel d2 = new EDWFlightsDetailsPanel((RowEditor<EdelweissDataImportLight>)rowEditor, p);
                rowEditor.add(d2, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
                rowEditor.addToFocusQueue(d2);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new EdelweissModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.STATE, "", (Class)BooleanConverter.class, (Enum<?>)ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.IMPORT_VALIDITY, EdelweissDataImportLight_.importValidity, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth));
        info.add(new TableColumnInfo(Words.DESCRIPTION, "", (Class)StringConverter.class, null, EdelweissDataImportLight_.description, 200));
        info.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodDateTimeConverter.class, null, EdelweissDataImportLight_.exactFlightImportPeriod, TableColumnInfo.dateTimeColumnWidth * 2));
        info.add(new TableColumnInfo(Words.PAX, "", (Class)BooleanConverter.class, null, EdelweissDataImportLight_.paxImported, TableColumnInfo.checkBoxColumnWith * 2));
        info.add(new TableColumnInfo(Words.SPML, "", (Class)BooleanConverter.class, null, EdelweissDataImportLight_.specialMealImported, TableColumnInfo.checkBoxColumnWith * 2));
        info.add(new TableColumnInfo(Words.MANUAL, "", (Class)BooleanConverter.class, null, EdelweissDataImportLight_.manualImport, TableColumnInfo.checkBoxColumnWith * 2));
        info.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.DATE, EdelweissDataImportLight_.creationTime, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.NUMBER_OF_DATA, "", (Class)IntegerConverter.class, null, EdelweissDataImportLight_.fileData, 100));
        info.add(new TableColumnInfo(Words.NUMBER_OF_FLIGHTS, "", (Class)IntegerConverter.class, null, EdelweissDataImportLight_.flightsFound, 100));
        info.add(new TableColumnInfo("Number of updated Flights", "", (Class)IntegerConverter.class, null, EdelweissDataImportLight_.updatedFlights, 100));
        info.add(new TableColumnInfo(Words.INTERFACE_TYPE, "", (Class)EdelweissImportTypeEConverter.class, null, EdelweissDataImportLight_.importType, 100));
        return info;
    }
}

