/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.DeliverySpaceConverter;
import ch.icit.pegasus.client.converter.LegNumberConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Killer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.FlightToolkit;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.client.util.toolkits.ProductToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class AdditionalOrderDetailsPanel
extends TableDetailsPanel<FlightLight>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private Node<FlightComplete> root;
    private FlightEditableChecker checker = new FlightEditableChecker();
    private boolean isDeletable = true;
    private boolean isEdiFlight = false;
    private boolean isEdiFlightBlocked = false;

    public AdditionalOrderDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.ADDITIONAL);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        boolean isFpb = CompanyUtil.isFPB((SystemSettingsComplete)this.settings);
        int tc = CheckBox.getPreferredWidth() + this.table.getCellPadding() * 2;
        int index = 0;
        if (!isFpb) {
            columns.add(new TableColumnInfo(Words.PREDEFINED, "", null, null, "", tc, tc, tc));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        columns.add(new TableColumnInfo(Words.LEG, "", null, null, "", 80, 80, 80));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        columns.add(new TableColumnInfo(Words.MEAL_CODE, "", null, null, "", 150, 150, 150));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.2f);
        if (!isFpb) {
            columns.add(new TableColumnInfo(Words.CLASS, "", null, null, "", 150, 150, 150));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        if (!isFpb) {
            columns.add(new TableColumnInfo(Words.EQUIPMENT, "", null, null, "", 150, 150, 150));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.1f);
        }
        columns.add(new TableColumnInfo(Words.COUNT, "", null, null, "", 60, 60, 60));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        FlightLight flightLight = (FlightLight)this.editor.getModel().getNode().getValue(FlightLight.class);
        if (flightLight != null && Boolean.TRUE.equals(flightLight.getCustomer().getUseLotNumber())) {
            columns.add(new TableColumnInfo(isFpb ? Words.DELIVERY_NO : Words.PAX_NAME, "", null, null, "", 80, 80, 80));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
            columns.add(new TableColumnInfo(Words.LOT_NUMBER, "", null, null, "", 40, 40, 40));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.3f);
        } else {
            columns.add(new TableColumnInfo(isFpb ? Words.DELIVERY_NO : Words.PAX_NAME, "", null, null, "", 40, 40, 40));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.3f);
        }
        columns.add(new TableColumnInfo(isFpb ? Words.COMMENT : Words.SEAT_NUMBER, "", null, null, "", 60, 60, 60));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.2f);
        if (!isFpb) {
            columns.add(new TableColumnInfo(Words.LABEL_COLOR, "", null, null, "", 100, 100, 100));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        if (flightLight != null && Boolean.TRUE.equals(flightLight.getCustomer().getShowLabelTextForAdditioinalOrders())) {
            columns.add(new TableColumnInfo(Words.LABEL_TEXT, "", null, null, "", 60, 60, 60));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.2f);
        }
        if (flightLight != null && Boolean.TRUE.equals(flightLight.getCustomer().getShowExpiryDatePerAdditionalOrder())) {
            columns.add(new TableColumnInfo(Words.EXPIRY_DATE, "", null, null, "", TableColumnInfo.dateColumnWidth * 2));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        int delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        delWidth += 2 * this.table.getCellPadding();
        if (!isFpb) {
            columns.add(new TableColumnInfo("", "", null, null, "", delWidth, delWidth, delWidth));
            ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        }
        columns.add(new TableColumnInfo("", "", null, null, "", delWidth, delWidth, delWidth));
        ((TableColumnInfo)columns.get(index++)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setComparator(new Comparator<TableRowEditor>(){

            @Override
            public int compare(TableRowEditor o1, TableRowEditor o2) {
                boolean sortFlightAdditionalOrdersBySequence = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getSortFlightAdditionalsBySequence());
                Node order1 = o1.getModel().getNode();
                Node order2 = o2.getModel().getNode();
                if (sortFlightAdditionalOrdersBySequence) {
                    Integer t1 = (Integer)order1.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                    Integer t2 = (Integer)order2.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                    if (t1 == null) {
                        return t2 == null ? 0 : -1;
                    }
                    if (t2 == null) {
                        return 1;
                    }
                    return t1.compareTo(t2);
                }
                FlightLegComplete l1 = (FlightLegComplete)order1.getChildNamed(AdditionalOrderComplete_.leg).getValue();
                FlightLegComplete l2 = (FlightLegComplete)order2.getChildNamed(AdditionalOrderComplete_.leg).getValue();
                if (l1 == null) {
                    return l2 == null ? 0 : 1;
                }
                if (l2 == null) {
                    return -1;
                }
                int i = l1.compareTo((ALegComplete)l2);
                if (i != 0) {
                    return i;
                }
                CabinClassComplete c1 = (CabinClassComplete)order1.getChildNamed(AdditionalOrderComplete_.cabinClass).getValue();
                CabinClassComplete c2 = (CabinClassComplete)order2.getChildNamed(AdditionalOrderComplete_.cabinClass).getValue();
                if (c1 != null && c2 != null) {
                    i = c1.compareTo(c2);
                }
                if (i != 0) {
                    return i;
                }
                if (order1.getChildNamed(AdditionalOrderComplete_.product).getValue() == null) {
                    return order2.getChildNamed(AdditionalOrderComplete_.product).getValue() == null ? 0 : 1;
                }
                if (order2.getChildNamed(AdditionalOrderComplete_.product).getValue() == null) {
                    return -1;
                }
                Integer t1 = (Integer)order1.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                Integer t2 = (Integer)order2.getChildNamed(AdditionalOrderComplete_.sequenceNumber).getValue();
                if (t1 == null) {
                    return t2 == null ? 0 : -1;
                }
                if (t2 == null) {
                    return 1;
                }
                return t1.compareTo(t2);
            }
        });
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        AdditionalOrderComplete nDto = new AdditionalOrderComplete();
        nDto.setClientOId(Long.valueOf(ADTO.getNextId()));
        nDto.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
        nDto.setCabinClass(settings.getDefaultAdditionalCabinClass());
        nDto.setLabelColor(settings.getDefaultAdditionalLabelColor());
        nDto.setPrintSingleLabels(Boolean.valueOf(Boolean.TRUE.equals(settings.getPrintAdditionalOnSeparateLabel())));
        nDto.setExpiryDate(FlightToolkit.createAdditionalExpiryDate((SystemSettingsComplete)settings, (FlightLight)((FlightLight)this.root.getValue(FlightComplete.class)), null));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nDto, true, false);
        this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
        if (Boolean.FALSE.equals(settings.getSortFlightAdditionalsBySequence())) {
            this.ensureSequenceNo();
        }
    }

    @Override
    public void childRemoved() {
        this.ensureSequenceNo();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowEditor rowPanel = new TableRowEditor(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    private void ensureSequenceNo() {
        int count = 0;
        for (Table2RowPanel table2RowPanel : this.table.getRows()) {
            table2RowPanel.getModel().getNode().getChildNamed(AdditionalOrderComplete_.sequenceNumber).setValue((Object)count, 0L);
            ++count;
        }
    }

    private Node createPossibleCabinClassList() {
        ViewNode possibles = new ViewNode("");
        HashSet<CabinClassComplete> classes = new HashSet<CabinClassComplete>();
        Iterator it = this.root.getChildNamed(FlightLight_.legs).getChilds();
        while (it.hasNext()) {
            Node leg = (Node)it.next();
            Iterator it2 = leg.getChildNamed(FlightLegComplete_.paxFigures).getChilds();
            while (it2.hasNext()) {
                Node f = (Node)it2.next();
                Node clazz = f.getChildNamed(PaxFigureComplete_.cabinClass);
                if (classes.contains(clazz.getValue())) continue;
                classes.add((CabinClassComplete)clazz.getValue());
                possibles.addChild(clazz, 0L);
            }
        }
        return possibles;
    }

    @Override
    public void setNode(Node<?> node) {
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        this.isDeletable = this.provider.isDeletable(FlightComplete_.additionalOrders);
        this.isEdiFlight = Boolean.TRUE.equals(node.getChildNamed(FlightLight_.ediFlight).getValue());
        if (this.isEdiFlight) {
            this.isDeletable = false;
            this.table.setHasAddButton(false);
        }
        this.isEdiFlightBlocked = Boolean.TRUE.equals(node.getChildNamed(FlightLight_.ediFlightBlocked).getValue());
        this.root = node;
        if (this.root != null) {
            Node additionalOrders = this.root.getChildNamed(FlightComplete_.additionalOrders);
            this.table.getModel().setNode(additionalOrders);
        } else {
            this.table.getModel().setNode(null);
        }
        super.setNode(node);
    }

    @Override
    public void setValid(boolean valid) {
        this.table.enableAddButton(valid);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            for (Table2RowPanel rowPanel : this.table.getRows()) {
                TableRowEditor rowPanelImpl = (TableRowEditor)rowPanel;
                List<ScreenValidationObject> warnings = rowPanelImpl.validateRow();
                if (warnings == null) {
                    rowPanelImpl.setValid();
                    continue;
                }
                rowPanelImpl.setInvalid();
                validationObjects.addAll(warnings);
            }
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean editFlight = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(editFlight);
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        for (Table2RowPanel rowPanel : this.table.getRows()) {
            TableRowEditor rowEditor = (TableRowEditor)rowPanel;
            if (!rowEditor.isInnerComponent(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public void updateInserts() {
        for (Table2RowPanel r : this.table.getRows()) {
            TableRowEditor e = (TableRowEditor)r;
            e.updateSelectableInserts();
        }
    }

    @Override
    public boolean hasExpandableContent() {
        if (CompanyUtil.isFPB((SystemSettingsComplete)this.settings)) {
            return true;
        }
        if (this.table != null) {
            return !this.table.getRows().isEmpty();
        }
        return false;
    }

    private class TableRowEditor
    extends Table2RowPanel
    implements NodeListener,
    LafListener,
    ButtonListener,
    SearchTextField2Listener {
        private static final long serialVersionUID = 1L;
        private final boolean isFpb;
        private CheckBox predefined;
        private RDComboBox leg;
        private RDSearchTextField2<ProductComplete> additional;
        private InfoButton info;
        private RDTextField count;
        private RDComboBox cabinClass;
        private RDComboBox space;
        private RDTextField paxName;
        private RDTextField seatNr;
        private RDTextField labelText;
        private RDComboBox labelColor;
        private DeleteButton delete;
        private EditButton priceEdit;
        private RDDateChooser expiryDate;
        private RDTextField lotNumber;
        private final boolean isPriceEditable;
        private final boolean isLabelConfigEditable;

        public TableRowEditor(Table2RowModel m) {
            super(m);
            this.isFpb = CompanyUtil.isFPB((SystemSettingsComplete)AdditionalOrderDetailsPanel.this.settings);
            this.setLayout(new TableRowEditorLayout());
            this.isPriceEditable = AdditionalOrderDetailsPanel.this.provider.isTrue(FlightAccess.EDIT_ADDITIONAL_PRICE);
            this.isLabelConfigEditable = AdditionalOrderDetailsPanel.this.provider.isWritable(AdditionalOrderComplete_.labelText);
            m.getNode().addNodeListener((NodeListener)this);
            this.info = new InfoButton();
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.leg));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.product));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.quantity));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.cabinClass));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.passengerName));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.seatNumber));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.labelText));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.labelColor));
            this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.stowingPosition));
            if (Boolean.TRUE.equals(((FlightLight)AdditionalOrderDetailsPanel.this.editor.getModel().getNode().getValue(FlightLight.class)).getCustomer().getShowExpiryDatePerAdditionalOrder())) {
                this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.expiryDate));
            }
            if (Boolean.TRUE.equals(((FlightLight)AdditionalOrderDetailsPanel.this.editor.getModel().getNode().getValue(FlightLight.class)).getCustomer().getUseLotNumber())) {
                this.childAdded(m.getNode(), m.getNode().getChildNamed(AdditionalOrderComplete_.lotNumber));
            }
            this.lafAttributeChanged("All attribues changed");
            if (AdditionalOrderDetailsPanel.this.isDeletable) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.add(this.delete);
                this.delete.fadeIn();
            }
            if (!this.isFpb) {
                this.priceEdit = new EditButton();
                this.priceEdit.addButtonListener(this);
            }
            if (!this.isFpb) {
                this.predefined = new CheckBox((Node<Boolean>)this.model.getNode().getChildNamed(AdditionalOrderComplete_.predefined));
            }
            if (this.priceEdit != null) {
                this.add(this.priceEdit);
                this.priceEdit.fadeIn();
            }
            this.add(this.info);
            if (this.predefined != null) {
                this.add(this.predefined);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 1: {
                    return this.leg.getStringValue();
                }
                case 2: {
                    if (this.additional.getEditor() != null) {
                        return ((SearchTextField2)this.additional.getEditor()).getText();
                    }
                    if (this.additional.getRenderer() != null) {
                        return ((TextLabel)this.additional.getRenderer()).getText();
                    }
                    return "";
                }
                case 3: {
                    if (this.cabinClass != null) {
                        return this.cabinClass.getStringValue();
                    }
                }
                case 4: {
                    return this.count.getStringValue();
                }
                case 5: {
                    return this.paxName.getStringValue();
                }
                case 6: {
                    if (this.seatNr != null) {
                        return this.seatNr.getStringValue();
                    }
                }
                case 7: {
                    if (this.labelColor == null) break;
                    return this.labelColor.getStringValue();
                }
            }
            return null;
        }

        public void setInvalid() {
        }

        public void setValid() {
            this.additional.setValid();
        }

        public List<ScreenValidationObject> validateRow() {
            Boolean hasSpecialPrice;
            ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
            if (this.model.getNode().getChildNamed(AdditionalOrderComplete_.product).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_PRODUCT_IS_SET));
                this.additional.setInvalid();
            } else {
                this.additional.setValid();
            }
            Integer i = (Integer)this.model.getNode().getChildNamed(AdditionalOrderComplete_.quantity).getValue();
            if (i == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.COUNT_MUST_BE_GREATER_THAN_O_OR_REMOVED));
                this.count.setInvalid();
            } else {
                this.count.setValid();
            }
            if (this.model.getNode().getChildNamed(AdditionalOrderComplete_.leg).getValue() == null) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LEG_IS_SET));
                this.additional.setInvalid();
            } else {
                this.additional.setValid();
            }
            if (this.model.getNode().getChildNamed(AdditionalOrderComplete_.hasSpecialPrice).getValue() != null && (hasSpecialPrice = (Boolean)this.model.getNode().getChildNamed(AdditionalOrderComplete_.hasSpecialPrice).getValue()).booleanValue()) {
                Object value = this.model.getNode().getChildNamed(new DtoField[]{AdditionalOrderComplete_.specialPrice, PriceComplete_.price}).getValue();
                Object currency = this.model.getNode().getChildNamed(new DtoField[]{AdditionalOrderComplete_.specialPrice, PriceComplete_.currency}).getValue();
                if (value == null || currency == null) {
                    validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Additional Orders with special price has a price defined!"));
                }
            }
            return validationObjects;
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (child.getName().equals(AdditionalOrderComplete_.leg.getFieldName())) {
                Node possibleValues = AdditionalOrderDetailsPanel.this.root.getChildNamed(FlightLight_.legs);
                Node possFiltered = LegToolkit.getFlightLegsWithoutDSorNS((Node)possibleValues);
                Converter viewConverter = ConverterRegistry.getConverter(LegNumberConverter.class);
                this.leg = new RDComboBox(AdditionalOrderDetailsPanel.this.provider, viewConverter);
                this.leg.refreshPossibleValues(possFiltered);
                this.leg.setNode(child);
                this.add(this.leg);
                this.leg.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.product.getFieldName())) {
                Node<?> node = child;
                this.additional = new RDSearchTextField2(AdditionalOrderDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.PRODUCT);
                this.additional.setNode(node);
                this.additional.addSearchTextFieldListener(this);
                if (this.additional.getEditor() != null) {
                    Date endDate = new Date(((Timestamp)AdditionalOrderDetailsPanel.this.root.getChildNamed(FlightLight_.sta).getValue()).getTime());
                    Date startDate = new Date(((Timestamp)AdditionalOrderDetailsPanel.this.root.getChildNamed(FlightLight_.std).getValue()).getTime());
                    CustomerLight customer = (CustomerLight)AdditionalOrderDetailsPanel.this.root.getChildNamed(FlightLight_.customer).getValue();
                    Object[] o = new Object[]{startDate, endDate, customer};
                    ((SearchTextField2)this.additional.getEditor()).setAdditionalSearchField(o);
                }
                ProductComplete p = (ProductComplete)node.getValue();
                this.updateInfoButton(p);
                this.add(this.additional);
                this.additional.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.quantity.getFieldName())) {
                this.count = new RDTextField(AdditionalOrderDetailsPanel.this.provider, TextFieldType.INT);
                this.count.setNode(child);
                this.installKeyListener(this.count);
                this.add(this.count);
                this.count.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.cabinClass.getFieldName())) {
                if (this.isFpb) {
                    return;
                }
                Node<?> node = child;
                CabinClassConverter viewConverter = (CabinClassConverter)ConverterRegistry.getConverter(CabinClassConverter.class);
                this.cabinClass = new RDComboBox(AdditionalOrderDetailsPanel.this.provider, (Converter)viewConverter);
                this.cabinClass.refreshPossibleValues(AdditionalOrderDetailsPanel.this.createPossibleCabinClassList());
                this.cabinClass.setNode(node);
                this.add(this.cabinClass);
                this.cabinClass.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.stowingPosition.getFieldName())) {
                if (this.isFpb) {
                    return;
                }
                Node<?> node = child;
                Node possibleValues = NodeToolkit.getAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                DeliverySpaceConverter viewConverter = (DeliverySpaceConverter)ConverterRegistry.getConverter(DeliverySpaceConverter.class);
                this.space = new RDComboBox(AdditionalOrderDetailsPanel.this.provider, (Converter)viewConverter);
                this.space.refreshPossibleValues(possibleValues);
                this.space.setNode(node);
                this.add(this.space);
                this.space.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.passengerName.getFieldName())) {
                this.paxName = new RDTextField(AdditionalOrderDetailsPanel.this.provider);
                this.paxName.setNode(child);
                this.installKeyListener(this.paxName);
                this.add(this.paxName);
                this.paxName.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.labelText.getFieldName())) {
                FlightLight value = (FlightLight)AdditionalOrderDetailsPanel.this.root.getValue(FlightLight.class);
                if (value != null && value.getCustomer() != null && !Boolean.TRUE.equals(value.getCustomer().getShowLabelTextForAdditioinalOrders())) {
                    return;
                }
                this.labelText = new RDTextField(AdditionalOrderDetailsPanel.this.provider);
                this.labelText.setNode(child);
                this.installKeyListener(this.labelText);
                this.add(this.labelText);
                this.labelText.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.labelColor.getFieldName())) {
                if (this.isFpb) {
                    return;
                }
                ColorConverter viewConverter = (ColorConverter)ConverterRegistry.getConverter(ColorConverter.class);
                Node possibleValues = NodeToolkit.getAffixList(ColorComplete.class);
                this.labelColor = new RDComboBox(AdditionalOrderDetailsPanel.this.provider, (Converter)viewConverter, true);
                this.labelColor.refreshPossibleValues(possibleValues);
                this.labelColor.setNode(child);
                this.add(this.labelColor);
                this.labelColor.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.seatNumber.getFieldName())) {
                this.seatNr = new RDTextField(AdditionalOrderDetailsPanel.this.provider);
                this.seatNr.setNode(child);
                this.installKeyListener(this.seatNr);
                this.add(this.seatNr);
                this.seatNr.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.expiryDate.getFieldName())) {
                this.expiryDate = new RDDateChooser(AdditionalOrderDetailsPanel.this.provider);
                this.expiryDate.setNode(child);
                this.add(this.expiryDate);
                this.expiryDate.fadeIn();
            } else if (child.getName().equals(AdditionalOrderComplete_.lotNumber.getFieldName())) {
                this.lotNumber = new RDTextField(AdditionalOrderDetailsPanel.this.provider);
                this.lotNumber.setNode(child);
                this.add(this.lotNumber);
                this.lotNumber.fadeIn();
            }
        }

        private void installKeyListener(final RDTextField count) {
            if (count.getEditor() != null) {
                ((TextField)count.getEditor()).getTextField().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 40) {
                            TableRowEditor.this.selectLowerCountField(count);
                        } else if (e.getKeyCode() == 38) {
                            TableRowEditor.this.selectUpperCountField(count);
                        }
                    }
                });
            }
        }

        private void selectUpperCountField(RDTextField count) {
            int currentRowIndex = AdditionalOrderDetailsPanel.this.table.getRowIndex(this);
            if (currentRowIndex == 0) {
                return;
            }
            TableRowEditor newRow = (TableRowEditor)AdditionalOrderDetailsPanel.this.table.getRowAt(currentRowIndex - 1);
            if (newRow != null && newRow.getModel().getNode().getChildNamed(AdditionalOrderComplete_.product).getValue() != null) {
                if (count == this.count) {
                    newRow.count.requestFocusInWindowNow();
                }
                if (count == this.paxName) {
                    newRow.paxName.requestFocusInWindowNow();
                }
                if (count == this.seatNr) {
                    newRow.seatNr.requestFocusInWindowNow();
                }
                if (count == this.labelText) {
                    newRow.labelText.requestFocusInWindowNow();
                }
            }
        }

        private void selectLowerCountField(RDTextField count) {
            int currentRowIndex = AdditionalOrderDetailsPanel.this.table.getRowIndex(this);
            if (currentRowIndex == AdditionalOrderDetailsPanel.this.table.getRowCount() - 1) {
                return;
            }
            TableRowEditor newRow = (TableRowEditor)AdditionalOrderDetailsPanel.this.table.getRowAt(currentRowIndex + 1);
            if (newRow != null && newRow.getModel().getNode().getChildNamed(AdditionalOrderComplete_.product).getValue() != null) {
                if (count == this.count) {
                    newRow.count.requestFocusInWindowNow();
                }
                if (count == this.paxName) {
                    newRow.paxName.requestFocusInWindowNow();
                }
                if (count == this.seatNr) {
                    newRow.seatNr.requestFocusInWindowNow();
                }
                if (count == this.labelText) {
                    newRow.labelText.requestFocusInWindowNow();
                }
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void valueChanged(Node<?> node) {
        }

        @Override
        public void lafAttributeChanged(String att) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            if (this.count != null) {
                this.count.setFont(f);
            }
            if (this.paxName != null) {
                this.paxName.setFont(f);
            }
            if (this.seatNr != null) {
                this.seatNr.setFont(f);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getParentModel().getNode().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.priceEdit && this.additional.isItemSelected()) {
                InnerPopupFactory.showSpecialPricePopup(source, this.model.getNode(), x, y, null, true, this.isPriceEditable, this.isLabelConfigEditable);
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.leg != null) {
                this.leg.requestFocusInWindowNow();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.leg);
            CheckedListAdder.addToList(focusList, this.additional);
            CheckedListAdder.addToList(focusList, this.info);
            CheckedListAdder.addToList(focusList, this.cabinClass);
            CheckedListAdder.addToList(focusList, this.space);
            CheckedListAdder.addToList(focusList, this.count);
            CheckedListAdder.addToList(focusList, this.paxName);
            CheckedListAdder.addToList(focusList, this.lotNumber);
            CheckedListAdder.addToList(focusList, this.seatNr);
            CheckedListAdder.addToList(focusList, this.labelColor);
            CheckedListAdder.addToList(focusList, this.labelText);
            CheckedListAdder.addToList(focusList, this.expiryDate);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            Node p;
            boolean enableAndReady = isEnabled;
            if (this.model.getNode() != null && (p = this.model.getNode().getChildNamed(AdditionalOrderComplete_.product)) != null) {
                boolean bl = enableAndReady = enableAndReady && p.getValue() != null;
            }
            if (this.predefined != null) {
                this.predefined.setEnabled(false);
            }
            this.leg.setEnabled(isEnabled);
            this.additional.setEnabled(isEnabled && !AdditionalOrderDetailsPanel.this.isEdiFlight);
            this.info.setEnabled(enableAndReady);
            if (this.space != null) {
                this.space.setEnabled(enableAndReady);
            }
            this.count.setEnabled(enableAndReady && !AdditionalOrderDetailsPanel.this.isEdiFlightBlocked);
            if (this.cabinClass != null) {
                this.cabinClass.setEnabled(enableAndReady);
            }
            this.paxName.setEnabled(enableAndReady);
            if (this.lotNumber != null) {
                this.lotNumber.setEnabled(enableAndReady);
            }
            if (this.seatNr != null) {
                this.seatNr.setEnabled(enableAndReady);
            }
            if (this.labelColor != null) {
                this.labelColor.setEnabled(enableAndReady);
            }
            if (this.labelText != null) {
                this.labelText.setEnabled(enableAndReady);
            }
            if (this.expiryDate != null) {
                this.expiryDate.setEnabled(enableAndReady);
            }
            if (this.priceEdit != null) {
                this.priceEdit.setEnabled(enableAndReady && this.isPriceEditable);
            }
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            Killer.kill(this.predefined);
            this.leg.kill();
            this.additional.kill();
            Killer.kill(this.space);
            this.count.kill();
            Killer.kill(this.cabinClass);
            Killer.kill(this.paxName);
            Killer.kill(this.seatNr);
            Killer.kill(this.priceEdit);
            Killer.kill(this.labelColor);
            Killer.kill(this.labelText);
            Killer.kill(this.lotNumber);
            if (this.delete != null) {
                this.delete.kill();
            }
            this.info.kill();
            if (this.expiryDate != null) {
                this.expiryDate.kill();
            }
            this.expiryDate = null;
            this.predefined = null;
            this.leg = null;
            this.space = null;
            this.additional = null;
            this.count = null;
            this.cabinClass = null;
            this.paxName = null;
            this.seatNr = null;
            this.delete = null;
            this.priceEdit = null;
            this.labelColor = null;
            this.labelText = null;
            this.info = null;
            this.lotNumber = null;
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        @Override
        public void newValueSelected(SearchTextField2 source, Node<?> n) {
            this.setEnabled(this.isEnabled());
            if (n.getValue() != null) {
                this.updateInfoButton((ProductComplete)n.getValue());
                this.updateLabelColor((ProductComplete)n.getValue());
                this.updateDeliveryNo((ProductComplete)n.getValue());
                this.updateExpiryDate((ProductComplete)n.getValue());
            }
            AdditionalOrderDetailsPanel.this.editor.createFocusCycle();
        }

        private void updateExpiryDate(ProductComplete p) {
            Date additionalExpiryDate = FlightToolkit.createAdditionalExpiryDate((SystemSettingsComplete)AdditionalOrderDetailsPanel.this.settings, (FlightLight)((FlightLight)AdditionalOrderDetailsPanel.this.editor.getModel().getTypeSafeNode().getValue()), (ProductComplete)p);
            this.model.getNode().getChildNamed(AdditionalOrderComplete_.expiryDate).setValue((Object)additionalExpiryDate, 0L);
        }

        private void updateInfoButton(ProductComplete p) {
            if (p != null) {
                this.info.installStringViewer(ProductToolkit.getProductInfoString(p, p.getCurrentVariant(), 23));
            }
        }

        private void updateLabelColor(ProductComplete p) {
            ColorComplete color;
            if (p != null && Boolean.TRUE.equals(AdditionalOrderDetailsPanel.this.settings.getEnableProductDefaultLabelColor()) && (color = p.getCurrentVariant().getDefaultLabelColor()) != null) {
                this.labelColor.getNode().setValue((Object)color, 0L);
            }
        }

        private void updateDeliveryNo(ProductComplete p) {
            if (p != null && this.isFpb) {
                String no = p.getCurrentVariant().getDefaultDeliveryNumber();
                this.model.getNode().getChildNamed(AdditionalOrderComplete_.passengerName).setValue((Object)no, 0L);
            }
        }

        public void updateSelectableInserts() {
            if (this.space != null) {
                Node possibleValues = NodeToolkit.getAffixNamed((String)((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getAffixNameForClass(AdditionalOrderComplete.class));
                this.space.refreshPossibleValues(possibleValues);
            }
        }

        private class TableRowEditorLayout
        extends DefaultLayout {
            private TableRowEditorLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int h = parent.getHeight();
                int index = 0;
                int w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                if (TableRowEditor.this.predefined != null) {
                    TableRowEditor.this.predefined.setLocation(currentX + TableRowEditor.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowEditor.this.predefined.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.predefined.setSize(TableRowEditor.this.predefined.getPreferredSize());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                TableRowEditor.this.leg.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.leg.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.leg.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.leg.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                TableRowEditor.this.additional.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.additional.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.additional.setSize((int)((double)w - ((double)(2 * TableRowEditor.this.cellPadding + 5) + TableRowEditor.this.info.getPreferredSize().getWidth())), (int)TableRowEditor.this.additional.getPreferredSize().getHeight());
                TableRowEditor.this.info.setLocation(TableRowEditor.this.additional.getX() + TableRowEditor.this.additional.getWidth() + 5, (int)((double)(TableRowEditor.this.additional.getY() + TableRowEditor.this.additional.getHeight()) - (TableRowEditor.this.info.getPreferredSize().getHeight() + 2.0)));
                TableRowEditor.this.info.setSize(TableRowEditor.this.info.getPreferredSize());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                if (TableRowEditor.this.cabinClass != null) {
                    TableRowEditor.this.cabinClass.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.cabinClass.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.cabinClass.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowEditor.this.space != null) {
                    TableRowEditor.this.space.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.space.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.space.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.space.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                TableRowEditor.this.count.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.count.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.count.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.count.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                TableRowEditor.this.paxName.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.paxName.getPreferredSize().getHeight()) / 2.0));
                TableRowEditor.this.paxName.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.paxName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                if (TableRowEditor.this.lotNumber != null) {
                    TableRowEditor.this.lotNumber.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.lotNumber.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.lotNumber.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.lotNumber.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowEditor.this.seatNr != null) {
                    TableRowEditor.this.seatNr.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.seatNr.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.seatNr.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.seatNr.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowEditor.this.labelColor != null) {
                    TableRowEditor.this.labelColor.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.labelColor.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.labelColor.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.labelColor.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowEditor.this.labelText != null) {
                    TableRowEditor.this.labelText.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.labelText.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.labelText.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.labelText.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowEditor.this.expiryDate != null) {
                    TableRowEditor.this.expiryDate.setLocation(currentX + TableRowEditor.this.cellPadding, (int)(((double)h - TableRowEditor.this.expiryDate.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.expiryDate.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.expiryDate.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index++);
                }
                if (TableRowEditor.this.priceEdit != null) {
                    TableRowEditor.this.priceEdit.setLocation((int)((double)currentX + ((double)w - TableRowEditor.this.priceEdit.getPreferredSize().getWidth()) / 2.0), (int)(((double)h - TableRowEditor.this.priceEdit.getPreferredSize().getHeight()) / 2.0));
                    TableRowEditor.this.priceEdit.setSize(w - 2 * TableRowEditor.this.cellPadding, (int)TableRowEditor.this.priceEdit.getPreferredSize().getHeight());
                    currentX += w;
                }
                TableRowEditor.this.setControlsX(currentX);
                if (TableRowEditor.this.delete != null) {
                    w = TableRowEditor.this.model.getParentModel().getColumnWidth(index);
                    if (!TableRowEditor.this.isFpb) {
                        TableRowEditor.this.delete.setLocation((int)((double)currentX + ((double)w - TableRowEditor.this.delete.getPreferredSize().getWidth()) / 2.0), (int)(((double)h - TableRowEditor.this.delete.getPreferredSize().getHeight()) / 2.0));
                    } else {
                        TableRowEditor.this.delete.setLocation(currentX + TableRowEditor.this.cellPadding * 2, (int)(((double)h - TableRowEditor.this.delete.getPreferredSize().getHeight()) / 2.0));
                    }
                    TableRowEditor.this.delete.setSize(TableRowEditor.this.delete.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowEditor.this.getDefaultRowHeight());
            }
        }
    }
}

