/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flight.details.utils;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.popup.myway.TablePopupInsert;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.tracking.EquipmentSealsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PredefineEquipmentSealPopup
extends TablePopupInsert {
    private static final long serialVersionUID = 1L;

    public PredefineEquipmentSealPopup(Node equipments) {
        this.setNode(equipments);
    }

    @Override
    public Table2RowPanel getRowPanel(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    @Override
    public void addButtonPressed(int x, int y) {
    }

    @Override
    public boolean hasAddButton() {
        return false;
    }

    @Override
    public List<TableColumnInfo> getTableColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.EQ, 50, 50, 50));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.SEAL_NO), 50, 50, 50));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.5);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.5);
        return columns;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel eqNo;
        private NumberTextField sealNo;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new Layout());
            this.eqNo = new TextLabel(((EquipmentSealsComplete)m.getNode().getValue()).getEquipment().getPositionCode());
            this.sealNo = new NumberTextField(m.getNode().getChildNamed(DtoFieldConstants.PRE_SEAL_NO), TextFieldType.INT);
            this.add(this.eqNo);
            this.add(this.sealNo);
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.sealNo.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.eqNo.setEnabled(isEnabled);
            this.sealNo.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.eqNo.kill();
            this.eqNo = null;
            this.sealNo.kill();
            this.sealNo = null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.eqNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.eqNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.eqNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.eqNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.sealNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sealNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sealNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sealNo.getPreferredSize().getHeight());
            }
        }
    }
}

