/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.ILegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.system.LocationComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class FlightScheduleModuleDataHandler
extends DefaultDataHandler {
    public FlightScheduleModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node writeNode = node;
                node.commit(FlightScheduleComplete.class);
                FlightScheduleComplete oldDTO = (FlightScheduleComplete)node.getValue(FlightScheduleComplete.class);
                while (oldDTO.getDaysOfWeek().size() > 7) {
                    oldDTO.getDaysOfWeek().remove(oldDTO.getDaysOfWeek().size() - 1);
                }
                for (StowingListConfigurationComplete conf : oldDTO.getStowingLists()) {
                    ArrayList<ALegComplete> legs2Remove = new ArrayList<ALegComplete>();
                    for (ALegComplete l : conf.getLegMapping().keySet()) {
                        ILegComplete vl = (ILegComplete)conf.getLegMapping().get(l);
                        if (oldDTO.getLegs().contains(vl)) continue;
                        legs2Remove.add(l);
                    }
                    for (ALegComplete l : legs2Remove) {
                        conf.getLegMapping().remove(l);
                    }
                }
                SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                if (!s.getAutoCheckout().booleanValue()) {
                    oldDTO.setAutoCheckout(Boolean.valueOf(false));
                }
                if (oldDTO.getKitchenReadyTime() == null) {
                    oldDTO.setKitchenReadyTime(new Time(0, 0, 0));
                }
                if (oldDTO.getStaLeg() != null && !oldDTO.getLegs().contains(oldDTO.getStaLeg())) {
                    oldDTO.setStaLeg(null);
                }
                if (oldDTO.getStdLeg() != null && !oldDTO.getLegs().contains(oldDTO.getStdLeg())) {
                    oldDTO.setStdLeg(null);
                }
                FlightScheduleComplete dto = (FlightScheduleComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateFlightSchedule(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                node.getChildNamed(FlightScheduleComplete_.defaultStowingList).setValue((Object)dto.getDefaultStowingList(), 0L);
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightScheduleComplete oldDTO = (FlightScheduleComplete)node.getValue();
                if (oldDTO.getKitchenReadyTime() == null) {
                    oldDTO.setKitchenReadyTime(new Time(0, 0, 0));
                }
                if (oldDTO.getStaLeg() != null && !oldDTO.getLegs().contains(oldDTO.getStaLeg())) {
                    oldDTO.setStaLeg(null);
                }
                if (oldDTO.getStdLeg() != null && !oldDTO.getLegs().contains(oldDTO.getStdLeg())) {
                    oldDTO.setStdLeg(null);
                }
                if (oldDTO.getEligibleLocations().isEmpty()) {
                    oldDTO.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                FlightScheduleComplete dto = (FlightScheduleComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).createFlightSchedule(oldDTO).getValue();
                node.removeExistingValues();
                node.setValue((Object)dto, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightScheduleModuleDataHandler.this.setCurrentLoadMaximum(13);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllFlightTypes();
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(AirportComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CabinClassComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(SpecialMenuTypeComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllModificationStates();
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllLegTypes();
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(HaulTypeComplete.class);
                FlightScheduleModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(FlightCategoryComplete.class);
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return FlightScheduleModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node resetData(Node node) {
        return this.createEmptyNode();
    }

    @Override
    public Node createEmptyNode() {
        FlightScheduleComplete dto = new FlightScheduleComplete();
        dto.setReturnDay(Integer.valueOf(0));
        dto.setState(ModificationStateE.DRAFT);
        PeriodComplete p = new PeriodComplete();
        p.setClientOId(Long.valueOf(p.getNextId()));
        dto.setPeriod(p);
        dto.getPeriod().setStartDate(new Date(System.currentTimeMillis()));
        dto.getPeriod().setEndDate(new Date(System.currentTimeMillis()));
        dto.setStd(new Time(0, 0, 0));
        dto.setSta(new Time(0, 0, 0));
        dto.setKitchenReadyTime(new Time(0, 0, 0));
        LocationComplete location = (LocationComplete)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue();
        dto.getEligibleLocations().clear();
        dto.getEligibleLocations().add(location);
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, false, false);
        return n;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.REFRESH_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                FlightScheduleLight fsl = (FlightScheduleLight)node.getValue(FlightScheduleLight.class);
                FlightScheduleComplete c = (FlightScheduleComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightSchedule(new FlightScheduleReference(fsl.getId())).getValue();
                HashSet<StowingListTemplateReference> templateIds = new HashSet<StowingListTemplateReference>();
                for (StowingListConfigurationComplete stowingList : c.getStowingLists()) {
                    if (stowingList.getStowingList() != null || stowingList.getStowingListId() == null) continue;
                    templateIds.add(new StowingListTemplateReference(stowingList.getStowingListId()));
                }
                if (!templateIds.isEmpty()) {
                    boolean onlyActive = false;
                    ListWrapper templates = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingListTemplatesComplete(new ListWrapper(new ArrayList(templateIds)), onlyActive);
                    HashMap<Long, StowingListTemplateComplete> templateIndex = new HashMap<Long, StowingListTemplateComplete>();
                    for (StowingListTemplateComplete complete : templates.getList()) {
                        templateIndex.put(complete.getId(), complete);
                    }
                    for (StowingListConfigurationComplete stowingList : c.getStowingLists()) {
                        if (stowingList.getStowingList() != null || stowingList.getStowingListId() == null) continue;
                        stowingList.setStowingList((StowingListTemplateComplete)templateIndex.get(stowingList.getStowingListId()));
                    }
                }
                node.removeExistingValues();
                node.setValue((Object)c, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<?> getCommittingClass() {
        return FlightScheduleComplete.class;
    }

    @Override
    public void doRemoteValidation(Node node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

