/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.flightschedule.details.utils;

import ch.icit.pegasus.client.gui.modules.flight.FlightModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.flight.details.AdditionalOrderDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SpecialMenusDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table2.FootablePanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.ConfigButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.MultiPaxTable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.HorizontalTextureSkin;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.AdditionalOrderComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLegComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.StowagePositionIdentifier;
import ch.icit.pegasus.server.core.dtos.flightschedule.aircraft.AircraftLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.MealPlanConfigurationComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.SpecialMenuTypeComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.ALoadingGroupComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanReference;
import ch.icit.pegasus.server.core.dtos.mealplan.MealplanTemplateLegComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StowingTableFooter
extends FootablePanel
implements ButtonListener,
SearchTextField2Listener {
    private static final Logger log = LoggerFactory.getLogger(StowingTableFooter.class);
    private static final long serialVersionUID = 1L;
    private TitledItem<SearchTextField2> stowingSearch;
    private InfoButton stowingInfo;
    private ConfigButton stowingLegMapping;
    private TitledItem<SearchTextField2> aircraftSearch;
    private ConfigButton aircraftMapping;
    private TitledItem<SearchTextField2> mealPlanSearch;
    private ConfigButton mealPlanMapping;
    private TextButton switchButton;
    private HorizontalTextureSkin skin;
    private Node<Map<MealplanTemplateLegComplete, StowingListTemplateVariantLegComplete>> mpLegMapping = new ViewNode("");
    private Node<Map<ALoadingGroupComplete, ALoadingGroupComplete>> serviceMapping = new ViewNode("");
    private Node<Map<StowagePositionIdentifier, StowagePositionIdentifier>> aircraftMappingNode;
    private Node<Map<StowingListTemplateLegComplete, FlightLegComplete>> stwLegMapping = new ViewNode("");
    private Node<FlightLight> flightNode;
    private boolean flightLegMappingSet;
    private boolean aircraftMappingSet;
    private boolean mealPlanMappingSet;
    private FlightModuleDataHandler dataHandler;
    private SpecialMenusDetailsPanel spmlDetails;
    private AdditionalOrderDetailsPanel additionals;
    SealDefinitionDetailsPanel sealsPanel;
    private RowEditor editor;
    private boolean flightPersited = false;
    private boolean invoiced = false;
    private MultiPaxTable paxTable;
    private Node<StowingListTemplateVariantLight> selectedVariant;

    public StowingTableFooter(FlightModuleDataHandler dataHandler, SpecialMenusDetailsPanel spmlDetails, AdditionalOrderDetailsPanel additionals, SealDefinitionDetailsPanel sealsPanel, MultiPaxTable paxTable, RowEditor editor) {
        this.dataHandler = dataHandler;
        this.paxTable = paxTable;
        this.editor = editor;
        this.skin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.spmlDetails = spmlDetails;
        this.additionals = additionals;
        this.sealsPanel = sealsPanel;
        this.aircraftMappingNode = new ViewNode("");
        this.stowingSearch = new TitledItem<SearchTextField2<StowingListTemplateComplete>>(SearchTextField2Factory.getStowingTemplateSearchField(true, new DTOProxyNode()), Words.STW_TEMPLATE, TitledItem.TitledItemOrientation.WEST);
        this.stowingSearch.getElement().addSearchTextFieldListener(this);
        this.stowingInfo = new InfoButton();
        this.stowingInfo.addButtonListener(this);
        this.stowingLegMapping = new ConfigButton();
        this.stowingLegMapping.addButtonListener(this);
        this.aircraftSearch = new TitledItem<SearchTextField2<AircraftLight>>(SearchTextField2Factory.getAircraftSearchField(true, new DTOProxyNode()), Words.AIRCRAFT, TitledItem.TitledItemOrientation.WEST);
        this.aircraftSearch.getElement().addSearchTextFieldListener(this);
        this.aircraftMapping = new ConfigButton();
        this.aircraftMapping.addButtonListener(this);
        this.mealPlanSearch = new TitledItem<SearchTextField2<MealPlanLight>>(SearchTextField2Factory.getMealplanSearchField(true, new DTOProxyNode()), Words.MEALPLAN, TitledItem.TitledItemOrientation.WEST);
        this.mealPlanSearch.getElement().addSearchTextFieldListener(this);
        this.mealPlanMapping = new ConfigButton();
        this.mealPlanMapping.addButtonListener(this);
        this.switchButton = new TextButton(Words.SWITCH);
        this.switchButton.addButtonListener(this);
        this.stowingSearch.setIgnorePrefWidth(true);
        this.aircraftSearch.setIgnorePrefWidth(true);
        this.mealPlanSearch.setIgnorePrefWidth(true);
        this.stowingSearch.setInnerGap(5);
        this.aircraftSearch.setInnerGap(5);
        this.mealPlanSearch.setInnerGap(5);
        this.setLayout(new Layout());
        this.add(this.stowingSearch);
        this.add(this.stowingInfo);
        this.add(this.stowingLegMapping);
        this.add(this.aircraftSearch);
        this.add(this.aircraftMapping);
        this.add(this.mealPlanSearch);
        this.add(this.mealPlanMapping);
        this.add(this.switchButton);
    }

    @Override
    public Node<?> getNode() {
        return this.flightNode;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, 0, this.getWidth(), 11);
        this.paintChildren(g2);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean b = isEnabled && this.flightPersited && !this.invoiced;
        this.stowingSearch.setEnabled(b);
        b = this.stowingSearch.getElement().isItemSelected() && b;
        this.stowingInfo.setEnabled(b);
        this.stowingLegMapping.setEnabled(b);
        this.aircraftSearch.setEnabled(b);
        this.aircraftMapping.setEnabled(b);
        this.mealPlanSearch.setEnabled(b);
        this.mealPlanMapping.setEnabled(b);
        this.switchButton.setEnabled(b);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.stowingSearch.kill();
        this.stowingSearch = null;
        this.stowingInfo.kill();
        this.stowingInfo = null;
        this.stowingLegMapping.kill();
        this.stowingLegMapping = null;
        this.aircraftSearch.kill();
        this.aircraftSearch = null;
        this.aircraftMapping.kill();
        this.aircraftMapping = null;
        this.mealPlanSearch.kill();
        this.mealPlanSearch = null;
        this.mealPlanMapping.kill();
        this.mealPlanMapping = null;
        this.switchButton.kill();
        this.switchButton = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.stowingSearch);
        CheckedListAdder.addToList(a, this.aircraftSearch);
        CheckedListAdder.addToList(a, this.mealPlanSearch);
        CheckedListAdder.addToList(a, this.switchButton);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.stowingSearch.setVisibleContainer(pane);
        this.aircraftSearch.setVisibleContainer(pane);
        this.mealPlanSearch.setVisibleContainer(pane);
        this.switchButton.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.stowingSearch.requestFocusInWindowNow();
    }

    @Override
    public void setNode(Node<?> node) {
        this.flightNode = node;
        if (this.flightNode != null) {
            this.flightPersited = this.flightNode.getChildNamed(ADTO.ID_).getValue() != null;
            Node invoicedNode = this.flightNode.getChildNamed(FlightLight_.isInvoiceClosed);
            Boolean b = invoicedNode != null ? (Boolean)invoicedNode.getValue() : null;
            this.invoiced = Boolean.TRUE.equals(b);
        } else {
            this.invoiced = false;
        }
        this.flightLegMappingSet = false;
        this.aircraftMappingSet = false;
        this.mealPlanMappingSet = false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (!this.stowingSearch.getElement().isItemSelected()) {
            return;
        }
        if (source == this.stowingInfo) {
            Node sNode = this.stowingSearch.getElement().getNode();
            InnerPopupFactory.showStowingListInfoPopup(this.stowingInfo, (IStowingListLight)((StowingListTemplateComplete)sNode.getValue()).getCurrentVariant(), x, y);
        } else if (source == this.aircraftMapping) {
            InnerPopupFactory.showAircraftMappingPopup(source, this.selectedVariant, this.aircraftSearch.getElement().getNode(), this.aircraftMappingNode, !this.aircraftMappingSet);
            this.aircraftMappingSet = true;
            this.aircraftMapping.setValid();
        } else if (source == this.mealPlanMapping) {
            if (!this.mealPlanSearch.getElement().isItemSelected()) {
                return;
            }
            InnerPopupFactory.showMealPlanMappingPopup(source, this.selectedVariant, (Node<MealPlanLight>)this.selectedVariant.getChildNamed(new DtoField[]{StowingListTemplateVariantLight_.mealplan, MealPlanConfigurationComplete_.mealplan}), this.mealPlanSearch.getElement().getNode(), this.mpLegMapping, this.serviceMapping, Words.LEG_FROM_NEW_MP, Words.IS_REPLACE_BY_NEW_STW, !this.mealPlanMappingSet);
            this.mealPlanMappingSet = true;
            this.mealPlanMapping.setValid();
        } else if (source == this.stowingLegMapping) {
            Node<Map<StowingListTemplateLegComplete, FlightLegComplete>> stwLegMapping2 = this.stwLegMapping;
            InnerPopupFactory.showLegMappingPopup(source, this.getDestinationLegs(), this.getSourceLegs(), stwLegMapping2, !this.flightLegMappingSet);
            this.flightLegMappingSet = true;
            this.stowingLegMapping.setValid();
        } else if (source == this.switchButton) {
            boolean valid;
            boolean bl = valid = this.flightLegMappingSet && this.aircraftMappingSet;
            if (this.mealPlanSearch.getElement().isItemSelected()) {
                valid &= this.mealPlanMappingSet;
            }
            if (!valid) {
                ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
                if (!this.flightLegMappingSet) {
                    this.stowingLegMapping.setInvalid();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_FLIGHT_LEG_MAPPING));
                } else {
                    this.stowingLegMapping.setValid();
                }
                if (!this.aircraftMappingSet) {
                    this.aircraftMapping.setInvalid();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AIRCRAFT_MAPPING));
                } else {
                    this.aircraftMapping.setValid();
                }
                if (this.mealPlanSearch.getElement().isItemSelected() && !this.mealPlanMappingSet) {
                    this.mealPlanMapping.setInvalid();
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_MEAL_PLAN_MAPPING));
                } else {
                    this.mealPlanMapping.setValid();
                }
                InnerPopupFactory.showErrorDialog(a, Words.REVIEW_STW_SWITCH_PARAMETER, (Component)this);
            } else {
                InnerPopupFactory.showSwitchFlightStowingListPopup(this.switchButton, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        StowingTableFooter.this.updateDeliverySpacesAfterStowingListSwitch();
                        ((SearchTextField2)StowingTableFooter.this.stowingSearch.getElement()).getNode().setValue(null, 0L);
                        ((SearchTextField2)StowingTableFooter.this.aircraftSearch.getElement()).getNode().setValue(null, 0L);
                        ((SearchTextField2)StowingTableFooter.this.mealPlanSearch.getElement()).getNode().setValue(null, 0L);
                        StowingTableFooter.this.setEnabled(true);
                    }
                }, this.dataHandler, this.flightNode, this.selectedVariant, this.aircraftSearch.getElement().getNode(), this.mealPlanSearch.getElement().getNode(), this.stwLegMapping, this.aircraftMappingNode, this.mpLegMapping, this.serviceMapping, this.spmlDetails, this.additionals, this.sealsPanel, this.paxTable, this.editor);
            }
        }
    }

    protected void updateDeliverySpacesAfterStowingListSwitch() {
        Iterator it = this.flightNode.getChildNamed(FlightComplete_.spmlOrders).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node spml = (Node)it.next();
            if (!((SpecialMenuTypeComplete)spml.getChildNamed(SpecialMealOrderComplete_.menuType).getValue()).getAdditional().booleanValue()) continue;
            spml.getChildNamed(SpecialMealOrderComplete_.stowingPosition).setValue(null, 0L);
        }
        it = this.flightNode.getChildNamed(FlightComplete_.additionalOrders).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node additional = (Node)it.next();
            additional.getChildNamed(AdditionalOrderComplete_.stowingPosition).setValue(null, 0L);
        }
    }

    private List<Node<ALegComplete>> getDestinationLegs() {
        ArrayList<Node<ALegComplete>> l = new ArrayList<Node<ALegComplete>>();
        Iterator it = this.stowingSearch.getElement().getNode().getChildNamed(StowingListTemplateVariantLight_.legs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getValue() instanceof FlightLegComplete) {
                if (!Boolean.TRUE.equals(n.getChildNamed(FlightLegComplete_.cateringLeg).getValue())) continue;
                l.add((Node<ALegComplete>)n);
                continue;
            }
            if (n.getValue() instanceof FlightScheduleLegComplete) {
                if (!Boolean.TRUE.equals(n.getChildNamed(FlightScheduleLegComplete_.cateringLeg).getValue())) continue;
                l.add((Node<ALegComplete>)n);
                continue;
            }
            l.add((Node<ALegComplete>)n);
        }
        return l;
    }

    private List<Node<ALegComplete>> getSourceLegs() {
        ArrayList<Node<ALegComplete>> l = new ArrayList<Node<ALegComplete>>();
        Iterator it = this.flightNode.getChildNamed(FlightLight_.legs).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getValue() instanceof FlightLegComplete) {
                if (!Boolean.TRUE.equals(n.getChildNamed(FlightLegComplete_.cateringLeg).getValue())) continue;
                l.add((Node<ALegComplete>)n);
                continue;
            }
            if (n.getValue() instanceof FlightScheduleLegComplete) {
                if (!Boolean.TRUE.equals(n.getChildNamed(FlightScheduleLegComplete_.cateringLeg).getValue())) continue;
                l.add((Node<ALegComplete>)n);
                continue;
            }
            l.add((Node<ALegComplete>)n);
        }
        return l;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (source == this.stowingSearch.getElement()) {
            if (n.getValue() != null) {
                StowingListTemplateComplete stwTemplate = (StowingListTemplateComplete)n.getValue();
                Node flightNode = this.editor.getModel().getNode();
                if (flightNode != null) {
                    Timestamp validityDate = ((FlightLight)flightNode.getValue(FlightLight.class)).getStd();
                    List variants = null;
                    try {
                        variants = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(stwTemplate.getVariants())).getList();
                    }
                    catch (ClientServerCallException e) {
                        log.error("Error while select new value", (Throwable)e);
                    }
                    this.selectedVariant = null;
                    for (StowingListTemplateVariantLight variant : variants) {
                        if (!variant.getValidityPeriod().within(new Date(validityDate.getTime())).booleanValue()) continue;
                        this.selectedVariant = INodeCreator.getDefaultImpl().getNode4DTO((Object)variant, false, true);
                    }
                    if (this.selectedVariant == null) {
                        this.selectedVariant = INodeCreator.getDefaultImpl().getNode4DTO((Object)stwTemplate.getCurrentVariant(), false, true);
                    }
                    this.aircraftSearch.getElement().getNode().setValue((Object)((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getAircraft(), 0L);
                    if (((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan() != null && ((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan().getMealplan() == null && ((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan().getMealPlanId() != null) {
                        try {
                            MealPlanLight mealPlan = (MealPlanLight)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getMealPlanLight(new MealPlanReference(((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan().getMealPlanId())).getValue();
                            ((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan().setMealplan(mealPlan);
                        }
                        catch (ClientServerCallException e) {
                            log.error("Error while select new value", (Throwable)e);
                        }
                    }
                    if (((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan() != null && ((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan().getMealplan() != null) {
                        this.mealPlanSearch.getElement().getNode().setValue((Object)((StowingListTemplateVariantLight)this.selectedVariant.getValue()).getMealplan().getMealplan(), 0L);
                    } else {
                        this.mealPlanSearch.getElement().getNode().setValue(null, 0L);
                    }
                }
            }
            this.flightLegMappingSet = false;
            this.aircraftMappingSet = false;
            this.mealPlanMappingSet = false;
        } else if (source == this.aircraftSearch.getElement()) {
            this.aircraftMappingSet = false;
        } else if (source == this.mealPlanSearch.getElement()) {
            this.mealPlanMappingSet = false;
        }
        this.setEnabled(this.isEnabled());
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 10;
            int h = StowingTableFooter.this.skin.getImage(11).getHeight();
            int w = border;
            w += 150;
            w += border / 2;
            w = (int)((double)w + (StowingTableFooter.this.stowingInfo.getPreferredSize().getWidth() + (double)(border / 2)));
            w = (int)((double)w + (StowingTableFooter.this.stowingLegMapping.getPreferredSize().getWidth() + (double)border));
            w += 150;
            w += border / 2;
            w = (int)((double)w + (StowingTableFooter.this.aircraftMapping.getPreferredSize().getWidth() + (double)border));
            w += 150;
            w += border / 2;
            w = (int)((double)w + (StowingTableFooter.this.mealPlanMapping.getPreferredSize().getWidth() + (double)(border * 2)));
            w = (int)((double)w + StowingTableFooter.this.switchButton.getPreferredSize().getWidth());
            return new Dimension(w += border, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            int extendWidth = 0;
            int pw = this.preferredLayoutSize((Container)parent).width;
            int dw = parent.getWidth() - 2 * border - pw;
            extendWidth = dw / 3;
            int maxWidth = 300;
            StowingTableFooter.this.stowingSearch.setLocation(border, (int)(((double)parent.getHeight() - StowingTableFooter.this.stowingSearch.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.stowingSearch.setSize(Math.min(150 + extendWidth, maxWidth), (int)StowingTableFooter.this.stowingSearch.getPreferredSize().getHeight());
            StowingTableFooter.this.stowingInfo.setLocation(StowingTableFooter.this.stowingSearch.getX() + StowingTableFooter.this.stowingSearch.getWidth() + border / 2, (int)(((double)parent.getHeight() - StowingTableFooter.this.stowingInfo.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.stowingInfo.setSize(StowingTableFooter.this.stowingInfo.getPreferredSize());
            StowingTableFooter.this.stowingLegMapping.setLocation(StowingTableFooter.this.stowingInfo.getX() + StowingTableFooter.this.stowingInfo.getWidth() + border / 2, (int)(((double)parent.getHeight() - StowingTableFooter.this.stowingLegMapping.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.stowingLegMapping.setSize(StowingTableFooter.this.stowingLegMapping.getPreferredSize());
            StowingTableFooter.this.aircraftSearch.setLocation(StowingTableFooter.this.stowingLegMapping.getX() + StowingTableFooter.this.stowingLegMapping.getWidth() + border, (int)(((double)parent.getHeight() - StowingTableFooter.this.aircraftSearch.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.aircraftSearch.setSize(Math.min(150 + extendWidth, maxWidth), (int)StowingTableFooter.this.aircraftSearch.getPreferredSize().getHeight());
            StowingTableFooter.this.aircraftMapping.setLocation(StowingTableFooter.this.aircraftSearch.getX() + StowingTableFooter.this.aircraftSearch.getWidth() + border / 2, (int)(((double)parent.getHeight() - StowingTableFooter.this.aircraftMapping.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.aircraftMapping.setSize(StowingTableFooter.this.aircraftMapping.getPreferredSize());
            StowingTableFooter.this.mealPlanSearch.setLocation(StowingTableFooter.this.aircraftMapping.getX() + StowingTableFooter.this.aircraftMapping.getWidth() + border, (int)(((double)parent.getHeight() - StowingTableFooter.this.mealPlanSearch.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.mealPlanSearch.setSize(Math.min(150 + extendWidth, maxWidth), (int)StowingTableFooter.this.mealPlanSearch.getPreferredSize().getHeight());
            StowingTableFooter.this.mealPlanMapping.setLocation(StowingTableFooter.this.mealPlanSearch.getX() + StowingTableFooter.this.mealPlanSearch.getWidth() + border / 2, (int)(((double)parent.getHeight() - StowingTableFooter.this.mealPlanMapping.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.mealPlanMapping.setSize(StowingTableFooter.this.mealPlanMapping.getPreferredSize());
            StowingTableFooter.this.switchButton.setLocation(StowingTableFooter.this.mealPlanMapping.getX() + StowingTableFooter.this.mealPlanMapping.getWidth() + border * 2, (int)(((double)parent.getHeight() - StowingTableFooter.this.switchButton.getPreferredSize().getHeight()) / 2.0));
            StowingTableFooter.this.switchButton.setSize(StowingTableFooter.this.switchButton.getPreferredSize());
        }
    }
}

