/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.handlingcosts.details;

import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete_;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostVariantComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends StateDependantDetailsPanel<HandlingCostComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDSearchTextField2> customer;
    private TitledItem<TextLabel> number;
    private TitledPeriodEditor period;
    private TitledItem<RDMultiLocationComboBox> locations;

    public SpecificationDetailsPanel(RowEditor<HandlingCostComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.customer = new TitledItem<RDSearchTextField2<RDSearchTextField2>>(new RDSearchTextField2(provider, RDSearchTextField2.SearchTypes.CUSTOMER), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.number = new TitledItem<TextLabel>(new TextLabel(), Words.NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.number.getElement().setReadOnlyTextField(true);
        this.period = new TitledPeriodEditor(null, null, true, provider, HandlingCostComplete_.period.getFieldName());
        this.period.enableInfinity(false, true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.customer);
        this.addToView(this.number);
        this.addToView(this.period);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return HandlingCostVariantComplete_.state;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.customer);
        CheckedListAdder.addToList(a, this.period);
        CheckedListAdder.addToList(a, this.locations);
        return a;
    }

    @Override
    public boolean grabsFocus() {
        return true;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.customer.kill();
        this.customer = null;
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.locations = null;
        this.number.kill();
        this.number = null;
        this.period.kill();
        this.period = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isDraft = this.isStateDraft();
        boolean b = isDraft && isEnabled;
        super.setEnabled(isEnabled);
        this.customer.setEnabled(b);
        this.number.setEnabled(b);
        this.period.setEnabled(b);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(b);
        }
    }

    @Override
    public boolean isStateDraft() {
        return this.node != null && this.node.getChildNamed(HandlingCostComplete_.currentVariant) != null && ((HandlingCostVariantComplete)this.node.getChildNamed(HandlingCostComplete_.currentVariant).getValue()).getState() == ModificationStateE.DRAFT;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            HandlingCostComplete dto = (HandlingCostComplete)this.editor.getModel().getNode().getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.node = this.editor.getModel().getNode();
        this.customer.getElement().setNode(this.node.getChildNamed(HandlingCostComplete_.customer));
        this.number.getElement().setNode(this.node.getChildNamed(HandlingCostComplete_.number));
        this.period.setStartDateNode(this.node.getChildNamed(new DtoField[]{HandlingCostComplete_.period, PeriodComplete_.startDate}));
        this.period.setEndDateNode(this.node.getChildNamed(new DtoField[]{HandlingCostComplete_.period, PeriodComplete_.endDate}));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(this.node.getChildNamed(HandlingCostComplete_.eligibleLocations));
        }
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.customer.getElement().isWritable() && this.customer.getElement().getNode().getValue() == null) {
            this.customer.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.NO_CUSTOMER_SELECTED));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        o.addAll(ValidationUtil.validatePeriod((Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.period, PeriodComplete_.startDate}), (Node<Date>)this.editor.getModel().getNode().getChildNamed(new DtoField[]{HandlingCostComplete_.period, PeriodComplete_.endDate}), this.period));
        return o;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.editor.getModel().isAddRow()) {
            this.customer.requestFocusInWindowNow();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - (2 * SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.inner_horizontalBorder);
            SpecificationDetailsPanel.this.customer.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.customer.setSize(w -= SpecificationDetailsPanel.this.horizontalBorder + 75, (int)SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.number.setLocation(SpecificationDetailsPanel.this.customer.getX() + SpecificationDetailsPanel.this.customer.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.customer.getY());
            SpecificationDetailsPanel.this.number.setSize(75, (int)SpecificationDetailsPanel.this.number.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.period.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.customer.getY() + SpecificationDetailsPanel.this.customer.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
            SpecificationDetailsPanel.this.period.setSize((int)SpecificationDetailsPanel.this.period.getPreferredSize().getWidth(), (int)SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.period.getY() + SpecificationDetailsPanel.this.period.getHeight() + SpecificationDetailsPanel.this.inner_verticalBorder);
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.period.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.inner_verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.inner_verticalBorder;
            }
            return new Dimension(200, h += SpecificationDetailsPanel.this.verticalBorder);
        }
    }
}

