/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.incidentlog.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.utils.DepartmentConverter;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentLogLight;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentNotificationComplete_;
import ch.icit.pegasus.server.core.dtos.incidentlog.IncidentStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.IncidentLogAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class NotificationPanel
extends TableDetailsPanel<IncidentLogLight> {
    public NotificationPanel(RowEditor<IncidentLogLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.NOTIFICATIONS);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int dw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL) + this.table.getCellPadding() * 2;
        columns.add(new TableColumnInfo(Words.DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding()));
        columns.add(new TableColumnInfo(Words.DEPARTMENT, null, null, null, "", 200));
        columns.add(new TableColumnInfo(Words.MAIL, null, null, null, "", 300));
        columns.add(new TableColumnInfo("Subject", null, null, null, "", dw, Integer.MAX_VALUE, dw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        return columns;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        boolean isSupervisor = this.provider.isWritable(IncidentLogAccess.INCIDENT_LOG_SUPERVISOR);
        boolean editable = false;
        IncidentStateE currentState = (IncidentStateE)this.getEditor().getModel().getNode().getChildNamed(IncidentLogComplete_.state).getValue();
        if (currentState == IncidentStateE.CLOSED) {
            if (isSupervisor) {
                editable = true;
            }
        } else {
            editable = true;
        }
        boolean e = isEnabled && editable;
        super.setEnabled(e);
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setSortedColumn(2);
        table.setSortDirection(false);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(IncidentLogComplete_.notifications));
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel department;
        private TextLabel mail;
        private TextLabel message;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.date = new TextLabel(m.getNode().getChildNamed(IncidentNotificationComplete_.notificationDate), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.department = new TextLabel(m.getNode().getChildNamed(IncidentNotificationComplete_.department), ConverterRegistry.getConverter(DepartmentConverter.class));
            this.mail = new TextLabel(m.getNode().getChildNamed(IncidentNotificationComplete_.notificationAddress));
            this.message = new TextLabel(this.model.getNode().getChildNamed(IncidentNotificationComplete_.message));
            this.setLayout(new Layout3());
            this.add(this.date);
            this.add(this.department);
            this.add(this.mail);
            this.add(this.message);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.mail.kill();
            this.date.kill();
            this.department.kill();
            this.message.kill();
            this.mail = null;
            this.date = null;
            this.department = null;
            this.message = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout3
        extends DefaultLayout {
            private Layout3() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.date.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.department.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.department.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.department.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.department.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.mail.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.mail.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.mail.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.mail.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.message.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.message.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.message.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.message.getPreferredSize().getHeight());
            }
        }
    }
}

