/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details;

import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchTextField2;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class FlightsDetailsPanel
extends TableDetailsPanel<InventoryLight> {
    private static final long serialVersionUID = 1L;
    private DateChooser flightDate;

    public FlightsDetailsPanel(RowEditor<InventoryLight> editor, RDProvider provider) {
        super(editor, provider, true);
        this.setTitleText(Words.FLIGHTS);
        this.flightDate = new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false));
        this.addToView(this.flightDate);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CODE, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setUseWriteAccessRight(true);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        this.table.setSize(parent.getWidth(), (int)((double)parent.getHeight() - ((double)(2 * this.verticalBorder) + this.flightDate.getPreferredSize().getHeight())));
        this.flightDate.setLocation(this.horizontalBorder, this.table.getY() + this.table.getHeight() + this.verticalBorder);
        this.flightDate.setSize(this.flightDate.getPreferredSize());
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        this.table.getModel().getNode().addChild((Node)new DTOProxyNode(), System.currentTimeMillis());
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl rowPanel = new TableRowImpl(model);
        rowPanel.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return rowPanel;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.table);
        return focusList;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.table.isWritable()) {
            boolean isValid = true;
            ArrayList<FlightLight> s = new ArrayList<FlightLight>();
            for (Table2RowPanel p : this.table.getRows()) {
                TableRowImpl pp = (TableRowImpl)p;
                FlightLight l = pp.getSelectedFlight();
                if (l == null) continue;
                if (!s.contains(l)) {
                    s.add(l);
                    continue;
                }
                isValid = false;
            }
            if (!isValid) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Flight is added only once"));
            }
        }
        return validationObjects;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.enableAddButton(true);
        this.table.getModel().setNode(node.getChildNamed(InventoryComplete_.preparedFlights));
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        return new Dimension(0, 250);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private RDSearchTextField2<FlightLight> flightSearch;
        private Button delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.flightSearch = new RDSearchTextField2(FlightsDetailsPanel.this.provider, RDSearchTextField2.SearchTypes.FLIGHT);
            this.flightSearch.setAdditionalSearchField(new Object[]{FlightsDetailsPanel.this.flightDate.getNode(), true});
            this.flightSearch.setOverrideName(InventoryComplete_.preparedFlights);
            this.flightSearch.setNode(m.getNode());
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> m.getNode().getParent().removeChild(m.getNode(), 0L));
            this.add(this.flightSearch);
            this.add(this.delete);
            this.ensureInventoryState();
        }

        public FlightLight getSelectedFlight() {
            if (this.flightSearch.isItemSelected()) {
                return (FlightLight)this.flightSearch.getNode().getValue();
            }
            return null;
        }

        protected void ensureInventoryState() {
            if (this.delete != null) {
                this.delete.setEnabled(this.isEnabled());
            }
            this.flightSearch.setEnabled(this.isEnabled());
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.flightSearch.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.flightSearch = null;
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.flightSearch);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.flightSearch.requestFocusInWindowNow();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return "";
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.flightSearch.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.flightSearch.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

