/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

public class SpecificationDetailsPanel
extends DefaultDetailsPanel<InventoryLight>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private static boolean isNoPro;
    private TitledItem<RDTextField> name;
    private TitledItem<TextLabel> no;
    private TitledItem<RDDateChooser> inventoryDate;
    private TitledItem<RDTextField> inventoryTime;
    private TitledItem<CheckBox> partly;
    private TitledItem<RDMultiLocationComboBox> locations;

    public SpecificationDetailsPanel(RowEditor<InventoryLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.SPECIFICATION);
        this.name = new TitledItem<RDTextField>(new RDTextField(provider), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
        this.no = new TitledItem<TextLabel>(new TextLabel(), Words.NO_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        this.no.getElement().setReadOnlyTextField(true);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)this.settings);
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        Node n2 = new Node();
        n2.setValue((Object)new Time(System.currentTimeMillis()), 0L);
        this.inventoryDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider, true), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        this.inventoryDate.getElement().setNode(n);
        this.inventoryTime = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.DAYTIME), Words.TIME, TitledItem.TitledItemOrientation.NORTH);
        this.inventoryTime.getElement().setNode(n2);
        if (!isNoPro) {
            this.partly = new TitledItem<CheckBox>(new CheckBox(), Words.PARTLY, TitledItem.TitledItemOrientation.EAST);
        }
        this.name.setProgress(1.0f);
        this.no.setProgress(1.0f);
        this.inventoryDate.setProgress(1.0f);
        this.inventoryTime.setProgress(1.0f);
        if (this.partly != null) {
            this.partly.setProgress(1.0f);
        }
        this.setCustomLayouter(new Layout());
        this.addToView(this.name);
        this.addToView(this.no);
        this.addToView(this.inventoryDate);
        this.addToView(this.inventoryTime);
        if (this.partly != null) {
            this.addToView(this.partly);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.name);
        CheckedListAdder.addToList(focusList, this.inventoryDate);
        CheckedListAdder.addToList(focusList, this.inventoryTime);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.partly);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.name.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        InventoryStateE state = (InventoryStateE)this.editor.getModel().getNode().getChildNamed(new String[]{"state"}).getValue();
        switch (state) {
            case APPROVED: {
                this.name.setEnabled(false);
                this.inventoryDate.setEnabled(false);
                this.inventoryTime.setEnabled(false);
                if (this.partly != null) {
                    this.partly.setEnabled(false);
                }
                if (!Boolean.TRUE.equals(this.viewSettings.getShowLocation())) break;
                this.locations.setEnabled(false);
                break;
            }
            case COUNTED: 
            case STARTED: {
                this.name.setEnabled(isEnabled);
                this.inventoryDate.setEnabled(false);
                this.inventoryTime.setEnabled(false);
                if (this.partly != null) {
                    this.partly.setEnabled(false);
                }
                if (!Boolean.TRUE.equals(this.viewSettings.getShowLocation())) break;
                this.locations.setEnabled(false);
                break;
            }
            case PLANNED: {
                this.name.setEnabled(isEnabled);
                this.inventoryDate.setEnabled(isEnabled);
                this.inventoryTime.setEnabled(isEnabled);
                if (this.partly != null) {
                    this.partly.setEnabled(this.provider.isWritable(InventoryAccess.OVERRIDE_PARTLY));
                }
                if (!Boolean.TRUE.equals(this.viewSettings.getShowLocation())) break;
                this.locations.setEnabled(isEnabled);
            }
        }
        this.no.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.name.kill();
        this.no.kill();
        this.inventoryDate.kill();
        this.inventoryTime.kill();
        if (this.partly != null) {
            this.partly.kill();
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.name = null;
        this.no = null;
        this.inventoryDate = null;
        this.inventoryTime = null;
        this.partly = null;
        this.locations = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (node == null) {
            return;
        }
        if (this.editor.getModel().isAddRow()) {
            InventoryLight dto = (InventoryLight)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.name.getElement().setNode(node.getChildNamed(InventoryLight_.name));
        this.no.getElement().setNode(node.getChildNamed(InventoryLight_.number));
        this.inventoryDate.getElement().setNode(node.getChildNamed(InventoryLight_.inventoryDate));
        this.inventoryTime.getElement().setNode(node.getChildNamed(InventoryLight_.inventoryTime));
        if (this.partly != null) {
            this.partly.getElement().setNode(node.getChildNamed(InventoryLight_.partly));
        } else {
            node.getChildNamed(InventoryLight_.partly).setValue((Object)false, 0L);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(InventoryLight_.eligibleLocations));
        }
        node.getChildNamed(InventoryLight_.state).addNodeListener((NodeListener)this);
        this.setEnabled(this.isEnabled());
    }

    public void valueChanged(Node<?> node) {
        this.setEnabled(this.isEnabled());
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        if (this.name.getElement().isWritable() && this.name.getElement().getNode().getValue() == null) {
            this.name.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ENSURE_NAME_IS_SET));
        }
        if (this.inventoryTime.getElement().isWritable() && this.inventoryTime.getElement().getNode().getValue() == null) {
            this.inventoryTime.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_TIME_IS_SET));
        }
        if (this.inventoryDate.getElement().isWritable() && this.inventoryDate.getElement().getNode().getValue() == null) {
            this.inventoryDate.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_DATE_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() != 1) {
            this.locations.getElement().setInvalid();
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
        }
        return o;
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + SpecificationDetailsPanel.this.inventoryDate.getPreferredSize().getHeight());
            h += SpecificationDetailsPanel.this.verticalBorder;
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + SpecificationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            if (SpecificationDetailsPanel.this.partly != null) {
                h = (int)((double)h + SpecificationDetailsPanel.this.partly.getPreferredSize().getHeight());
                h += SpecificationDetailsPanel.this.verticalBorder;
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int w4tl = (w - (2 * SpecificationDetailsPanel.this.horizontalBorder + 3 * (SpecificationDetailsPanel.this.horizontalBorder * 2))) / 4;
            SpecificationDetailsPanel.this.name.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.name.setSize(w - (2 * SpecificationDetailsPanel.this.horizontalBorder + SpecificationDetailsPanel.this.inner_horizontalBorder + w4tl), (int)SpecificationDetailsPanel.this.name.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.no.setLocation(SpecificationDetailsPanel.this.name.getX() + SpecificationDetailsPanel.this.name.getWidth() + SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.no.setSize(w4tl, (int)SpecificationDetailsPanel.this.no.getPreferredSize().getHeight());
            SpecificationDetailsPanel.this.inventoryDate.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.name.getY() + SpecificationDetailsPanel.this.name.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
            SpecificationDetailsPanel.this.inventoryDate.setSize(SpecificationDetailsPanel.this.inventoryDate.getPreferredSize());
            SpecificationDetailsPanel.this.inventoryTime.setLocation(SpecificationDetailsPanel.this.inventoryDate.getX() + SpecificationDetailsPanel.this.inventoryDate.getWidth() + SpecificationDetailsPanel.this.inner_horizontalBorder, SpecificationDetailsPanel.this.inventoryDate.getY());
            SpecificationDetailsPanel.this.inventoryTime.setSize(SpecificationDetailsPanel.this.inventoryTime.getPreferredSize());
            int cy = SpecificationDetailsPanel.this.inventoryDate.getY() + SpecificationDetailsPanel.this.inventoryDate.getHeight();
            if (Boolean.TRUE.equals(SpecificationDetailsPanel.this.viewSettings.getShowLocation())) {
                SpecificationDetailsPanel.this.locations.setLocation(SpecificationDetailsPanel.this.horizontalBorder, SpecificationDetailsPanel.this.inventoryTime.getY() + SpecificationDetailsPanel.this.inventoryTime.getHeight() + SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.locations.setSize(SpecificationDetailsPanel.this.locations.getPreferredSize());
                cy = SpecificationDetailsPanel.this.locations.getY() + SpecificationDetailsPanel.this.locations.getHeight();
            }
            if (SpecificationDetailsPanel.this.partly != null) {
                SpecificationDetailsPanel.this.partly.setLocation(SpecificationDetailsPanel.this.horizontalBorder, cy + SpecificationDetailsPanel.this.verticalBorder);
                SpecificationDetailsPanel.this.partly.setSize(SpecificationDetailsPanel.this.partly.getPreferredSize());
            }
        }
    }
}

