/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.BankConnectionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.BankConnectionComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class BankConnectionPanel
extends MasterDataInsert<BankConnectionComplete> {
    private static final long serialVersionUID = 1L;

    public BankConnectionPanel(MasterDataModule p) {
        super(p);
    }

    @Override
    public final void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                return ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllUnCached(BankConnectionPanel.this.getMasterDataClass(), true);
            }

            @Override
            public RemoteLoader getInvoker() {
                return BankConnectionPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public DetailsPanel getDetails() {
        return new BankConnectionConfigPanel();
    }

    @Override
    public String getInsertName() {
        return Words.BANK_CONNECTIONS;
    }

    @Override
    public BankConnectionComplete getNewObject() {
        BankConnectionComplete a = new BankConnectionComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends BankConnectionComplete> getMasterDataClass() {
        return BankConnectionComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean bankNameSet = true;
        boolean bcSet = true;
        boolean ibanSet = true;
        boolean currencySet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(BankConnectionComplete_.bankName).getValue() == null) {
                bankNameSet = false;
            }
            if (n.getChildNamed(BankConnectionComplete_.bc).getValue() == null) {
                bcSet = false;
            }
            if (n.getChildNamed(BankConnectionComplete_.iban).getValue() == null) {
                ibanSet = false;
            }
            if (n.getChildNamed(BankConnectionComplete_.usedCurrency).getValue() == null) {
                currencySet = false;
            }
            if (codes.contains(n.getChildNamed(BankConnectionComplete_.bankName).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.ENSURE_NAME_IS_UNIQUE, (Object[])new Object[]{n.getChildNamed(BankConnectionComplete_.bankName).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(BankConnectionComplete_.bankName).getValue());
        }
        if (!bankNameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_NAMES_ARE_SET));
        }
        if (!bcSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_BC_ARE_SET));
        }
        if (!ibanSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_IBAN_ARE_SET));
        }
        if (!currencySet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_ALL_CURRENCIES_ARE_SET));
        }
        return a;
    }

    private class BankConnectionConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<ComboBox> usedCurrency;
        private TitledItem<TextField> bc;
        private TitledItem<TextField> iban;
        private TitledItem<TextField> swift;

        public BankConnectionConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.bc = new TitledItem<TextField>(new TextField(null), Words.BC, TitledItem.TitledItemOrientation.NORTH);
            this.iban = new TitledItem<TextField>(new TextField(null), Words.IBAN, TitledItem.TitledItemOrientation.NORTH);
            this.usedCurrency = new TitledItem<ComboBox>(new ComboBox(null, null, ConverterRegistry.getConverter(CurrencyConverter.class)), Words.CURRENCY, TitledItem.TitledItemOrientation.NORTH);
            this.swift = new TitledItem<TextField>(new TextField(null), Words.SWIFT, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.bc);
            this.add(this.swift);
            this.add(this.iban);
            this.add(this.usedCurrency);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> focusList = this.name.getFocusComponents();
            focusList.addAll(this.usedCurrency.getFocusComponents());
            focusList.addAll(this.bc.getFocusComponents());
            focusList.addAll(this.iban.getFocusComponents());
            focusList.addAll(this.swift.getFocusComponents());
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.usedCurrency.setVisibleContainer(pane);
            this.bc.setVisibleContainer(pane);
            this.iban.setVisibleContainer(pane);
            this.swift.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.usedCurrency.kill();
            this.bc.kill();
            this.iban.kill();
            this.swift.kill();
            this.name = null;
            this.usedCurrency = null;
            this.bc = null;
            this.iban = null;
            this.swift = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.usedCurrency.setEnabled(b);
            this.bc.setEnabled(b);
            this.swift.setEnabled(b);
            this.iban.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(BankConnectionComplete_.bankName));
            this.usedCurrency.getElement().setNode(node.getChildNamed(BankConnectionComplete_.usedCurrency));
            this.usedCurrency.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CurrencyComplete.class));
            this.bc.getElement().setNode(node.getChildNamed(BankConnectionComplete_.bc));
            this.swift.getElement().setNode(node.getChildNamed(BankConnectionComplete_.swift));
            this.iban.getElement().setNode(node.getChildNamed(BankConnectionComplete_.iban));
            this.setEnabled(true);
            BankConnectionPanel.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return BankConnectionComplete_.bankName;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                BankConnectionConfigPanel.this.name.setLocation(BankConnectionPanel.this.masterDataTable.getCellPadding(), BankConnectionPanel.this.masterDataTable.getCellPadding());
                BankConnectionConfigPanel.this.name.setSize(200, (int)BankConnectionConfigPanel.this.name.getPreferredSize().getHeight());
                BankConnectionConfigPanel.this.usedCurrency.setLocation(BankConnectionConfigPanel.this.name.getX() + BankConnectionConfigPanel.this.name.getWidth() + 20, BankConnectionConfigPanel.this.name.getY());
                BankConnectionConfigPanel.this.usedCurrency.setSize(150, (int)BankConnectionConfigPanel.this.usedCurrency.getPreferredSize().getHeight());
                BankConnectionConfigPanel.this.bc.setLocation(BankConnectionPanel.this.masterDataTable.getCellPadding(), BankConnectionConfigPanel.this.name.getY() + BankConnectionConfigPanel.this.name.getHeight() + 10);
                BankConnectionConfigPanel.this.bc.setSize(100, (int)BankConnectionConfigPanel.this.bc.getPreferredSize().getHeight());
                BankConnectionConfigPanel.this.swift.setLocation(BankConnectionPanel.this.masterDataTable.getCellPadding() * 2 + BankConnectionConfigPanel.this.bc.getWidth(), BankConnectionConfigPanel.this.bc.getY());
                BankConnectionConfigPanel.this.swift.setSize(100, (int)BankConnectionConfigPanel.this.swift.getPreferredSize().getHeight());
                BankConnectionConfigPanel.this.iban.setLocation(BankConnectionPanel.this.masterDataTable.getCellPadding(), BankConnectionConfigPanel.this.bc.getY() + BankConnectionConfigPanel.this.bc.getHeight() + 10);
                BankConnectionConfigPanel.this.iban.setSize(250, (int)BankConnectionConfigPanel.this.iban.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

