/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CreditCardTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class CreditCardTypeConfig
extends MasterDataInsert<CreditCardTypeComplete> {
    private static final long serialVersionUID = 1L;

    public CreditCardTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new CreditCardConfigPanel();
    }

    @Override
    public CreditCardTypeComplete getNewObject() {
        CreditCardTypeComplete a = new CreditCardTypeComplete();
        a.setAnsiDataLength(Integer.valueOf(0));
        a.setCardId("");
        a.setCardTypeName("");
        a.setCreditCardAuthorisationLimit(Double.valueOf(0.0));
        a.setCreditCardIdLimit(Double.valueOf(0.0));
        a.setCreditCardMaximumFloorLimit(Double.valueOf(0.0));
        a.setCreditCardMinimumFloorLimit(Double.valueOf(0.0));
        a.setDebitCardAuthorisationLimit(Double.valueOf(0.0));
        a.setDebitCardIdLimit(Double.valueOf(0.0));
        a.setDebitCardMaximumFloorLimit(Double.valueOf(0.0));
        a.setDebitCardMinimumFloorLimit(Double.valueOf(0.0));
        a.setExcludedServiceCodes("");
        a.setIsCreditCardFlag(Boolean.valueOf(false));
        a.setIsDebitCardFlag(Boolean.valueOf(false));
        a.setMerchantNumber("");
        a.setPanLength("");
        a.setServiceCodes("");
        a.setStartDateFlag(Integer.valueOf(0));
        a.setStartDatePositions("");
        a.setSwipedPanLength("");
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<CreditCardTypeComplete> getMasterDataClass() {
        return CreditCardTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Credit Card Types";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(CreditCardTypeComplete_.cardTypeName).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(CreditCardTypeComplete_.cardTypeName).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Card Type " + n.getChildNamed(CreditCardTypeComplete_.cardTypeName).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(CreditCardTypeComplete_.cardTypeName).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Card Types are set"));
        }
        return a;
    }

    private class CreditCardConfigPanel
    extends DetailsPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> cardTypeName;
        private TitledItem<TextField> cardID;
        private TitledItem<CheckBox> isCreditCard;
        private TitledItem<CheckBox> isDebitCard;
        private TitledItem<NumberTextField> creditCardMaxFloorLimit;
        private TitledItem<NumberTextField> creditCardMinFloorLimit;
        private TitledItem<NumberTextField> creditCardIdLimit;
        private TitledItem<NumberTextField> debitCardMaxFloorLimit;
        private TitledItem<NumberTextField> debitCardMinFloorLimit;
        private TitledItem<NumberTextField> debitCardIdLimit;
        private TitledItem<TextField> merchantNumber;
        private TitledItem<TextField> panLenght;
        private TitledItem<TextField> swipedPanLength;
        private TitledItem<TextField> serviceCodes;
        private TitledItem<TextField> excludedServiceCodes;
        private TitledItem<NumberTextField> startDateFlag;
        private TitledItem<TextField> startDatePositions;
        private TitledItem<NumberTextField> creditCardAuthorisationLimit;
        private TitledItem<NumberTextField> debitCardAuthorisationLimit;
        private TitledItem<NumberTextField> ansiDataLength;

        public CreditCardConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.cardTypeName = new TitledItem<TextField>(new TextField(null), Words.CARD_TYPE_NAME, TitledItem.TitledItemOrientation.NORTH);
            this.cardID = new TitledItem<TextField>(new TextField(), Words.CARD_ID, TitledItem.TitledItemOrientation.NORTH);
            this.isCreditCard = new TitledItem<CheckBox>(new CheckBox(), Words.IS_CREDIT_CARD, TitledItem.TitledItemOrientation.EAST);
            this.isDebitCard = new TitledItem<CheckBox>(new CheckBox(), Words.IS_DEBIT_CARD, TitledItem.TitledItemOrientation.EAST);
            this.creditCardMaxFloorLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.CREDIT_CARD_MAX_FLOOR_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.creditCardMinFloorLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.CREDIT_CARD_MIN_FLOOR_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.creditCardIdLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.CREDIT_CARD_ID_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.debitCardMaxFloorLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.DEBIT_CARD_MAX_FLOOR_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.debitCardMinFloorLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.DEBIT_CARD_MIN_FLOOR_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.debitCardIdLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.DEBIT_CARD_ID_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.merchantNumber = new TitledItem<TextField>(new TextField(), Words.MERCHANT_NUMBER, TitledItem.TitledItemOrientation.NORTH);
            this.panLenght = new TitledItem<TextField>(new TextField(), Words.PAN_LENGTH, TitledItem.TitledItemOrientation.NORTH);
            this.swipedPanLength = new TitledItem<TextField>(new TextField(), Words.SWIPED_PAN_LENGTH, TitledItem.TitledItemOrientation.NORTH);
            this.serviceCodes = new TitledItem<TextField>(new TextField(), Words.SERVICE_CODES, TitledItem.TitledItemOrientation.NORTH);
            this.excludedServiceCodes = new TitledItem<TextField>(new TextField(), Words.EXCLUDED_SERVICE_CODES, TitledItem.TitledItemOrientation.NORTH);
            this.startDateFlag = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.START_DATE_FLAG, TitledItem.TitledItemOrientation.NORTH);
            this.startDatePositions = new TitledItem<TextField>(new TextField(), Words.START_DATE_POSITIONS, TitledItem.TitledItemOrientation.NORTH);
            this.creditCardAuthorisationLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.CREDIT_CARD_AUTHORISATION_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.debitCardAuthorisationLimit = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.DOUBLE), Words.DEBIT_CARD_AUTHORISATION_LIMIT, TitledItem.TitledItemOrientation.NORTH);
            this.ansiDataLength = new TitledItem<NumberTextField>(new NumberTextField(TextFieldType.INT), Words.ANSI_DATA_LENGTH, TitledItem.TitledItemOrientation.NORTH);
            this.isCreditCard.getElement().addButtonListener(this);
            this.isDebitCard.getElement().addButtonListener(this);
            this.setLayout(new AALayout());
            this.add(this.cardTypeName);
            this.add(this.cardID);
            this.add(this.isCreditCard);
            this.add(this.isDebitCard);
            this.add(this.creditCardMaxFloorLimit);
            this.add(this.creditCardMinFloorLimit);
            this.add(this.creditCardIdLimit);
            this.add(this.debitCardMaxFloorLimit);
            this.add(this.debitCardMinFloorLimit);
            this.add(this.debitCardIdLimit);
            this.add(this.merchantNumber);
            this.add(this.panLenght);
            this.add(this.swipedPanLength);
            this.add(this.serviceCodes);
            this.add(this.excludedServiceCodes);
            this.add(this.startDateFlag);
            this.add(this.startDatePositions);
            this.add(this.creditCardAuthorisationLimit);
            this.add(this.debitCardAuthorisationLimit);
            this.add(this.ansiDataLength);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.cardTypeName.getFocusComponents();
            CheckedListAdder.addToList(a, this.cardID);
            CheckedListAdder.addToList(a, this.isCreditCard);
            if (this.isCreditCard.getElement().isChecked()) {
                CheckedListAdder.addToList(a, this.creditCardMaxFloorLimit);
                CheckedListAdder.addToList(a, this.creditCardMinFloorLimit);
                CheckedListAdder.addToList(a, this.creditCardIdLimit);
                CheckedListAdder.addToList(a, this.creditCardAuthorisationLimit);
            }
            CheckedListAdder.addToList(a, this.isDebitCard);
            if (this.isDebitCard.getElement().isChecked()) {
                CheckedListAdder.addToList(a, this.debitCardMaxFloorLimit);
                CheckedListAdder.addToList(a, this.debitCardMinFloorLimit);
                CheckedListAdder.addToList(a, this.debitCardIdLimit);
                CheckedListAdder.addToList(a, this.debitCardAuthorisationLimit);
            }
            CheckedListAdder.addToList(a, this.merchantNumber);
            CheckedListAdder.addToList(a, this.panLenght);
            CheckedListAdder.addToList(a, this.swipedPanLength);
            CheckedListAdder.addToList(a, this.serviceCodes);
            CheckedListAdder.addToList(a, this.excludedServiceCodes);
            CheckedListAdder.addToList(a, this.startDateFlag);
            CheckedListAdder.addToList(a, this.startDatePositions);
            CheckedListAdder.addToList(a, this.ansiDataLength);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.cardTypeName.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.cardTypeName.setVisibleContainer(pane);
            this.cardID.setVisibleContainer(pane);
            this.isCreditCard.setVisibleContainer(pane);
            this.isDebitCard.setVisibleContainer(pane);
            this.creditCardAuthorisationLimit.setVisibleContainer(pane);
            this.creditCardIdLimit.setVisibleContainer(pane);
            this.creditCardMaxFloorLimit.setVisibleContainer(pane);
            this.creditCardMinFloorLimit.setVisibleContainer(pane);
            this.debitCardAuthorisationLimit.setVisibleContainer(pane);
            this.debitCardIdLimit.setVisibleContainer(pane);
            this.debitCardMaxFloorLimit.setVisibleContainer(pane);
            this.debitCardMinFloorLimit.setVisibleContainer(pane);
            this.merchantNumber.setVisibleContainer(pane);
            this.panLenght.setVisibleContainer(pane);
            this.swipedPanLength.setVisibleContainer(pane);
            this.serviceCodes.setVisibleContainer(pane);
            this.excludedServiceCodes.setVisibleContainer(pane);
            this.startDateFlag.setVisibleContainer(pane);
            this.startDatePositions.setVisibleContainer(pane);
            this.ansiDataLength.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.cardTypeName.kill();
            this.cardTypeName = null;
            this.cardID.kill();
            this.cardID = null;
            this.isDebitCard.kill();
            this.isDebitCard = null;
            this.isCreditCard.kill();
            this.isCreditCard = null;
            this.creditCardAuthorisationLimit.kill();
            this.creditCardAuthorisationLimit = null;
            this.creditCardMaxFloorLimit.kill();
            this.creditCardMaxFloorLimit = null;
            this.creditCardMinFloorLimit.kill();
            this.creditCardMinFloorLimit = null;
            this.creditCardIdLimit.kill();
            this.creditCardIdLimit = null;
            this.debitCardAuthorisationLimit.kill();
            this.debitCardAuthorisationLimit = null;
            this.debitCardMaxFloorLimit.kill();
            this.debitCardMaxFloorLimit = null;
            this.debitCardMinFloorLimit.kill();
            this.debitCardMinFloorLimit = null;
            this.debitCardIdLimit.kill();
            this.debitCardIdLimit = null;
            this.merchantNumber.kill();
            this.merchantNumber = null;
            this.panLenght.kill();
            this.panLenght = null;
            this.swipedPanLength.kill();
            this.swipedPanLength = null;
            this.serviceCodes.kill();
            this.serviceCodes = null;
            this.excludedServiceCodes.kill();
            this.excludedServiceCodes = null;
            this.startDateFlag.kill();
            this.startDateFlag = null;
            this.startDatePositions.kill();
            this.startDatePositions = null;
            this.ansiDataLength.kill();
            this.ansiDataLength = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.cardTypeName.setEnabled(b);
            this.cardID.setEnabled(b);
            this.isCreditCard.setEnabled(b);
            this.isDebitCard.setEnabled(b);
            boolean c = b && this.isCreditCard.getElement().isChecked();
            this.creditCardAuthorisationLimit.setEnabled(c);
            this.creditCardIdLimit.setEnabled(c);
            this.creditCardMaxFloorLimit.setEnabled(c);
            this.creditCardMinFloorLimit.setEnabled(c);
            c = b && this.isDebitCard.getElement().isChecked();
            this.debitCardAuthorisationLimit.setEnabled(c);
            this.debitCardIdLimit.setEnabled(c);
            this.debitCardMaxFloorLimit.setEnabled(c);
            this.debitCardMinFloorLimit.setEnabled(c);
            this.merchantNumber.setEnabled(b);
            this.panLenght.setEnabled(b);
            this.swipedPanLength.setEnabled(b);
            this.serviceCodes.setEnabled(b);
            this.excludedServiceCodes.setEnabled(b);
            this.startDateFlag.setEnabled(b);
            this.startDatePositions.setEnabled(b);
            this.ansiDataLength.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.cardTypeName.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.cardTypeName));
            this.cardID.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.cardId));
            this.isCreditCard.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.isCreditCardFlag));
            this.isDebitCard.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.isDebitCardFlag));
            this.creditCardAuthorisationLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.creditCardAuthorisationLimit));
            this.creditCardIdLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.creditCardIdLimit));
            this.creditCardMaxFloorLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.creditCardMaximumFloorLimit));
            this.creditCardMinFloorLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.creditCardMinimumFloorLimit));
            this.debitCardAuthorisationLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.debitCardAuthorisationLimit));
            this.debitCardIdLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.debitCardIdLimit));
            this.debitCardMaxFloorLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.debitCardMaximumFloorLimit));
            this.debitCardMinFloorLimit.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.debitCardMinimumFloorLimit));
            this.merchantNumber.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.merchantNumber));
            this.panLenght.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.panLength));
            this.swipedPanLength.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.swipedPanLength));
            this.serviceCodes.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.serviceCodes));
            this.excludedServiceCodes.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.excludedServiceCodes));
            this.startDateFlag.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.startDateFlag));
            this.startDatePositions.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.startDatePositions));
            this.ansiDataLength.getElement().setNode(node.getChildNamed(CreditCardTypeComplete_.ansiDataLength));
            this.setEnabled(true);
            CreditCardTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return CreditCardTypeComplete_.cardTypeName;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            this.setEnabled(this.isEnabled());
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CreditCardConfigPanel.this.cardTypeName.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.cardTypeName.setSize(200, (int)CreditCardConfigPanel.this.cardTypeName.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.cardID.setLocation(CreditCardConfigPanel.this.cardTypeName.getX() + CreditCardConfigPanel.this.cardTypeName.getWidth() + CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.cardID.setSize(200, (int)CreditCardConfigPanel.this.cardID.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.isCreditCard.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.cardTypeName.getY() + CreditCardConfigPanel.this.cardTypeName.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding() * 2);
                CreditCardConfigPanel.this.isCreditCard.setSize(CreditCardConfigPanel.this.isCreditCard.getPreferredSize());
                CreditCardConfigPanel.this.creditCardMaxFloorLimit.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.isCreditCard.getY() + CreditCardConfigPanel.this.isCreditCard.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.creditCardMaxFloorLimit.setSize(200, (int)CreditCardConfigPanel.this.creditCardMaxFloorLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.creditCardMinFloorLimit.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.creditCardMaxFloorLimit.getY() + CreditCardConfigPanel.this.creditCardMaxFloorLimit.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.creditCardMinFloorLimit.setSize(200, (int)CreditCardConfigPanel.this.creditCardMinFloorLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.creditCardIdLimit.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.creditCardMinFloorLimit.getY() + CreditCardConfigPanel.this.creditCardMinFloorLimit.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.creditCardIdLimit.setSize(200, (int)CreditCardConfigPanel.this.creditCardIdLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.creditCardAuthorisationLimit.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.creditCardIdLimit.getY() + CreditCardConfigPanel.this.creditCardIdLimit.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.creditCardAuthorisationLimit.setSize(200, (int)CreditCardConfigPanel.this.creditCardAuthorisationLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.isDebitCard.setLocation(CreditCardConfigPanel.this.cardID.getX(), CreditCardConfigPanel.this.isCreditCard.getY());
                CreditCardConfigPanel.this.isDebitCard.setSize(CreditCardConfigPanel.this.isDebitCard.getPreferredSize());
                CreditCardConfigPanel.this.debitCardMaxFloorLimit.setLocation(CreditCardConfigPanel.this.cardID.getX(), CreditCardConfigPanel.this.creditCardMaxFloorLimit.getY());
                CreditCardConfigPanel.this.debitCardMaxFloorLimit.setSize(200, (int)CreditCardConfigPanel.this.debitCardMaxFloorLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.debitCardMinFloorLimit.setLocation(CreditCardConfigPanel.this.cardID.getX(), CreditCardConfigPanel.this.creditCardMinFloorLimit.getY());
                CreditCardConfigPanel.this.debitCardMinFloorLimit.setSize(200, (int)CreditCardConfigPanel.this.debitCardMinFloorLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.debitCardIdLimit.setLocation(CreditCardConfigPanel.this.cardID.getX(), CreditCardConfigPanel.this.creditCardIdLimit.getY());
                CreditCardConfigPanel.this.debitCardIdLimit.setSize(200, (int)CreditCardConfigPanel.this.debitCardIdLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.debitCardAuthorisationLimit.setLocation(CreditCardConfigPanel.this.cardID.getX(), CreditCardConfigPanel.this.creditCardAuthorisationLimit.getY());
                CreditCardConfigPanel.this.debitCardAuthorisationLimit.setSize(200, (int)CreditCardConfigPanel.this.debitCardAuthorisationLimit.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.merchantNumber.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.creditCardAuthorisationLimit.getY() + CreditCardConfigPanel.this.creditCardAuthorisationLimit.getHeight() + 2 * CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.merchantNumber.setSize(200, (int)CreditCardConfigPanel.this.merchantNumber.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.ansiDataLength.setLocation(CreditCardConfigPanel.this.debitCardMinFloorLimit.getX(), CreditCardConfigPanel.this.merchantNumber.getY());
                CreditCardConfigPanel.this.ansiDataLength.setSize(200, (int)CreditCardConfigPanel.this.ansiDataLength.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.panLenght.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.merchantNumber.getY() + CreditCardConfigPanel.this.merchantNumber.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.panLenght.setSize(200, (int)CreditCardConfigPanel.this.panLenght.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.swipedPanLength.setLocation(CreditCardConfigPanel.this.debitCardMaxFloorLimit.getX(), CreditCardConfigPanel.this.panLenght.getY());
                CreditCardConfigPanel.this.swipedPanLength.setSize(200, (int)CreditCardConfigPanel.this.swipedPanLength.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.serviceCodes.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.panLenght.getY() + CreditCardConfigPanel.this.panLenght.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.serviceCodes.setSize(200, (int)CreditCardConfigPanel.this.serviceCodes.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.excludedServiceCodes.setLocation(CreditCardConfigPanel.this.swipedPanLength.getX(), CreditCardConfigPanel.this.serviceCodes.getY());
                CreditCardConfigPanel.this.excludedServiceCodes.setSize(200, (int)CreditCardConfigPanel.this.excludedServiceCodes.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.startDateFlag.setLocation(CreditCardTypeConfig.this.masterDataTable.getCellPadding(), CreditCardConfigPanel.this.serviceCodes.getY() + CreditCardConfigPanel.this.serviceCodes.getHeight() + CreditCardTypeConfig.this.masterDataTable.getCellPadding());
                CreditCardConfigPanel.this.startDateFlag.setSize(200, (int)CreditCardConfigPanel.this.startDateFlag.getPreferredSize().getHeight());
                CreditCardConfigPanel.this.startDatePositions.setLocation(CreditCardConfigPanel.this.excludedServiceCodes.getX(), CreditCardConfigPanel.this.startDateFlag.getY());
                CreditCardConfigPanel.this.startDatePositions.setSize(200, (int)CreditCardConfigPanel.this.startDatePositions.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

