/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.IncidentErrorTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.IncidentErrorTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class IncidentLogErrorTypeConfig
extends MasterDataInsert<IncidentErrorTypeComplete> {
    private static final long serialVersionUID = 1L;

    public IncidentLogErrorTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new PreparationGroupConfigPanel();
    }

    @Override
    public IncidentErrorTypeComplete getNewObject() {
        IncidentErrorTypeComplete a = new IncidentErrorTypeComplete();
        a.setCode("");
        a.setDescription("");
        a.setName("");
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<IncidentErrorTypeComplete> getMasterDataClass() {
        return IncidentErrorTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return Words.INCIDENT_LOG_ERROR_TYPE;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(IncidentErrorTypeComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(IncidentErrorTypeComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.CODE_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(IncidentErrorTypeComplete_.code).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(IncidentErrorTypeComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_CODE_IS_SET));
        }
        return a;
    }

    private class PreparationGroupConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<TextField> description;

        public PreparationGroupConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.name);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.code);
            CheckedListAdder.addToList(a, this.name);
            CheckedListAdder.addToList(a, this.description);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.name.kill();
            this.code = null;
            this.description = null;
            this.name = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.name.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(IncidentErrorTypeComplete_.code));
            this.name.getElement().setNode(node.getChildNamed(IncidentErrorTypeComplete_.name));
            this.description.getElement().setNode(node.getChildNamed(IncidentErrorTypeComplete_.description));
            this.setEnabled(true);
            IncidentLogErrorTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return IncidentErrorTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                PreparationGroupConfigPanel.this.code.setLocation(IncidentLogErrorTypeConfig.this.masterDataTable.getCellPadding(), IncidentLogErrorTypeConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.code.setSize(200, (int)PreparationGroupConfigPanel.this.code.getPreferredSize().getHeight());
                PreparationGroupConfigPanel.this.name.setLocation(IncidentLogErrorTypeConfig.this.masterDataTable.getCellPadding(), PreparationGroupConfigPanel.this.code.getY() + PreparationGroupConfigPanel.this.code.getHeight() + IncidentLogErrorTypeConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.name.setSize(200, (int)PreparationGroupConfigPanel.this.name.getPreferredSize().getHeight());
                PreparationGroupConfigPanel.this.description.setLocation(IncidentLogErrorTypeConfig.this.masterDataTable.getCellPadding(), PreparationGroupConfigPanel.this.name.getY() + PreparationGroupConfigPanel.this.name.getHeight() + IncidentLogErrorTypeConfig.this.masterDataTable.getCellPadding());
                PreparationGroupConfigPanel.this.description.setSize(200, (int)PreparationGroupConfigPanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

