/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PrinterConfigurationConfig
extends MasterDataInsert<PrintConfigurationComplete> {
    private static final long serialVersionUID = 1L;

    public PrinterConfigurationConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new PrinterConfigPanel();
    }

    @Override
    public PrintConfigurationComplete getNewObject() {
        PrintConfigurationComplete a = new PrintConfigurationComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public String getInsertName() {
        return "Printer Configurations";
    }

    @Override
    public Class<? extends PrintConfigurationComplete> getMasterDataClass() {
        return PrintConfigurationComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(PrintConfigurationComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(PrintConfigurationComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(PrintConfigurationComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(PrintConfigurationComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Name are set"));
        }
        return a;
    }

    private class PrinterConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private TitledItem<CheckBox> rotations;
        private TitledItem<Table2> aliases;
        private TitledItem<CheckBox> landscape;
        private TitledItem<CheckBox> mirrorY;

        public PrinterConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.mirrorY = new TitledItem<CheckBox>(new CheckBox(), "Flip Y", TitledItem.TitledItemOrientation.EAST);
            this.rotations = new TitledItem<CheckBox>(new CheckBox(), "Flip X", TitledItem.TitledItemOrientation.EAST);
            Table2 table = new Table2(true, "Add Alias", true, false);
            table.setButtonHandler(new Table2ButtonHandler(){

                @Override
                public void childRemoved() {
                    PrinterConfigPanel.this.revalidate();
                }

                @Override
                public void addButtonPressed(int x, int y, Button source) {
                    Node n = new Node();
                    n.setValue((Object)"", 0L);
                    ((Table2)PrinterConfigPanel.this.aliases.getElement()).getModel().getNode().addChild(n, 0L);
                    PrinterConfigPanel.this.revalidate();
                }
            });
            ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
            columns.add(new TableColumnInfo("NAME", null, null, null, "", 40, 40, 40));
            int tw = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * table.getCellPadding();
            columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
            ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
            ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
            table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
            this.aliases = new TitledItem<Table2>(table, "Aliases", TitledItem.TitledItemOrientation.NORTH);
            this.aliases.setIgnorePrefHeight(true);
            this.landscape = new TitledItem<CheckBox>(new CheckBox(), "Landscape Paper Feeder", TitledItem.TitledItemOrientation.EAST);
            this.setLayout(new AALayout());
            this.add(this.name);
            this.add(this.rotations);
            this.add(this.aliases);
            this.add(this.landscape);
            this.add(this.mirrorY);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.rotations.getFocusComponents());
            a.addAll(this.landscape.getFocusComponents());
            a.addAll(this.mirrorY.getFocusComponents());
            a.addAll(this.aliases.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.rotations.setVisibleContainer(pane);
            this.aliases.setVisibleContainer(pane);
            this.landscape.setVisibleContainer(pane);
            this.mirrorY.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.rotations.kill();
            this.aliases.kill();
            this.landscape.kill();
            this.mirrorY.kill();
            this.name = null;
            this.rotations = null;
            this.aliases = null;
            this.landscape = null;
            this.mirrorY = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.rotations.setEnabled(b);
            this.aliases.setEnabled(b);
            this.mirrorY.setEnabled(b);
            this.landscape.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(PrintConfigurationComplete_.name));
            this.rotations.getElement().setNode(node.getChildNamed(PrintConfigurationComplete_.flipXaxis));
            this.aliases.getElement().getModel().setNode(node.getChildNamed(PrintConfigurationComplete_.printerNames));
            this.landscape.getElement().setNode(node.getChildNamed(PrintConfigurationComplete_.landscape));
            this.mirrorY.getElement().setNode(node.getChildNamed(PrintConfigurationComplete_.flipYaxis));
            this.setEnabled(true);
            PrinterConfigurationConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return PrintConfigurationComplete_.name;
        }

        private class TableRowImpl
        extends Table2RowPanel
        implements ButtonListener {
            private static final long serialVersionUID = 1L;
            private TextField field;
            private DeleteButton delete;

            public TableRowImpl(Table2RowModel m) {
                super(m);
                this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
                this.field = new TextField(m.getNode());
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
                this.setLayout(new Layout());
                this.add(this.field);
                this.add(this.delete);
            }

            @Override
            public List<Component> getFocusComponents() {
                List<Component> a = this.field.getFocusComponents();
                a.addAll(this.delete.getFocusComponents());
                return a;
            }

            @Override
            public Object getObject4Column(int column) {
                return null;
            }

            @Override
            public void setEnabled(boolean isEnabled) {
                super.setEnabled(isEnabled);
                this.field.setEnabled(isEnabled);
                this.delete.setEnabled(isEnabled);
            }

            @Override
            public void kill() {
                if (this.isKilled()) {
                    return;
                }
                super.kill();
                this.field.kill();
                this.delete.kill();
                this.field = null;
                this.delete = null;
            }

            @Override
            public void buttonPressed(Button source, int x, int y) {
                if (source == this.delete) {
                    this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
                }
            }

            private class Layout
            extends DefaultLayout {
                private Layout() {
                }

                @Override
                public Dimension preferredLayoutSize(Container parent) {
                    return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
                }

                @Override
                public void layoutContainer(Container parent) {
                    int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                    int currentX = 0;
                    TableRowImpl.this.field.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.field.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.field.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.field.getPreferredSize().getHeight());
                    currentX += w;
                    w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                    TableRowImpl.this.setControlsX(currentX);
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                PrinterConfigPanel.this.name.setLocation(PrinterConfigurationConfig.this.masterDataTable.getCellPadding(), PrinterConfigurationConfig.this.masterDataTable.getCellPadding());
                PrinterConfigPanel.this.name.setSize(200, (int)PrinterConfigPanel.this.name.getPreferredSize().getHeight());
                PrinterConfigPanel.this.rotations.setLocation(PrinterConfigurationConfig.this.masterDataTable.getCellPadding(), PrinterConfigPanel.this.name.getY() + PrinterConfigPanel.this.name.getHeight() + PrinterConfigurationConfig.this.masterDataTable.getCellPadding());
                PrinterConfigPanel.this.rotations.setSize(PrinterConfigPanel.this.rotations.getPreferredSize());
                PrinterConfigPanel.this.landscape.setLocation(PrinterConfigurationConfig.this.masterDataTable.getCellPadding(), PrinterConfigPanel.this.rotations.getY() + PrinterConfigPanel.this.rotations.getHeight() + PrinterConfigurationConfig.this.masterDataTable.getCellPadding());
                PrinterConfigPanel.this.landscape.setSize(PrinterConfigPanel.this.landscape.getPreferredSize());
                PrinterConfigPanel.this.mirrorY.setLocation(PrinterConfigurationConfig.this.masterDataTable.getCellPadding(), PrinterConfigPanel.this.landscape.getY() + PrinterConfigPanel.this.landscape.getHeight() + PrinterConfigurationConfig.this.masterDataTable.getCellPadding());
                PrinterConfigPanel.this.mirrorY.setSize(PrinterConfigPanel.this.mirrorY.getPreferredSize());
                PrinterConfigPanel.this.aliases.setLocation(PrinterConfigurationConfig.this.masterDataTable.getCellPadding(), PrinterConfigPanel.this.mirrorY.getY() + PrinterConfigPanel.this.mirrorY.getHeight() + PrinterConfigurationConfig.this.masterDataTable.getCellPadding());
                PrinterConfigPanel.this.aliases.setSize(250, 300);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

