/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.RecipeProductGroupComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.RecipeProductGroupComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class RecipeProductGroupConfig
extends MasterDataInsert<RecipeProductGroupComplete> {
    private static final long serialVersionUID = 1L;

    public RecipeProductGroupConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ArticleOriginConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Product Groups";
    }

    @Override
    public RecipeProductGroupComplete getNewObject() {
        RecipeProductGroupComplete a = new RecipeProductGroupComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends RecipeProductGroupComplete> getMasterDataClass() {
        return RecipeProductGroupComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(RecipeProductGroupComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(RecipeProductGroupComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(RecipeProductGroupComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(RecipeProductGroupComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class ArticleOriginConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<TextField> description;
        private TitledItem<NumberTextField> temperature;
        private TitledItem<SearchTextField2<CustomerLight>> customer;
        private TitledItem<TextField> descriptionGerman;
        private TitledItem<TextField> descriptionEnglish;
        private TitledItem<CheckBox> colorChangeRelevant;
        private TitledItem<CheckBox> heating;

        public ArticleOriginConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), Words.DESCRIPTION, TitledItem.TitledItemOrientation.NORTH);
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.colorChangeRelevant = new TitledItem<CheckBox>(new CheckBox(), Words.COLOR_CHANGE_RELEVANT, TitledItem.TitledItemOrientation.EAST);
            this.temperature = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), "CCP Temperature [\u02daC]", TitledItem.TitledItemOrientation.NORTH);
            this.descriptionGerman = new TitledItem<TextField>(new TextField(null), "CCP Description German", TitledItem.TitledItemOrientation.NORTH);
            this.descriptionEnglish = new TitledItem<TextField>(new TextField(null), "CCP Description English", TitledItem.TitledItemOrientation.NORTH);
            this.heating = new TitledItem<CheckBox>(new CheckBox(null), "Heating", TitledItem.TitledItemOrientation.EAST);
            this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, null), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new Layout());
            this.add(this.code);
            this.add(this.name);
            this.add(this.description);
            this.add(this.colorChangeRelevant);
            this.add(this.heating);
            this.add(this.customer);
            this.add(this.temperature);
            this.add(this.descriptionGerman);
            this.add(this.descriptionEnglish);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> focusList = this.code.getFocusComponents();
            CheckedListAdder.addToList(focusList, this.code);
            CheckedListAdder.addToList(focusList, this.name);
            CheckedListAdder.addToList(focusList, this.description);
            CheckedListAdder.addToList(focusList, this.colorChangeRelevant);
            CheckedListAdder.addToList(focusList, this.heating);
            CheckedListAdder.addToList(focusList, this.customer);
            CheckedListAdder.addToList(focusList, this.temperature);
            CheckedListAdder.addToList(focusList, this.descriptionGerman);
            CheckedListAdder.addToList(focusList, this.descriptionEnglish);
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.colorChangeRelevant.setVisibleContainer(pane);
            this.temperature.setVisibleContainer(pane);
            this.customer.setVisibleContainer(pane);
            this.descriptionGerman.setVisibleContainer(pane);
            this.descriptionEnglish.setVisibleContainer(pane);
            this.heating.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.name.kill();
            this.colorChangeRelevant.kill();
            this.temperature.kill();
            this.descriptionGerman.kill();
            this.descriptionEnglish.kill();
            this.heating.kill();
            this.customer.kill();
            this.name = null;
            this.code = null;
            this.description = null;
            this.colorChangeRelevant = null;
            this.customer = null;
            this.temperature = null;
            this.descriptionGerman = null;
            this.descriptionEnglish = null;
            this.heating = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(isEnabled);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.colorChangeRelevant.setEnabled(b);
            this.customer.setEnabled(b);
            this.temperature.setEnabled(b);
            this.descriptionGerman.setEnabled(b);
            this.descriptionEnglish.setEnabled(b);
            this.heating.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.name.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.name));
            this.code.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.description));
            this.colorChangeRelevant.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.colorChangeRelevant));
            this.customer.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.customer));
            this.temperature.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.temperature));
            this.descriptionGerman.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.descriptionGerman));
            this.descriptionEnglish.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.descriptionEnglish));
            this.heating.getElement().setNode(node.getChildNamed(RecipeProductGroupComplete_.heating));
            this.setEnabled(true);
            RecipeProductGroupConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return RecipeProductGroupComplete_.code;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ArticleOriginConfigPanel.this.code.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.code.setSize(200, (int)ArticleOriginConfigPanel.this.code.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.name.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.code.getY() + ArticleOriginConfigPanel.this.code.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.name.setSize(200, (int)ArticleOriginConfigPanel.this.name.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.description.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.name.getY() + ArticleOriginConfigPanel.this.name.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.description.setSize(200, (int)ArticleOriginConfigPanel.this.description.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.colorChangeRelevant.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.description.getY() + ArticleOriginConfigPanel.this.description.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.colorChangeRelevant.setSize(200, (int)ArticleOriginConfigPanel.this.colorChangeRelevant.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.heating.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.colorChangeRelevant.getY() + ArticleOriginConfigPanel.this.colorChangeRelevant.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.heating.setSize(ArticleOriginConfigPanel.this.heating.getPreferredSize());
                ArticleOriginConfigPanel.this.customer.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.heating.getY() + ArticleOriginConfigPanel.this.heating.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.customer.setSize(200, (int)ArticleOriginConfigPanel.this.customer.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.temperature.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.customer.getY() + ArticleOriginConfigPanel.this.customer.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.temperature.setSize(200, (int)ArticleOriginConfigPanel.this.temperature.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.descriptionGerman.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.temperature.getY() + ArticleOriginConfigPanel.this.temperature.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.descriptionGerman.setSize(200, (int)ArticleOriginConfigPanel.this.descriptionGerman.getPreferredSize().getHeight());
                ArticleOriginConfigPanel.this.descriptionEnglish.setLocation(RecipeProductGroupConfig.this.masterDataTable.getCellPadding(), ArticleOriginConfigPanel.this.descriptionGerman.getY() + ArticleOriginConfigPanel.this.descriptionGerman.getHeight() + RecipeProductGroupConfig.this.masterDataTable.getCellPadding());
                ArticleOriginConfigPanel.this.descriptionEnglish.setSize(200, (int)ArticleOriginConfigPanel.this.descriptionEnglish.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

