/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.gui.modules.masterdata.AbstractDataInsertModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.ScrollableBackground;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.tables.RecipeReserveSettingsTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.TimerServiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.TimerServiceSettingsComplete;
import ch.icit.pegasus.server.core.dtos.reserve.RecipeReserveSettingsComplete;
import ch.icit.pegasus.server.core.dtos.reserve.RecipeReserveSettingsComplete_;
import ch.icit.pegasus.server.core.dtos.util.DailyTimeComplete;
import ch.icit.pegasus.server.core.dtos.util.TimerServiceConfigComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class SettingsRecipeReserveConfig
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private ScrollableBackground scrollPane;
    private Node<RecipeReserveSettingsComplete> node;
    private TitledItem<CheckBox> sendReminder;
    private TitledItem<TextField> notificationAddresses;
    private RecipeReserveSettingsTable table;

    public SettingsRecipeReserveConfig(AbstractDataInsertModule parent) {
        super(parent);
        this.setLayout(new Layout2());
    }

    @Override
    public void insertElements() {
        this.scrollPane = new ScrollableBackground(false);
        this.table = new RecipeReserveSettingsTable();
        this.scrollPane.getViewPort().setLayout(new Layout());
        this.sendReminder = new TitledItem<CheckBox>(new CheckBox(), "Send Reminder to add new configs", TitledItem.TitledItemOrientation.EAST);
        this.notificationAddresses = new TitledItem<TextField>(new TextField(), "Notification Addresses", TitledItem.TitledItemOrientation.NORTH);
        this.add(this.scrollPane);
        this.scrollPane.getViewPort().add(this.table);
        this.scrollPane.getViewPort().add(this.sendReminder);
        this.scrollPane.getViewPort().add(this.notificationAddresses);
        this.isInserted = true;
    }

    @Override
    public String getInsertName() {
        return Words.SETTINGS;
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.table.kill();
            this.sendReminder.kill();
            this.notificationAddresses.kill();
        }
        this.table = null;
        this.sendReminder = null;
        this.notificationAddresses = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
            this.sendReminder.setEnabled(isEnabled);
            this.notificationAddresses.setEnabled(isEnabled);
        }
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.isInserted) {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.sendReminder);
            CheckedListAdder.addToList(focusList, this.notificationAddresses);
            CheckedListAdder.addToList(focusList, this.table);
            return focusList;
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.isInserted) {
            this.table.requestFocusInWindowNow();
        }
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsRecipeReserveConfig.this.node.commitThis(RecipeReserveSettingsComplete.class);
                RecipeReserveSettingsComplete s = (RecipeReserveSettingsComplete)SettingsRecipeReserveConfig.this.node.getValue(RecipeReserveSettingsComplete.class);
                if (Boolean.TRUE.equals(s.getSendReminder())) {
                    s.setTimerServiceSettings(SettingsRecipeReserveConfig.this.createDailyTimerService());
                    TimerServiceSettingsComplete ts = (TimerServiceSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).setTimerServiceData(s.getTimerServiceSettings()).getValue();
                    s.setTimerServiceSettings(ts);
                    s = (RecipeReserveSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateRecipeReserveSettings(s).getValue();
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).manageAllTimerServiceWithInterval(ServiceTypesForTimerService.CHECK_RECIPE_RESERVE, s.getSendReminder().booleanValue(), ts, -1L);
                } else {
                    ((TimerServiceServiceManager)ServiceManagerRegistry.getService(TimerServiceServiceManager.class)).stopTimerService(ServiceTypesForTimerService.CHECK_RECIPE_RESERVE);
                    s = (RecipeReserveSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).updateRecipeReserveSettings(s).getValue();
                }
                SettingsRecipeReserveConfig.this.node.removeExistingValues();
                SettingsRecipeReserveConfig.this.node.setValue((Object)s, 0L);
                SettingsRecipeReserveConfig.this.node.updateNode();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsRecipeReserveConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private TimerServiceSettingsComplete createDailyTimerService() {
        TimerServiceSettingsComplete s = new TimerServiceSettingsComplete();
        s.setTimerServiceConfig((TimerServiceConfigComplete)new DailyTimeComplete(Integer.valueOf(0), Integer.valueOf(30)));
        s.getTimerServiceConfig().setClientOId(Long.valueOf(ADTO.getNextId()));
        return s;
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SettingsRecipeReserveConfig.this.changeLoadingState("Load 1/1 Modules");
                RecipeReserveSettingsComplete value = (RecipeReserveSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getRecipeReserveSettings().getValue();
                return INodeCreator.getDefaultImpl().getNode4DTO((Object)value, false, false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return SettingsRecipeReserveConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        if (this.currentState == DefaultDataInsert.LoadingState.LOAD) {
            this.setNode(node);
        }
    }

    private void setNode(Node<RecipeReserveSettingsComplete> node) {
        this.node = node;
        if (!this.isInserted) {
            return;
        }
        this.table.getModel().setNode(node.getChildNamed(RecipeReserveSettingsComplete_.variants));
        this.sendReminder.getElement().setNode(node.getChildNamed(RecipeReserveSettingsComplete_.sendReminder));
        this.notificationAddresses.getElement().setNode(node.getChildNamed(RecipeReserveSettingsComplete_.notificationAddresses));
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    private class Layout2
    extends DefaultLayout {
        private Layout2() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }

        @Override
        public void layoutContainer(Container parent) {
            SettingsRecipeReserveConfig.this.layoutAnimation(parent);
            if (SettingsRecipeReserveConfig.this.isInserted) {
                SettingsRecipeReserveConfig.this.scrollPane.setLocation(1, 1);
                SettingsRecipeReserveConfig.this.scrollPane.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border;
            int h = border = 10;
            if (SettingsRecipeReserveConfig.this.isInserted) {
                h = (int)((double)h + (SettingsRecipeReserveConfig.this.sendReminder.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsRecipeReserveConfig.this.notificationAddresses.getPreferredSize().getHeight() + (double)border));
                h = (int)((double)h + (SettingsRecipeReserveConfig.this.table.getPreferredSize().getHeight() + (double)border));
            }
            return new Dimension(0, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth() - 40;
            int h = parent.getHeight() - 40;
            int border = 10;
            if (SettingsRecipeReserveConfig.this.isInserted) {
                h -= border;
                SettingsRecipeReserveConfig.this.sendReminder.setLocation(border, border);
                SettingsRecipeReserveConfig.this.sendReminder.setSize(SettingsRecipeReserveConfig.this.sendReminder.getPreferredSize());
                SettingsRecipeReserveConfig.this.notificationAddresses.setLocation(border, SettingsRecipeReserveConfig.this.sendReminder.getY() + SettingsRecipeReserveConfig.this.sendReminder.getHeight() + border);
                SettingsRecipeReserveConfig.this.notificationAddresses.setSize(300, (int)SettingsRecipeReserveConfig.this.notificationAddresses.getPreferredSize().getHeight());
                SettingsRecipeReserveConfig.this.table.setLocation(border, SettingsRecipeReserveConfig.this.notificationAddresses.getY() + SettingsRecipeReserveConfig.this.notificationAddresses.getHeight() + border);
                SettingsRecipeReserveConfig.this.table.setSize(parent.getWidth() - 2 * border, h - (SettingsRecipeReserveConfig.this.table.getY() + border));
            }
        }
    }
}

