/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.matdispocalculation.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationComplete_;
import ch.icit.pegasus.server.core.dtos.matdispo.MaterialDispositionCalculationLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ParameterDetailsPanel
extends DefaultDetailsPanel<MaterialDispositionCalculationLight> {
    private TitledItem<RDDateChooser> productDueDate;
    private TitledItem<RDCheckBox> includeActualStock;
    private TitledItem<ComboBox> bondedState;
    private TitledItem<ComboBox> calculationType;

    public ParameterDetailsPanel(RowEditor<MaterialDispositionCalculationLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.PARAMETERS);
        this.productDueDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.PRODUCT_DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.calculationType = new TitledItem<ComboBox>(new ComboBox(), Words.CALCULATION_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.includeActualStock = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.INCLUDE_ACTUAL_STOCK, TitledItem.TitledItemOrientation.EAST);
        this.bondedState = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.productDueDate);
        this.addToView(this.calculationType);
        this.addToView(this.includeActualStock);
        this.addToView(this.bondedState);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.productDueDate.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.productDueDate));
        this.includeActualStock.getElement().setNode(node.getChildNamed(MaterialDispositionCalculationComplete_.includeActualStock));
        this.calculationType.getElement().addItem(Words.ARTICLE_FROM_STOWING_ONLY);
        this.calculationType.getElement().addItem(Words.ARTICLE_FROM_PRODUCTS_ONLY);
        this.calculationType.getElement().addItem(Words.ALL_ARTICLES);
        if (Boolean.TRUE.equals(node.getChildNamed(MaterialDispositionCalculationComplete_.articleFromProductsOnly).getValue())) {
            this.calculationType.getElement().setSelectedItem(Words.ARTICLE_FROM_PRODUCTS_ONLY);
        } else if (Boolean.TRUE.equals(node.getChildNamed(MaterialDispositionCalculationComplete_.articleFromStowingListOnly).getValue())) {
            this.calculationType.getElement().setSelectedItem(Words.ARTICLE_FROM_STOWING_ONLY);
        } else {
            this.calculationType.getElement().setSelectedItem(Words.ALL_ARTICLES);
        }
        this.bondedState.getElement().addItem(Words.ALL);
        this.bondedState.getElement().addItem(Words.BONDED);
        this.bondedState.getElement().addItem(Words.NOT_BONDED);
        Boolean value = (Boolean)node.getChildNamed(MaterialDispositionCalculationComplete_.bondedState).getValue();
        if (Boolean.TRUE.equals(value)) {
            this.bondedState.getElement().setSelectedItem(Words.BONDED);
        } else if (Boolean.FALSE.equals(value)) {
            this.bondedState.getElement().setSelectedItem(Words.NOT_BONDED);
        } else {
            this.bondedState.getElement().setSelectedItem(Words.ALL);
        }
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        if (this.bondedState != null) {
            if (this.bondedState.getElement().getSelectedItem().equals(Words.ALL)) {
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.bondedState).setValue(null, 0L);
            } else if (this.bondedState.getElement().getSelectedItem().equals(Words.BONDED)) {
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.bondedState).setValue((Object)true, 0L);
            } else {
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.bondedState).setValue((Object)false, 0L);
            }
        }
        if (this.calculationType != null) {
            if (this.calculationType.getElement().getSelectedItem().equals(Words.ARTICLE_FROM_STOWING_ONLY)) {
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.articleFromStowingListOnly).setValue((Object)true, 0L);
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.articleFromProductsOnly).setValue((Object)false, 0L);
            } else if (this.calculationType.getElement().getSelectedItem().equals(Words.ARTICLE_FROM_PRODUCTS_ONLY)) {
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.articleFromStowingListOnly).setValue((Object)false, 0L);
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.articleFromProductsOnly).setValue((Object)true, 0L);
            } else if (this.calculationType.getElement().getSelectedItem().equals(Words.ALL_ARTICLES)) {
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.articleFromStowingListOnly).setValue(null, 0L);
                this.editor.getModel().getNode().getChildNamed(MaterialDispositionCalculationComplete_.articleFromProductsOnly).setValue(null, 0L);
            }
        }
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.productDueDate.requestFocusInWindowNow();
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.productDueDate);
        CheckedListAdder.addToList(focusList, this.calculationType);
        CheckedListAdder.addToList(focusList, this.includeActualStock);
        CheckedListAdder.addToList(focusList, this.bondedState);
        return focusList;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.productDueDate.setEnabled(isEnabled);
        this.calculationType.setEnabled(isEnabled);
        this.includeActualStock.setEnabled(isEnabled);
        this.bondedState.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.productDueDate.kill();
        this.calculationType.kill();
        this.includeActualStock.kill();
        this.bondedState.kill();
        this.productDueDate = null;
        this.calculationType = null;
        this.includeActualStock = null;
        this.bondedState = null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ParameterDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ParameterDetailsPanel.this.productDueDate.getPreferredSize().getHeight());
            h += ParameterDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ParameterDetailsPanel.this.calculationType.getPreferredSize().getHeight());
            h += ParameterDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ParameterDetailsPanel.this.includeActualStock.getPreferredSize().getHeight());
            h += ParameterDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ParameterDetailsPanel.this.bondedState.getPreferredSize().getHeight());
            return new Dimension(0, h += ParameterDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            ParameterDetailsPanel.this.productDueDate.setLocation(ParameterDetailsPanel.this.horizontalBorder, ParameterDetailsPanel.this.verticalBorder);
            ParameterDetailsPanel.this.productDueDate.setSize(ParameterDetailsPanel.this.productDueDate.getPreferredSize());
            ParameterDetailsPanel.this.calculationType.setLocation(ParameterDetailsPanel.this.horizontalBorder, ParameterDetailsPanel.this.productDueDate.getY() + ParameterDetailsPanel.this.productDueDate.getHeight() + ParameterDetailsPanel.this.inner_verticalBorder);
            ParameterDetailsPanel.this.calculationType.setSize(parent.getWidth() - 2 * ParameterDetailsPanel.this.horizontalBorder, (int)ParameterDetailsPanel.this.calculationType.getPreferredSize().getHeight());
            ParameterDetailsPanel.this.includeActualStock.setLocation(ParameterDetailsPanel.this.horizontalBorder, ParameterDetailsPanel.this.calculationType.getY() + ParameterDetailsPanel.this.calculationType.getHeight() + ParameterDetailsPanel.this.inner_verticalBorder);
            ParameterDetailsPanel.this.includeActualStock.setSize(ParameterDetailsPanel.this.includeActualStock.getPreferredSize());
            ParameterDetailsPanel.this.bondedState.setLocation(ParameterDetailsPanel.this.horizontalBorder, ParameterDetailsPanel.this.includeActualStock.getY() + ParameterDetailsPanel.this.includeActualStock.getHeight() + ParameterDetailsPanel.this.inner_verticalBorder);
            ParameterDetailsPanel.this.bondedState.setSize(parent.getWidth() - 2 * ParameterDetailsPanel.this.horizontalBorder, (int)ParameterDetailsPanel.this.bondedState.getPreferredSize().getHeight());
        }
    }
}

