/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.mealplan;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DefaultObject2ObjectConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.InverseBooleanConverter;
import ch.icit.pegasus.client.converter.PeriodConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.mealplan.MealPlanModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.mealplan.details.CatalogDetailsPanel;
import ch.icit.pegasus.client.gui.modules.mealplan.details.FixPriceDetailsPanel;
import ch.icit.pegasus.client.gui.modules.mealplan.details.LegsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.mealplan.details.MealPlanConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.mealplan.details.ServiceEditDetailsPanel;
import ch.icit.pegasus.client.gui.modules.mealplan.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.mealplan.details.TemplateDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.MealPlanSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight;
import ch.icit.pegasus.server.core.dtos.mealplan.MealPlanLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.MealPlanAccess;
import ch.icit.pegasus.server.core.dtos.search.MealPlanSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class MealPlanModule
extends ScreenTableView<MealPlanLight, MealPlanSearchConfiguration.MEAL_PLAN_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME = "name_filter";
    private static final String FILTER_CUSTOMER = "customer_filter";
    private static final String FILTER_PERIOD = "period";
    private static final String FILTER_STATE = "state";
    private static final String FILTER_HAS_WARNINGS = "hasWarnings";
    private String searchCriteria1 = null;
    private CustomerLight searchCriteria2 = null;
    private TitledPeriodEditor searchCriteria3 = null;
    private TitledPeriodEditor periodEditor;
    private ModificationStateE searchCriteria4 = null;
    private Boolean hasWarningCriteria = null;

    public MealPlanModule() {
        super(MealPlanLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.searchCriteria3 != null) {
            this.searchCriteria3.kill();
        }
        this.searchCriteria3 = null;
        this.periodEditor.kill();
        this.periodEditor = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return MealPlanAccess.MODULE_MEAL_PLAN;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", MealPlanSearchConfiguration.MEAL_PLAN_COLUMN.NUMBER + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NAME, Words.NUMBER_OR_NAME, "");
        this.filterChain.addCustomerSearchField(FILTER_CUSTOMER);
        this.periodEditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()), "", true);
        this.periodEditor.setCheckBoxEnabled();
        this.filterChain.addModificationStateComboBox(FILTER_STATE);
        ComboBox yesNoBox = ComboBoxFactory.getYesNoComboBox(true);
        this.filterChain.addSelectionComboBox(yesNoBox, FILTER_HAS_WARNINGS, Words.HAS_WARNINGS, Words.ALL);
        this.filterChain.addResetButton();
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<MealPlanLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(MealPlanSearchAlgorithm.class);
    }

    @Override
    public ASearchConfiguration<MealPlanLight, MealPlanSearchConfiguration.MEAL_PLAN_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria1 = null;
            this.searchCriteria2 = null;
            this.searchCriteria3 = null;
            this.searchCriteria4 = null;
            if (this.periodEditor != null) {
                this.periodEditor.setCheckBoxChecked(false);
            }
            this.hasWarningCriteria = null;
        } else if (name == FILTER_NAME) {
            this.searchCriteria1 = (String)value;
        } else if (name == FILTER_CUSTOMER) {
            this.searchCriteria2 = value instanceof CustomerLight ? (CustomerLight)value : null;
        } else if (name == FILTER_PERIOD) {
            this.searchCriteria3 = (TitledPeriodEditor)value;
        } else if (name == FILTER_STATE) {
            this.searchCriteria4 = value instanceof ModificationStateE ? (ModificationStateE)value : null;
        } else if (name == FILTER_HAS_WARNINGS) {
            this.hasWarningCriteria = Words.YES.equals(value) ? Boolean.valueOf(true) : (Words.NO_ANSWER.equals(value) ? Boolean.valueOf(false) : null);
        }
        MealPlanSearchConfiguration c = new MealPlanSearchConfiguration();
        String aName = null;
        Integer aNumber = null;
        aName = this.searchCriteria1;
        if (aName != null && !aName.isEmpty()) {
            try {
                aNumber = Integer.valueOf(aName);
                aName = null;
            }
            catch (NumberFormatException e) {
                aNumber = null;
                aName = this.searchCriteria1;
            }
        }
        c.setNumResults(this.numberOfShownResults);
        c.setName(aName);
        c.setNumber(aNumber);
        c.setCustomer(this.searchCriteria2);
        c.setState(this.searchCriteria4);
        c.setHasWarnings(this.hasWarningCriteria);
        if (this.searchCriteria3 != null) {
            PeriodComplete p = new PeriodComplete(this.searchCriteria3.getStartDate(), this.searchCriteria3.getEndDate());
            c.setPeriod(p);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<MealPlanLight> model) {
        return model != null;
    }

    @Override
    public boolean isDeletable(RowModel<MealPlanLight> model) {
        return super.isDeletable(model) && model.getDTO(MealPlanLight.class).getState() == ModificationStateE.DRAFT;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<MealPlanLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<MealPlanLight> rowEditor = new MessageProvidedRowEditor<MealPlanLight>(model, "Unable to save");
            RDProvider p = this.createProvider(model.isAddRow());
            TemplateDetailsPanel d0 = null;
            if (rowEditor.getModel().isAddRow()) {
                d0 = new TemplateDetailsPanel((RowEditor<MealPlanLight>)rowEditor, p);
            }
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<MealPlanLight>)rowEditor, p);
            ServiceEditDetailsPanel d3 = null;
            CatalogDetailsPanel d31 = null;
            FixPriceDetailsPanel d4 = new FixPriceDetailsPanel((RowEditor<MealPlanLight>)rowEditor, p);
            LegsDetailsPanel d2 = new LegsDetailsPanel(rowEditor, p, d4);
            MealPlanConfigurationDetailsPanel d5 = null;
            if (!model.isAddRow()) {
                d5 = new MealPlanConfigurationDetailsPanel((RowEditor<MealPlanLight>)rowEditor, p);
                d3 = new ServiceEditDetailsPanel((RowEditor<MealPlanLight>)rowEditor, p);
                d31 = new CatalogDetailsPanel((RowEditor<MealPlanLight>)rowEditor, p);
            }
            CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
            c1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.5, 1.0));
            c1.add((Component)d2, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            int i = 0;
            if (d0 != null) {
                rowEditor.add(d0, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
                i = 1;
            }
            rowEditor.add(c1, (Object)new TableLayoutConstraint(0, i, 1.0, 0.0));
            ++i;
            if (d3 != null && d31 != null) {
                CombinedDetailsParagraph c11 = new CombinedDetailsParagraph();
                c11.add((Component)d3, new TableLayoutConstraint(0, 0, 0.5, 0.0));
                c11.add((Component)d31, new TableLayoutConstraint(1, 0, 0.5, 0.0));
                rowEditor.add(c11, (Object)new TableLayoutConstraint(0, i, 1.0, 0.0));
                ++i;
            }
            if (d5 != null) {
                rowEditor.add(d5, (Object)new TableLayoutConstraint(0, i, 1.0, 0.0));
                ++i;
            }
            rowEditor.add(d4, (Object)new TableLayoutConstraint(0, i, 1.0, 0.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d2);
            if (d3 != null) {
                rowEditor.addToFocusQueue(d3);
            }
            if (d31 != null) {
                rowEditor.addToFocusQueue(d31);
            }
            rowEditor.addToFocusQueue(d4);
            if (d5 != null) {
                rowEditor.addToFocusQueue(d5);
            }
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new MealPlanModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)MealPlanSearchConfiguration.MEAL_PLAN_COLUMN.NUMBER, MealPlanLight_.number, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth, TableColumnInfo.numberColumnWithExpandWidth));
        columns.add(new TableColumnInfo(Words.VALIDATION, "", InverseBooleanConverter.class, null, MealPlanLight_.hasWarnings, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        columns.add(new TableColumnInfo("", "", (Class)DefaultObject2ObjectConverter.class, (Enum<?>)MealPlanSearchConfiguration.MEAL_PLAN_COLUMN.STATE, MealPlanLight_.state, TableColumnInfo.state2, TableColumnInfo.state2, TableColumnInfo.state2));
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)MealPlanSearchConfiguration.MEAL_PLAN_COLUMN.NAME, MealPlanLight_.name, 120, Integer.MAX_VALUE, 120));
        columns.add(new TableColumnInfo(Words.PERIOD, "", (Class)PeriodConverter.class, (Enum<?>)MealPlanSearchConfiguration.MEAL_PLAN_COLUMN.PERIOD, MealPlanLight_.period, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth, TableColumnInfo.periodColumnWidth));
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)MealPlanSearchConfiguration.MEAL_PLAN_COLUMN.CUSTOMER, MealPlanLight_.customer, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth, TableColumnInfo.customerCodeWidth));
        return columns;
    }
}

