/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.picknpay;

import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.PickNPayTransferTypeEConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.picknpay.PickNPayModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.picknpay.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.PickNPayTransferSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.dataexchange.PickNPaySettingsComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.picknpay.PickNPayTransferComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.picknpay.PickNPayTransferComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PickNPayAccess;
import ch.icit.pegasus.server.core.dtos.search.ADataImportSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.PickNPayDataTransferSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class PickNPayModule
extends ScreenTableView<PickNPayTransferComplete, ADataImportSearchConfiguration.DATA_IMPORT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_DATE = "date_filter";
    private static final String FILTER_STATE = "state_filter";
    private PeriodComplete searchCriteria2 = null;
    private Boolean searchFilter;

    public PickNPayModule() {
        super(PickNPayTransferComplete.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public boolean isDeletable(RowModel<PickNPayTransferComplete> model) {
        return true;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return PickNPayAccess.MODULE_PICK_N_PAY_DATA_IMPORT;
    }

    public PickNPayModuleDataHandler getDataHandler() {
        return (PickNPayModuleDataHandler)this.getTable().getModel().getDataHandler();
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.DATE + "<>" + true);
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        ComboBox b = ComboBoxFactory.getPickNPayStateComboBox(true);
        this.filterChain.addSelectionComboBox(b, 110, FILTER_STATE, Words.STATE, Words.ALL);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        TitledPeriodEditor periodSelection = this.filterChain.addPeriodSelection(FILTER_DATE, p.getStartDate(), p.getEndDate(), null, true);
        periodSelection.setCheckBoxEnabled();
        periodSelection.setCheckBoxChecked(false);
        periodSelection.setCommitOnFocusLost(true);
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<PickNPayTransferComplete, ADataImportSearchConfiguration.DATA_IMPORT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.searchCriteria2 = FilterChainConfiguration.getDefaultSearchPeriod();
        } else if (name == FILTER_DATE) {
            TitledPeriodEditor ed = (TitledPeriodEditor)value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.searchCriteria2 = per;
        } else if (name == FILTER_STATE) {
            if (Words.ALL.equals(value)) {
                this.searchFilter = null;
            } else if (Words.VALID.equals(value)) {
                this.searchFilter = true;
            } else if (Words.NOT_ALL_MATCHED.equals(value)) {
                this.searchFilter = false;
            }
        }
        PickNPayDataTransferSearchConfiguration c = new PickNPayDataTransferSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setPeriod(this.searchCriteria2);
        c.setImportValidity(this.searchFilter);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<PickNPayTransferComplete> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(PickNPayTransferSearchAlgorithm.class);
    }

    @Override
    public void redo() {
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<PickNPayTransferComplete> model) {
        PickNPayTransferComplete ab = (PickNPayTransferComplete)model.getNode().getValue();
        return model != null;
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete screen) {
        PickNPaySettingsComplete settingsComplete;
        if (screen.getModule().getInvokingName().equals(PickNPayAccess.ANALYSIS_PICK_N_PAY_CHECK_ARTICLE_COST.getIdentifier()) || screen.getModule().getInvokingName().equals(PickNPayAccess.ANALYSIS_PICK_N_PAY_CHECK_ARTICLE_DATA.getIdentifier())) {
            settingsComplete = (PickNPaySettingsComplete)NodeToolkit.getAffixClass(PickNPaySettingsComplete.class).getValue();
            if (!Boolean.TRUE.equals(settingsComplete.getUseArticleImport())) {
                return false;
            }
            if (!Boolean.TRUE.equals(settingsComplete.getUseArticleImport())) {
                return false;
            }
        }
        if (screen.getModule().getInvokingName().equals(PickNPayAccess.ANALYSIS_PICK_N_PAY_CHECK_FOR_UPDATES.getIdentifier()) && !Boolean.TRUE.equals((settingsComplete = (PickNPaySettingsComplete)NodeToolkit.getAffixClass(PickNPaySettingsComplete.class).getValue()).getUseInvoiceExceptionImport()) && !Boolean.TRUE.equals(settingsComplete.getUseOrdersImport())) {
            return false;
        }
        return super.isAnalysisModuleAllowed(screen);
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<PickNPayTransferComplete> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<PickNPayTransferComplete> rowEditor = new MessageProvidedRowEditor<PickNPayTransferComplete>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            SpecificationDetailsPanel sps = new SpecificationDetailsPanel((RowEditor<PickNPayTransferComplete>)rowEditor, p);
            rowEditor.add(sps, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.addToFocusQueue(sps);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new PickNPayModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> info = new ArrayList<TableColumnInfo>();
        info.add(new TableColumnInfo(Words.VALID, "", (Class)BooleanConverter.class, (Enum<?>)ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.IMPORT_VALIDITY, PickNPayTransferComplete_.valid, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth, TableColumnInfo.state2WithExpandWidth));
        info.add(new TableColumnInfo(Words.PROCESSED, "", BooleanConverter.class, null, PickNPayTransferComplete_.processed, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        info.add(new TableColumnInfo(Words.TYPE, "", PickNPayTransferTypeEConverter.class, null, PickNPayTransferComplete_.transferType, 150, 150, 150));
        info.add(new TableColumnInfo(Words.NAME, "", StringConverter.class, null, PickNPayTransferComplete_.name, 100, Integer.MAX_VALUE, 100));
        info.add(new TableColumnInfo(Words.CREATION_DATE, "", (Class)DateTimeConverter.class, (Enum<?>)ADataImportSearchConfiguration.DATA_IMPORT_COLUMN.DATE, PickNPayTransferComplete_.transferDate, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        info.add(new TableColumnInfo(Words.CREATION_USER, "", UserConverter.class, null, PickNPayTransferComplete_.transferUser, 200, 200, 200));
        return info;
    }
}

