/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow;

import ch.icit.pegasus.client.comparators.DefaultIntegerTableRowComparator;
import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.FormattedDoubleConverter3Decimals;
import ch.icit.pegasus.client.converter.IntegerPlusPlusConverter;
import ch.icit.pegasus.client.converter.OrderPriceConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.GroupLoader;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.addrow.utils.TableRowImpl;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.utils.IConfigurationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.StockTransactionRemarkButton;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.CopyTemplateToolkit;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArticleOrderDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight>
implements LafListener {
    private static final long serialVersionUID = 1L;
    private IConfigurationDetailsPanel confPanel;
    private GroupLoader loader;
    private ReloadablePriceView totalView;
    private TextLabel deliveryCosts;
    private TextLabel totalCosts;
    private BackgroundFadeSkin skinBackFade;
    private CurrencyVariantAccessor accessor = new CurrencyVariantAccessorImpl();
    private PriceComplete costsMaterial;
    private PriceComplete costsDelivery;
    private String currentWarnings;
    private boolean onlyAddFromTemplate;

    public ArticleOrderDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider, IConfigurationDetailsPanel p) {
        super(editor, provider, provider.isWritable(PurchaseOrderAccess.CAN_ORDER_WITHOUT_TEMPLATE));
        this.onlyAddFromTemplate = !provider.isWritable(PurchaseOrderAccess.CAN_ORDER_WITHOUT_TEMPLATE);
        this.loader = new GroupLoader(this);
        Object[] o = new Object[]{FormattedDoubleConverter3Decimals.class};
        this.totalView = new ReloadablePriceView((LoadingGroup)this.loader, OrderPriceConverter.class);
        this.totalView.setConverterParametes(o);
        this.totalView.setProgress(1.0f);
        this.deliveryCosts = new TextLabel();
        this.deliveryCosts.setProgress(1.0f);
        this.loader.setTotalView(this.totalView);
        this.totalCosts = new TextLabel();
        this.totalCosts.setProgress(1.0f);
        this.setTitleText(Words.ARTICLES);
        this.confPanel = p;
        editor.setAddButtonText(Words.PLACE_ORDER);
        editor.enableSaveButton(false);
        this.skinBackFade = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.lafAttributeChanged(null);
        this.setTotalCostAlgorithm();
        this.totalView.load(true);
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!isNoPro) {
            this.addToView(this.totalView);
            this.addToView(this.deliveryCosts);
            this.addToView(this.totalCosts);
        }
    }

    private boolean canChangeSupplierCondition() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        int tw = 0;
        columns.add(new TableColumnInfo(0.0, 0.0, Words.NO_NUMBER, "", IntegerPlusPlusConverter.class, null, "", 45, 45, 45));
        columns.add(new TableColumnInfo(1.0, 0.0, Words.ARTICLE, "", StringConverter.class, null, "", 30, Integer.MAX_VALUE, 30));
        if (isNoPro) {
            columns.add(new TableColumnInfo(0.0, 0.0, Words.DEPARMENT, "", StringConverter.class, null, "", 90, 90, 90));
        }
        columns.add(new TableColumnInfo(0.0, 0.0, Words.DELIVERY_TIME, "", StringConverter.class, null, "", 110, 110, 110));
        columns.add(new TableColumnInfo(0.0, 0.0, Words.ORDER_INTERVAL, "", StringConverter.class, null, "", 110, 110, 110));
        tw = InputComboBox.getPreferredWidth(this.table, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) + this.table.getInnerCellPadding() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(0.0, 0.0, Words.AMOUNT, "", StringConverter.class, null, "", tw, tw, tw));
        tw = InputComboBox.getPreferredWidth(this, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) + 2 * this.table.getCellPadding();
        if (!isNoPro) {
            columns.add(new TableColumnInfo(0.0, 0.0, Words.COST, "", StringConverter.class, null, "", tw, tw, tw));
            columns.add(new TableColumnInfo(0.0, 0.0, Words.WARNING, "", StringConverter.class, null, "", 110, 110, 110));
        }
        tw = this.canChangeSupplierCondition() ? 2 * ArrowButton.getPreferredWidth() + 2 * DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + StockTransactionRemarkButton.getPreferredWidth() + 3 * this.table.getInnerCellPadding() + 3 * this.table.getCellPadding() : 2 * ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM) + StockTransactionRemarkButton.getPreferredWidth() + 2 * this.table.getInnerCellPadding() + 3 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(0.0, 0.0, "", "", StringConverter.class, null, "", tw, tw, tw));
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setRequestFocusOnAdd(true);
        table.setComparator(ComparatorRegistry.getComparator(DefaultIntegerTableRowComparator.class));
        table.setUseAddButton(false);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        if (this.confPanel.isSupplierChoosen()) {
            PurchaseOrderPositionComplete pos = new PurchaseOrderPositionComplete();
            pos.setDeliveryDate(new Date(System.currentTimeMillis()));
            pos.setSequenceNumber(Integer.valueOf(this.table.getRowCount()));
            pos.setClientOId(Long.valueOf(ADTO.getNextId()));
            pos.setReviewState(OrderReviewStateE.UNCHECKED);
            pos.setQuantity(new StoreQuantityComplete());
            pos.setArticleLabelCount(Integer.valueOf(0));
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)pos, true, false);
            this.table.getModel().getNode().addChild(n, System.currentTimeMillis());
            this.editor.revalidate();
            this.table.updateOrder();
            this.checkOrderableState();
            this.totalView.load(true);
        } else {
            InnerPopupFactory.showErrorDialog(Words.SELECT_SUPPLIER_FIRST, (Component)source);
        }
    }

    @Override
    public void childRemoved() {
        if (this.checkOrderableState()) {
            this.editor.revalidate();
            this.table.writeNumber(PurchaseOrderPositionComplete_.sequenceNumber, 0);
            this.totalView.load(true);
        }
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl row = new TableRowImpl(model, this.loader, this, (SupplierLight)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierLight.class));
        row.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return row;
    }

    private void updateTotalCosts() throws ClientServerCallException {
        SupplierComplete supplier = (SupplierComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierComplete.class);
        String t = Words.TOTAL_COSTS + ": ";
        double d = 0.0;
        if (this.costsDelivery != null) {
            d += this.costsDelivery.getPrice().doubleValue();
        }
        if (this.costsMaterial != null) {
            d += this.costsMaterial.getPrice().doubleValue();
        }
        if (supplier != null) {
            PriceComplete price = new PriceComplete(supplier.getPaymentCurrency(), Double.valueOf(d));
            t = t + price.getFormattedPrice() + " " + price.getCurrency().getCode();
        }
        this.totalCosts.setText(t);
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.orderPositions));
    }

    private void updateDeliveryCost() throws ClientServerCallException {
        SupplierComplete supplier = (SupplierComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierComplete.class);
        String t = Words.DELIVERY_COSTS + ": ";
        if (supplier == null) {
            SupplierLight sL = (SupplierLight)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierLight.class);
            if (sL == null) {
                t = t + WordsToolkit.toUpperCase((String)Words.NONE);
                this.deliveryCosts.setText(t);
                this.costsDelivery = new PriceComplete(null, Double.valueOf(0.0));
                this.updateTotalCosts();
                return;
            }
            supplier = (SupplierComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getSupplier(new SupplierReference(sL.getId())).getValue();
            this.editor.getModel().getNode().getChildNamed(new String[]{"supplier"}).setValue((Object)supplier, 0L);
        }
        PriceComplete ds = null;
        if (supplier.getCostType() != null) {
            switch (supplier.getCostType()) {
                case FIX: {
                    ds = new PriceComplete(supplier.getDeliveryCost());
                    break;
                }
                case MINAMOUNT: {
                    PriceComplete costs = (PriceComplete)this.totalView.getNode().getValue();
                    PriceComplete minValue = supplier.getMinOrderValue();
                    if (!(costs.getPrice() < minValue.getPrice())) break;
                    ds = new PriceComplete(supplier.getDeliveryCost());
                    break;
                }
                case NONE: {
                    break;
                }
            }
        }
        if (ds == null) {
            t = t + WordsToolkit.toUpperCase((String)Words.NONE);
            this.costsDelivery = new PriceComplete(supplier.getPaymentCurrency(), Double.valueOf(0.0));
        } else {
            t = t + ds.getFormattedPrice() + " " + ds.getCurrency().getCode();
            this.costsDelivery = new PriceComplete(ds);
        }
        this.deliveryCosts.setText(t);
        this.updateTotalCosts();
    }

    public void updateDeliveryTime() throws ClientServerCallException {
        Integer maxDeliveryDays = 0;
        Iterator it = this.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.orderPositions).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node condition;
            Node n = (Node)it.next();
            Node articleNode = n.getChildNamed(PurchaseOrderPositionComplete_.article);
            if (articleNode == null || articleNode.getValue() == null || (condition = n.getChildNamed(PurchaseOrderPositionComplete_.supplierCondition)) == null || condition.getValue() == null) continue;
            Integer days = ((SupplierConditionComplete)condition.getValue()).getDeliveryTime();
            if (days == null) {
                days = 0;
            }
            if (maxDeliveryDays >= days) continue;
            maxDeliveryDays = days;
        }
        if (maxDeliveryDays != 0) {
            long aDay = 86400000L;
            long offsetTime = aDay * (long)maxDeliveryDays.intValue();
            Date newDeliveryDate = new PeriodComplete(new Date(System.currentTimeMillis() + offsetTime), new Date(System.currentTimeMillis() + offsetTime)).getStartDate();
            Date oldDate = (Date)this.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate).getValue();
            if (newDeliveryDate.getTime() != oldDate.getTime()) {
                this.getEditor().getModel().getNode().getChildNamed(PurchaseOrderComplete_.deliveryDate).setValue((Object)newDeliveryDate, 0L);
            }
        }
    }

    public void loadTotalCosts() {
        this.totalView.load(true);
    }

    public boolean checkOrderableState() {
        boolean b = this.isOrderPlacable();
        this.editor.enableSaveButton(b);
        return b;
    }

    public static BasicArticleComplete loadArticleComplete(Node n, Component observer) throws ClientServerCallException {
        BasicArticleComplete artC = null;
        if (n.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class) == null) {
            BasicArticleReference artL = (BasicArticleReference)n.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleReference.class);
            if (artL == null) {
                return null;
            }
            try {
                artC = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle(new BasicArticleReference(artL.getId())).getValue();
                n.getChildNamed(PurchaseOrderPositionComplete_.article).setValue((Object)artC, 0L);
            }
            catch (ClientGetFromServerException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), observer);
            }
        } else {
            artC = (BasicArticleComplete)n.getChildNamed(PurchaseOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
        }
        return artC;
    }

    public static Node initArticle(Node n, SupplierReference injectedSupplier, Component source, Boolean useTaxZone, TaxZoneComplete taxZone, Timestamp validity) throws ClientServerCallException {
        BasicArticleComplete artC = ArticleOrderDetailsPanel.loadArticleComplete(n, source);
        SupplierConditionComplete cc = ArticleToolkit.getSupplierCondition(artC, injectedSupplier, useTaxZone, taxZone, validity);
        if (cc == null) {
            return null;
        }
        n.getChildNamed(PurchaseOrderPositionComplete_.supplierCondition).setValue((Object)CopyTemplateToolkit.copySupplierCondition((SupplierConditionComplete)cc), 0L);
        return n;
    }

    @Override
    public void allDone() {
        super.allDone();
    }

    @Override
    public void lafAttributeChanged(String att) {
        super.lafAttributeChanged(att);
        if (this.totalView != null) {
            this.totalView.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
        if (this.deliveryCosts != null) {
            this.deliveryCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
        if (this.totalCosts != null) {
            this.totalCosts.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("productoverview_pricetext_font_type")));
        }
    }

    private void setTotalCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                Node pn;
                PriceComplete currentPrice = new PriceComplete();
                SupplierComplete sup = (SupplierComplete)ArticleOrderDetailsPanel.this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.supplier).getValue(SupplierComplete.class);
                currentPrice.setPrice(Double.valueOf(0.0));
                if (sup != null) {
                    currentPrice.setCurrency(sup.getPaymentCurrency());
                } else {
                    SystemSettingsComplete setting = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    currentPrice.setCurrency(setting.getCurrency());
                }
                if (ArticleOrderDetailsPanel.this.table == null) {
                    return;
                }
                for (Table2RowPanel p : (List)((ArrayList)ArticleOrderDetailsPanel.this.table.getRows()).clone()) {
                    TableRowImpl pp = (TableRowImpl)p;
                    PriceComplete o = pp.getPrice();
                    PriceComplete pi = null;
                    if (o != null && o instanceof PriceComplete) {
                        pi = pp.getPrice();
                    }
                    if (pi == null) continue;
                    double amount = pi.getPrice();
                    CurrencyComplete u = pi.getCurrency();
                    if (u.equals((Object)currentPrice.getCurrency())) {
                        currentPrice.setPrice(Double.valueOf(currentPrice.getPrice() + amount));
                        continue;
                    }
                    double a = UnitConversionToolkit.getPriceIn((CurrencyComplete)currentPrice.getCurrency(), (PriceComplete)pi, (CurrencyVariantAccessor)ArticleOrderDetailsPanel.this.accessor, (Timestamp)new Timestamp(System.currentTimeMillis()));
                    currentPrice.setPrice(Double.valueOf(currentPrice.getPrice() + a));
                }
                if (currentPrice.getPrice() == null) {
                    currentPrice.setPrice(Double.valueOf(0.0));
                }
                if ((pn = ArticleOrderDetailsPanel.this.totalView.getNode()) == null) {
                    pn = new EmbeddedDTONode();
                    ArticleOrderDetailsPanel.this.totalView.setNode(pn);
                }
                pn.setValue((Object)currentPrice, 0L);
                ArticleOrderDetailsPanel.this.costsMaterial = currentPrice;
                pn.updateNode();
                ArticleOrderDetailsPanel.this.totalView.updateString();
                try {
                    ArticleOrderDetailsPanel.this.updateDeliveryCost();
                }
                catch (ClientServerCallException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean isAlive() {
                return !ArticleOrderDetailsPanel.this.totalView.isKilled();
            }
        };
        this.totalView.setRunnable(run);
    }

    private boolean isOrderPlacable() {
        if (this.table.getRowCount() == 0) {
            return false;
        }
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.isArticleSet() && !pp.isLoading()) continue;
            return false;
        }
        return true;
    }

    protected void clearRows() {
        long currentId = System.currentTimeMillis();
        if (this.table.getModel().getNode() == null) {
            return;
        }
        Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            this.table.getModel().getNode().removeChild(n, currentId);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.hasBackground) {
            g2.setColor(this.innerBackground);
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.arcW, this.arcH);
        }
        if (this.hasSkin) {
            this.skin.paint(g2, 0, 0, this.getWidth(), this.getHeight(), Button.ButtonState.UP);
        }
        if (this.useCliping) {
            g2.clip(this.getClipingArea());
        }
        int fadeHeight = this.skinBackFade.getImage(11).getHeight();
        this.skinBackFade.paint(g2, 0, this.getHeight() - fadeHeight * 3, this.getWidth(), 11);
        this.skinBackFade.paint(g2, 0, this.getHeight() - fadeHeight * 2, this.getWidth(), 11);
        this.skinBackFade.paint(g2, 0, this.getHeight() - fadeHeight * 1, this.getWidth(), 11);
        this.paintChildren(g2);
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        boolean hasNullArticles = false;
        boolean hasArticleWithAmount = false;
        Boolean useTaxZone = (Boolean)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.useTaxZone).getValue();
        TaxZoneComplete taxZone = (TaxZoneComplete)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.taxZone).getValue();
        for (Table2RowPanel p : this.table.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            List<ScreenValidationObject> returns = pp.validateRow(this.confPanel.getDeliveryDate(), useTaxZone, taxZone);
            if (returns != null) {
                validationObjects.addAll(returns);
            }
            if (!pp.hasAmount()) {
                hasNullArticles = true;
                continue;
            }
            hasArticleWithAmount = true;
        }
        if (hasArticleWithAmount) {
            if (hasNullArticles) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, Words.ALL_ARTICLES_WITH_ZERO_AMOUNT_WILL_BE_REMOVED));
            }
        } else {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_AT_LEAST_ONE_POSITION));
        }
        return validationObjects;
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setEnabled(isEnabled);
        this.deliveryCosts.setEnabled(isEnabled);
        this.totalCosts.setEnabled(isEnabled);
        this.totalView.setEnabled(isEnabled);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        int fh = this.skinBackFade.getImage(11).getHeight();
        this.table.setSize(parent.getWidth(), parent.getHeight() - (fh * 3 + 10));
        int i = this.table.getModel().getColumnWidth(0);
        this.totalView.setLocation(i += this.table.getModel().getColumnWidth(1), (int)((double)(this.table.getY() + this.table.getHeight() + 10) + ((double)fh - this.totalView.getPreferredSize().getHeight()) / 2.0));
        this.totalView.setSize(parent.getWidth() - (this.totalView.getX() + 10), (int)this.totalView.getPreferredSize().getHeight());
        this.deliveryCosts.setLocation(i, (int)((double)(this.table.getY() + this.table.getHeight() + 10 + fh) + ((double)fh - this.deliveryCosts.getPreferredSize().getHeight()) / 2.0));
        this.deliveryCosts.setSize(parent.getWidth() - (this.deliveryCosts.getX() + 10), (int)this.deliveryCosts.getPreferredSize().getHeight());
        this.totalCosts.setLocation(i, (int)((double)(this.table.getY() + this.table.getHeight() + 10 + 2 * fh) + ((double)fh - this.totalCosts.getPreferredSize().getHeight()) / 2.0));
        this.totalCosts.setSize(parent.getWidth() - (this.totalCosts.getX() + 10), (int)this.totalCosts.getPreferredSize().getHeight());
    }

    @Override
    public Dimension calculateContainerPreferredSize() {
        int fh = this.skinBackFade.getImage(11).getHeight() * 3;
        return new Dimension(0, (int)this.table.getPreferredSize().getHeight() + 10 + fh);
    }

    public void setSupplierSet() {
        if (!this.onlyAddFromTemplate) {
            this.table.setUseAddButton(true);
        }
        this.table.setEnabled(this.table.isEnabled());
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    public void allLoaded() {
        this.table.updateOrder();
    }

    public CurrencyVariantAccessor getAccessor() {
        return this.accessor;
    }
}

