/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.PriceConverter3;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.threewaymatch.ThreeWayMatchToolkit;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorFiveWithCheckRenderer;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceImportComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceOrderChargeComplete;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceOrderChargeComplete_;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMInvoiceStateE;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class InvoiceDetailsPanel
extends TableDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;

    public InvoiceDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider) {
        super(editor, provider, false);
        this.setTitleText(Words.THREE_WAY_MATCH);
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = TableColumnInfo.state5 + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.STATE, tw, tw, tw));
        tw = TableColumnInfo.periodColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.INVOICE, tw, tw, tw));
        tw = TableColumnInfo.priceColumnWidth + 2 * this.table.getCellPadding();
        columns.add(new TableColumnInfo(Words.PRICE, tw, tw, tw));
        columns.add(new TableColumnInfo(Words.CHARGED, tw, tw, tw));
        columns.add(new TableColumnInfo(Words.REMARK, tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(1.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setProvider(this.provider);
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl r = new TableRowImpl(model);
        r.setUseControlSkin(Table2RowPanel.TableControlsType.NONE);
        return r;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(PurchaseOrderComplete_.sapInvoice));
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private StateIndicatorFiveWithCheckRenderer<TWMInvoiceStateE> state;
        private TextLabel invoiceNo;
        private TextLabel charged;
        private TextLabel price;
        private TextLabel comment;
        private InfoButton info;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setLayout(new RowLayout());
            this.state = new StateIndicatorFiveWithCheckRenderer(m.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.state}), (Node<Boolean>)m.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.acceptAnyway}));
            this.invoiceNo = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.documentNumber}));
            this.charged = new TextLabel(m.getNode().getChildNamed(TWMInvoiceOrderChargeComplete_.chargedPrice), ConverterRegistry.getConverter(PriceConverter3.class));
            this.price = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.price}), ConverterRegistry.getConverter(PriceConverter3.class));
            this.comment = new TextLabel(m.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.acceptAnywayRemark}));
            this.info = new InfoButton(Words.ACCEPT_ANYWAY_MESSAGE);
            this.info.installStringViewer(ThreeWayMatchToolkit.getInvoiceText(((TWMInvoiceOrderChargeComplete)m.getNode().getValue()).getInvoice()));
            this.add(this.state);
            this.add(this.invoiceNo);
            this.add(this.charged);
            this.add(this.price);
            this.add(this.comment);
            this.add(this.info);
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.info.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.state}).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.documentNumber}).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(new DtoField[]{TWMInvoiceOrderChargeComplete_.invoice, TWMInvoiceImportComplete_.price}).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(TWMInvoiceOrderChargeComplete_.chargedPrice).getValue();
                }
                case 4: {
                    return this.comment.getText();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            this.invoiceNo.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.charged.setEnabled(isEnabled);
            this.comment.setEnabled(isEnabled);
            this.info.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.state.kill();
            this.invoiceNo.kill();
            this.price.kill();
            this.charged.kill();
            this.comment.kill();
            this.info.kill();
            this.state = null;
            this.invoiceNo = null;
            this.price = null;
            this.charged = null;
            this.comment = null;
            this.info = null;
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.invoiceNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.invoiceNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.invoiceNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.invoiceNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.charged.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.charged.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.charged.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.charged.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize((int)((double)w - ((double)(3 * TableRowImpl.this.getCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.comment.getX() + TableRowImpl.this.comment.getWidth() + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
            }
        }
    }
}

