/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reporting.insert;

import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.modules.reporting.ReportingModule;
import ch.icit.pegasus.client.gui.submodules.print.store.abc.PrintABCStoreComponent;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.report.ABCAnalysisReportConfiguration;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class ABCInsert
extends DefaultDataInsert
implements ButtonListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private PrintABCStoreComponent config;
    private TablePanelAddSaveButton printButton;
    private final Node<ABCAnalysisReportConfiguration> node;
    private final ReportingModule module;

    public ABCInsert(ReportingModule module) {
        super(module);
        this.module = module;
        ABCAnalysisReportConfiguration e = new ABCAnalysisReportConfiguration();
        this.node = INodeCreator.getDefaultImpl().getNode4DTO((Object)e, false, false);
    }

    @Override
    public void insertElements() {
        this.config = new PrintABCStoreComponent();
        this.printButton = new TablePanelAddSaveButton();
        this.printButton.setText("Start");
        this.printButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.printButton);
        this.add(this.config);
        this.config.loadReportTypes();
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StaticEnumServiceManager.getAllArticleReportTypes();
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ABCInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.printButton.setEnabled(isEnabled);
            this.config.setEnabled(isEnabled);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.printButton.kill();
            this.config.kill();
        }
        this.printButton = null;
        this.config = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "ABC Analysis";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        List<ScreenValidationObject> a = this.config.validateBeforePrint();
        if (a != null && !a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to start Analysis", (Component)this);
        } else {
            this.node.commit();
            this.module.started();
            this.setEnabled(false);
            this.config.startPrinting();
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.module.ended();
        this.setEnabled(true);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (ABCInsert.this.animation != null) {
                ABCInsert.this.animation.setLocation((int)((double)parent.getWidth() - ABCInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - ABCInsert.this.animation.getPreferredSize().getHeight()) / 2);
                ABCInsert.this.animation.setSize(ABCInsert.this.animation.getPreferredSize());
            }
            if (ABCInsert.this.isInserted) {
                ABCInsert.this.printButton.setLocation((int)((double)parent.getWidth() - ((double)border + ABCInsert.this.printButton.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)border + ABCInsert.this.printButton.getPreferredSize().getHeight())));
                ABCInsert.this.printButton.setSize(ABCInsert.this.printButton.getPreferredSize());
                ABCInsert.this.config.setLocation(2, 2);
                ABCInsert.this.config.setSize(450, parent.getHeight() - 4);
            }
        }
    }
}

