/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manualcreator.details;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.requisitionorder.manualcreator.ManualRequisitionOrderCreatorModule;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.EnterListener;
import ch.icit.pegasus.client.gui.utils.Enterable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.focus.CustomFocusCyclePolicy;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBoxListener;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.RoundingStrategyE;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.StoreConditionTypeE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.RoundingToolkit;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ArticleDetailsPanel
extends SplitView
implements SearchTextField2Listener,
RemoteLoader,
ButtonListener,
NodeListener,
EnterListener {
    private static final long serialVersionUID = 1L;
    private SystemSettingsComplete settings;
    private UserComplete currentUser;
    private Table2 table;
    private int horizontalBorder;
    private boolean isBlocked;
    private int verticalBorder;
    private TitledItem<SearchTextField2> articleSearch;
    private InfoButton articleInfo;
    private TitledItem<InputComboBox2> quantity;
    private TextButton add;
    private TitledItem<ComboBox> receiveDepartment;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<TextField> deliveryTime;
    private TitledItem<StorePositionSearchBox> storePosition;
    private TextButton setDefaults;
    private VerticalSeparator sep1;
    private ManualRequisitionOrderCreatorModule mCreator;
    private Node orderList;
    private Node articleList;
    private BasicArticleComplete artC;
    private boolean isLoading;
    private CurrencyVariantAccessor accessor = new CurrencyVariantAccessorImpl();

    public ArticleDetailsPanel(ManualRequisitionOrderCreatorModule creator, RDProvider provider) {
        this.mCreator = creator;
        this.orderList = creator.getSplitView2List();
        this.articleList = creator.getSplitView1List();
        this.receiveDepartment = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(CostCenterConverter.class)), Words.REQUIRED_BY_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        long day = 86400000L;
        Date tomorrow = new Date(System.currentTimeMillis() + day);
        Node dateNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)tomorrow, false, false);
        dateNode.addNodeListener((NodeListener)this);
        this.deliveryTime = new TitledItem<TextField>(new TextField(dateNode, TextFieldType.DAYTIME), Words.TIME, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(dateNode), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.storePosition = new TitledItem<StorePositionSearchBox>(new StorePositionSearchBox(), Words.ORDER_TO, TitledItem.TitledItemOrientation.NORTH);
        this.storePosition.getElement().setNode((Node<StorePositionLight>)new DTOProxyNode());
        this.setDefaults = new TextButton(Words.SET_DEFAULTS);
        this.setDefaults.addButtonListener(this);
        this.sep1 = new VerticalSeparator();
        this.horizontalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_horizontal_border"));
        this.verticalBorder = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_vertical_border"));
        this.articleSearch = new TitledItem<SearchTextField2<BasicArticleLight>>(SearchTextField2Factory.getBasicArticleSearchField(true, new DTOProxyNode(), false, false), Words.ARTICLE, TitledItem.TitledItemOrientation.NORTH);
        this.quantity = new TitledItem<InputComboBox2>(new InputComboBox2((Node)new DTONode(), (Node)new DTOProxyNode(), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG), Words.QUANTITY, TitledItem.TitledItemOrientation.NORTH);
        this.articleInfo = new InfoButton();
        this.add = new TextButton(Words.ADD);
        this.add.addButtonListener(this);
        this.table = new Table2(false, "", false, false);
        this.table.setScrollDownOnAdd(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ArticleDetailsPanel.this.mCreator.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.ARTICLE), null, null, null, "", 40, 40, 40));
        int tw1 = 2 * this.table.getCellPadding() + InputComboBox2.getPreferredWidth(this, 3);
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.QUANTITY), null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.DELIVER_DEPARTMENT), null, null, null, "", 220, 220, 220));
        columns.add(new TableColumnInfo(WordsToolkit.toUpperCase((String)Words.STORE), null, null, null, "", 220, 220, 220));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        this.table.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.table.getModel().setNode(this.mCreator.getSplitView1List());
        this.setLayout(new Layout());
        this.articleInfo.setEnabled(false);
        this.quantity.setEnabled(false);
        this.add.setEnabled(false);
        this.articleSearch.getElement().addSearchTextFieldListener(this);
        this.quantity.getElement().addEnterListener(this);
        this.createFocusCycle();
        this.table.setSortable(false);
        this.add(this.table);
        this.add(this.articleInfo);
        this.add(this.articleSearch);
        this.add(this.quantity);
        this.add(this.add);
        this.add(this.receiveDepartment);
        this.add(this.deliveryDate);
        this.add(this.deliveryTime);
        this.add(this.storePosition);
        this.add(this.setDefaults);
        this.add(this.sep1);
    }

    private void createFocusCycle() {
        List<Component> a = this.getFocusComponents();
        CustomFocusCyclePolicy.revalidateFocusCyclePolicy(a, this);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.articleSearch.setEnabled(isEnabled);
        this.articleInfo.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        this.quantity.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        this.add.setEnabled(this.articleSearch.getElement().isItemSelected() && isEnabled);
        this.table.setEnabled(isEnabled);
        this.receiveDepartment.setEnabled(isEnabled);
        this.deliveryDate.setEnabled(isEnabled);
        this.deliveryTime.setEnabled(isEnabled);
        this.storePosition.setEnabled(isEnabled);
        this.setDefaults.setEnabled(isEnabled);
        this.sep1.setEnabled(isEnabled);
    }

    public void block() {
        this.isBlocked = true;
    }

    public void unblock() {
        this.isBlocked = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.articleSearch.kill();
        this.articleInfo.kill();
        this.quantity.kill();
        this.add.kill();
        this.table.kill();
        this.sep1.kill();
        this.receiveDepartment.kill();
        this.deliveryDate.kill();
        this.deliveryTime.kill();
        this.storePosition.kill();
        this.setDefaults.kill();
        this.articleSearch = null;
        this.articleInfo = null;
        this.quantity = null;
        this.add = null;
        this.table = null;
        this.sep1 = null;
        this.receiveDepartment = null;
        this.deliveryDate = null;
        this.deliveryTime = null;
        this.storePosition = null;
        this.setDefaults = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.articleSearch.getFocusComponents();
        if (this.articleSearch.getElement().isItemSelected()) {
            CheckedListAdder.addToList(a, this.quantity);
            CheckedListAdder.addToList(a, this.add);
        }
        CheckedListAdder.addToList(a, this.receiveDepartment);
        CheckedListAdder.addToList(a, this.deliveryDate);
        CheckedListAdder.addToList(a, this.deliveryTime);
        CheckedListAdder.addToList(a, this.storePosition);
        CheckedListAdder.addToList(a, this.setDefaults);
        return a;
    }

    private void addArticle() {
        if (this.articleSearch.getElement().getNode().getValue(BasicArticleComplete.class) == null || this.isLoading) {
            InnerPopupFactory.showErrorDialog("Please wait till selected Article is completely loaded. Press Add again.", (Component)this.add);
            return;
        }
        this.insertArticle((BasicArticleComplete)this.articleSearch.getElement().getNode().getValue(BasicArticleComplete.class), TransactionToolkit.getLongValue(this.quantity.getElement().getValueNode()).longValue(), (UnitComplete)this.quantity.getElement().getUnitNode().getValue(), false);
    }

    public void insertArticle(BasicArticleComplete article, double orderAmount, UnitComplete orderUnit, boolean normalize) {
        CostCenterComplete deliverCostCenter = article.getDefaultRequisitionDeliverDepartment();
        Date validity = this.getDeliveryDate();
        RequisitionOrderPositionComplete npos = new RequisitionOrderPositionComplete();
        npos.setClientOId(Long.valueOf(ADTO.getNextId()));
        npos.setArticle((BasicArticleLight)article);
        npos.setDeliverState(OrderStateE.PLACED);
        npos.setState(OrderStateE.PLACED);
        QuantityComplete qc = new QuantityComplete(Double.valueOf(orderAmount), orderUnit);
        if (normalize && (qc = UnitConversionToolkit.normalizeQuantity((QuantityComplete)qc, (BasicArticleComplete)article, (Timestamp)new Timestamp(validity.getTime()))).getQuantity() == 0.0) {
            qc.setUnit(article.getFloatStoreUnit());
        }
        StoreQuantityComplete q = new StoreQuantityComplete();
        Double nd = RoundingToolkit.round((Double)qc.getQuantity(), (RoundingStrategyE)RoundingStrategyE.UP);
        q.setAmount(Long.valueOf(nd.longValue()));
        q.setUnit(qc.getUnit());
        q.setClientOId(Long.valueOf(q.getNextId()));
        int i = UnitConversionToolkit.isUnitContaining((UnitComplete)q.getUnit(), (UnitComplete)article.getFloatStoreUnit(), (BasicArticleLight)article, (Timestamp)new Timestamp(validity.getTime()));
        switch (i) {
            case 3: 
            case 5: {
                break;
            }
            case 11: {
                InnerPopupFactory.showErrorDialog("Selected Unit (" + q.getUnit().getShortName() + ") is not convertible within Article's Packaging Table (" + article.getNumber() + " - " + article.getName() + "). Please delete current Article and add it again.", (Component)this);
                return;
            }
        }
        npos.setQuantity(q);
        DTOProxyNode supplier = new DTOProxyNode((Object)deliverCostCenter);
        supplier.setName("deliverBy");
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)npos, true, false);
        n.addChild((Node)supplier, 0L);
        this.articleList.addChild(n, 0L);
        Node order = this.getOrderNode4Supplier(deliverCostCenter, validity);
        n.getChildNamed(RequisitionOrderPositionComplete_.order).setValue(order.getValue(), 0L);
        order.getChildNamed(RequisitionOrderComplete_.orderPositions).addChild((Node)new DTOProxyNode(n), 0L);
        this.setEnabled(true);
        this.articleSearch.getElement().requestFocusOnSearchField();
        this.revalidate();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            this.addArticle();
        } else if (source == this.setDefaults) {
            this.mCreator.updateOrders(this.getSelectedDepartment(), this.getDeliveryDate(), this.getReceivePosition());
            for (Table2RowPanel table2RowPanel : this.table.getRows()) {
                TableRowImpl tableRowImpl = (TableRowImpl)table2RowPanel;
            }
        }
    }

    private StorePositionLight getReceivePosition() {
        return (StorePositionLight)this.storePosition.getElement().getNode().getValue();
    }

    private Date getDeliveryDate() {
        Date validity = null;
        Object value = this.deliveryDate.getElement().getNode().getValue();
        if (value instanceof Date) {
            validity = (Date)this.deliveryDate.getElement().getNode().getValue();
        } else if (value instanceof Timestamp) {
            validity = new Date(((Timestamp)this.deliveryDate.getElement().getNode().getValue()).getTime());
        }
        return validity;
    }

    private InternalCostCenterComplete getSelectedDepartment() {
        return (InternalCostCenterComplete)this.receiveDepartment.getElement().getNode().getValue();
    }

    private Node getOrderNode4Supplier(CostCenterComplete department, Date validityDate) {
        if (department != null) {
            Iterator it = this.orderList.getChilds();
            while (it.hasNext()) {
                Node e = (Node)it.next();
                Node deliverDepartment = e.getChildNamed(RequisitionOrderLight_.deliveredBy);
                if (!department.equals(deliverDepartment.getValue())) continue;
                return e;
            }
        }
        RequisitionOrderComplete o = new RequisitionOrderComplete();
        o.setClientOId(Long.valueOf(ADTO.getNextId()));
        o.setRequiredOn(validityDate);
        o.setDeliveredBy(department);
        o.setRequiredBy((CostCenterComplete)this.getSelectedDepartment());
        o.setState(OrderStateE.PLACED);
        o.getEligibleLocations().add(this.currentUser.getDefaultLocation());
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)o, false, false);
        this.orderList.addChild(n, 0L);
        return n;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        this.isLoading = true;
        if (n.getValue() != null) {
            if (n != null && n.getValue(BasicArticleComplete.class) == null) {
                new BasicArticleLoader((BasicArticleReference)n.getValue(BasicArticleLight.class), this, n, this);
            } else {
                this.remoteObjectLoaded(n);
            }
        } else {
            this.articleInfo.setEnabled(false);
            this.quantity.setEnabled(false);
            this.add.setEnabled(false);
        }
    }

    private Node getDepartmentList(BasicArticleComplete ac) {
        return NodeToolkit.getAffixList(InternalCostCenterComplete.class);
    }

    private void updateInfoButtonAndUnitsForArticleSearch() {
        if (this.articleSearch.getElement().isItemSelected() && this.artC != null) {
            Date date = null;
            date = this.deliveryDate.getElement().getNode().getValue() instanceof Timestamp ? new Date(((Timestamp)this.deliveryDate.getElement().getNode().getValue()).getTime()) : (Date)this.deliveryDate.getElement().getNode().getValue();
            this.articleInfo.installStringViewer(ArticleToolkit.getArticleInfoPopupString(this.artC, new Timestamp(date.getTime()), 373065, false));
            List list = StoreToolkit.getPossibleUnits((BasicArticleLight)this.artC, null, (Timestamp)new Timestamp(date.getTime()), (TransactionType)TransactionType.REQUISITION, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
            this.quantity.getElement().setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
        }
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        this.artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
        if (this.artC == null) {
            if (node.getValue(BasicArticleLight.class) != null) {
                BasicArticleLight artL = (BasicArticleLight)node.getValue(BasicArticleLight.class);
                new BasicArticleLoader((BasicArticleReference)artL, this, node, this);
                return;
            }
            return;
        }
        this.articleInfo.installStringViewer(ArticleToolkit.getArticleInfoPopupString(this.artC, new Timestamp(this.getDeliveryDate().getTime()), 373065, false));
        Long amount = 0L;
        boolean hasFocusAlready = false;
        if (this.quantity.getElement().getTextField().getTextField().hasFocus()) {
            hasFocusAlready = true;
            amount = (Long)this.quantity.getElement().getValueNode().getValue();
        }
        StoreQuantityComplete q = new StoreQuantityComplete();
        q.setClientOId(Long.valueOf(q.getNextId()));
        q.setAmount(amount);
        q.setUnit(this.artC.getFloatStoreUnit());
        this.updateInfoButtonAndUnitsForArticleSearch();
        this.quantity.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false));
        this.quantity.getElement().getValueNode().addNodeListener((NodeListener)this);
        this.quantity.getElement().getUnitNode().addNodeListener((NodeListener)this);
        this.setEnabled(true);
        this.createFocusCycle();
        if (hasFocusAlready) {
            this.quantity.getElement().getTextField().setTextSelected();
        } else {
            this.quantity.getElement().requestFocusInWindowNow();
        }
        this.isLoading = false;
    }

    private Date getCurrentDeliveryDate() {
        if (this.deliveryDate.getElement().getNode().getValue() instanceof Date) {
            Date date = (Date)this.deliveryDate.getElement().getNode().getValue();
            return new Date(date.getTime());
        }
        Timestamp date = (Timestamp)this.deliveryDate.getElement().getNode().getValue();
        return new Date(date.getTime());
    }

    public void switchDepartment(Node node, InternalCostCenterComplete oldDepartment, InternalCostCenterComplete newDepartment) {
        Node oldOne = this.getOrderNode4Supplier((CostCenterComplete)oldDepartment, this.getCurrentDeliveryDate());
        Node newOne = null;
        if (newDepartment != null) {
            newOne = this.getOrderNode4Supplier((CostCenterComplete)newDepartment, this.getCurrentDeliveryDate());
        }
        Node currentNode = node;
        this.removeReferenceNode(oldOne, currentNode);
        if (newOne != null) {
            newOne.getChildNamed(RequisitionOrderComplete_.orderPositions).addChild((Node)new DTOProxyNode(currentNode), 0L);
        }
    }

    private void removeReferenceNode(Node order, Node position) {
        Node n;
        HashSet<Node> foundOrders = new HashSet<Node>();
        Iterator it = order.getChildNamed(RequisitionOrderComplete_.orderPositions).getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            if (!n.getValue().equals(position.getValue())) continue;
            order.getChildNamed(RequisitionOrderComplete_.orderPositions).removeChild(n, 0L);
            foundOrders.add(order);
        }
        it = this.orderList.getFailSafeChildIterator();
        while (it.hasNext()) {
            n = (Node)it.next();
            Iterator it2 = n.getChildNamed(RequisitionOrderComplete_.orderPositions).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node nn = (Node)it2.next();
                if (!nn.getValue().equals(position.getValue())) continue;
                n.getChildNamed(RequisitionOrderComplete_.orderPositions).removeChild(nn, 0L);
                foundOrders.add(n);
            }
        }
        for (Node o : foundOrders) {
            if (o.getChildNamed(RequisitionOrderComplete_.orderPositions).getChildCount() != 0) continue;
            o.getParent().removeChild(o, 0L);
        }
    }

    private Node getDepartmentList(Node article) {
        return NodeToolkit.getAffixList(InternalCostCenterComplete.class);
    }

    @Override
    public void resetData() {
        this.table.getModel().getNode().removeAllChilds();
    }

    public void valueChanged(Node<?> node) {
        this.updateInfoButtonAndUnitsForArticleSearch();
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void enterPressed(Enterable source) {
        this.addArticle();
    }

    public boolean isSwingOnly() {
        return true;
    }

    public CurrencyVariantAccessor getAccessor() {
        return this.accessor;
    }

    public void setAccessor(CurrencyVariantAccessor accessor) {
        this.accessor = accessor;
    }

    public void screenSetted() {
        this.receiveDepartment.getElement().refreshPossibleValues(NodeToolkit.getAffixList(InternalCostCenterComplete.class));
        this.receiveDepartment.getElement().getNode().setValue(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getDepartments().get(0), 0L);
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    ItemListener,
    StorePositionSearchBoxListener {
        private static final long serialVersionUID = 1L;
        private TextLabel aName;
        private InputComboBox2 aQuantity;
        private ComboBox aDepartment;
        private DeleteButton delete;
        private InfoButton info;
        private StorePositionSearchBox store;
        private InternalCostCenterComplete currentDepartment;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            if (m.getNode().getChildNamed(DtoFieldConstants.requisitionDeliveryBy) == null) {
                DTOProxyNode n = new DTOProxyNode();
                n.setName(DtoFieldConstants.requisitionDeliveryBy);
                m.getNode().addChild((Node)n, 0L);
            }
            if (m.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore) == null) {
                BasicArticleComplete article = (BasicArticleComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue();
                for (StoreConditionComplete sc : article.getStoreConditions()) {
                    if (sc.getType() != StoreConditionTypeE.REQUISITION_CHECKIN) continue;
                    m.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore).setValue((Object)sc.getPosition().getStore(), 0L);
                }
            }
            this.aName = new TextLabel(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            this.aQuantity = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
            this.info = new InfoButton();
            this.info.installStringViewer(ArticleToolkit.getArticleInfoPopupString((BasicArticleComplete)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class), new Timestamp(System.currentTimeMillis()), 373065, false));
            BasicArticleComplete ac = (BasicArticleComplete)this.model.getNode().getChildNamed(RequisitionOrderPositionComplete_.article).getValue(BasicArticleComplete.class);
            List list = StoreToolkit.getPossibleUnits((BasicArticleLight)ac, null, (Timestamp)new Timestamp(ArticleDetailsPanel.this.getDeliveryDate().getTime()), (TransactionType)TransactionType.REQUISITION, (UserComplete)ArticleDetailsPanel.this.currentUser, null, null, (SystemSettingsComplete)ArticleDetailsPanel.this.settings);
            this.aQuantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
            this.aQuantity.setNode(m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.amount}), m.getNode().getChildNamed(new DtoField[]{RequisitionOrderPositionComplete_.quantity, StoreQuantityComplete_.unit}));
            this.store = new StorePositionSearchBox();
            this.store.setFilter(TransactionType.REQUISITION_RECEIVE);
            this.store.addSearchListener(this);
            this.store.setNode((Node<StorePositionLight>)m.getNode().getChildNamed(RequisitionOrderPositionComplete_.receivingStore));
            this.aDepartment = new ComboBox(m.getNode().getChildNamed(DtoFieldConstants.requisitionDeliveryBy), ArticleDetailsPanel.this.getDepartmentList(m.getNode().getChildNamed(RequisitionOrderPositionComplete_.article)), ConverterRegistry.getConverter(CostCenterConverter.class));
            this.delete = new DeleteButton();
            this.delete.addButtonListener(this);
            this.aDepartment.addItemListener(this);
            this.setLayout(new InnerLayout());
            this.currentDepartment = (InternalCostCenterComplete)m.getNode().getChildNamed(DtoFieldConstants.requisitionDeliveryBy).getValue();
            this.add(this.aName);
            this.add(this.info);
            this.add(this.aQuantity);
            this.add(this.aDepartment);
            this.add(this.delete);
            this.add(this.store);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                ArticleDetailsPanel.this.switchDepartment(this.model.getNode(), this.currentDepartment, null);
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && !ArticleDetailsPanel.this.isBlocked) {
                Node n = (Node)e.getItem();
                InternalCostCenterComplete l = (InternalCostCenterComplete)n.getValue();
                ArticleDetailsPanel.this.switchDepartment(this.model.getNode(), this.currentDepartment, l);
                this.currentDepartment = l;
            } else if (ArticleDetailsPanel.this.isBlocked) {
                InternalCostCenterComplete l;
                Node n = (Node)e.getItem();
                this.currentDepartment = l = (InternalCostCenterComplete)n.getValue();
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.aQuantity);
            CheckedListAdder.addToList(a, this.aDepartment);
            CheckedListAdder.addToList(a, this.store);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.aName.setEnabled(isEnabled);
            this.aQuantity.setEnabled(isEnabled);
            this.aDepartment.setEnabled(isEnabled);
            this.delete.setEnabled(isEnabled);
            this.info.setEnabled(isEnabled);
            this.store.setEnabled(isEnabled);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.aName.kill();
            this.aQuantity.kill();
            this.aDepartment.kill();
            this.delete.kill();
            this.info.kill();
            this.store.kill();
            this.aName = null;
            this.aQuantity = null;
            this.aDepartment = null;
            this.delete = null;
            this.info = null;
            this.store = null;
        }

        @Override
        public void selectionChanged(SearchComboBox store, SearchTextField2 position) {
            StoreLight storeLight = (StoreLight)store.getNode().getValue();
            List list = StoreToolkit.getPossibleUnits((BasicArticleLight)ArticleDetailsPanel.this.artC, null, (Timestamp)new Timestamp(ArticleDetailsPanel.this.getDeliveryDate().getTime()), (TransactionType)TransactionType.REQUISITION, (UserComplete)ArticleDetailsPanel.this.currentUser, null, (StoreLight)storeLight, (SystemSettingsComplete)ArticleDetailsPanel.this.settings);
            this.aQuantity.setPossibleUnits((Node)UnitConversionToolkitNodeBased.getUnitList(list));
            if (list.isEmpty()) {
                this.aQuantity.clearSelectedUnit();
            } else {
                this.aQuantity.setSelectedUnit((UnitComplete)list.get(0));
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.aName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)((double)parent.getHeight() - TableRowImpl.this.aName.getPreferredSize().getHeight()));
                TableRowImpl.this.aName.setSize((int)((double)w - ((double)(2 * TableRowImpl.this.getCellPadding() + TableRowImpl.this.getInnerCellPadding()) + TableRowImpl.this.info.getPreferredSize().getWidth())), (int)TableRowImpl.this.aName.getPreferredSize().getHeight());
                TableRowImpl.this.info.setLocation(TableRowImpl.this.aName.getX() + TableRowImpl.this.aName.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.info.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.info.setSize(TableRowImpl.this.info.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.aQuantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aQuantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.aQuantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.aQuantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.aDepartment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aDepartment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.aDepartment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.aDepartment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.store.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.store.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.store.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.store.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.delete.getPreferredSize().getHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void layoutContainer(Container parent) {
            int aw = parent.getWidth() - (5 * ArticleDetailsPanel.this.horizontalBorder + 5);
            aw = (int)((double)aw - ArticleDetailsPanel.this.articleInfo.getPreferredSize().getWidth());
            aw = (int)((double)aw - ArticleDetailsPanel.this.quantity.getPreferredSize().getWidth());
            aw -= 350;
            if ((aw = (int)((double)aw - ArticleDetailsPanel.this.add.getPreferredSize().getWidth())) > 250) {
                aw = 250;
            }
            ArticleDetailsPanel.this.articleSearch.setLocation(ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.articleSearch.setSize(aw, (int)ArticleDetailsPanel.this.articleSearch.getPreferredSize().getHeight());
            ArticleDetailsPanel.this.articleInfo.setLocation(ArticleDetailsPanel.this.articleSearch.getX() + ArticleDetailsPanel.this.articleSearch.getWidth() + 5, (int)((double)(ArticleDetailsPanel.this.articleSearch.getY() + ArticleDetailsPanel.this.articleSearch.getHeight()) - (ArticleDetailsPanel.this.articleInfo.getPreferredSize().getHeight() + 3.0)));
            ArticleDetailsPanel.this.articleInfo.setSize(ArticleDetailsPanel.this.articleInfo.getPreferredSize());
            ArticleDetailsPanel.this.quantity.setLocation(ArticleDetailsPanel.this.articleInfo.getX() + ArticleDetailsPanel.this.articleInfo.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.quantity.setSize(ArticleDetailsPanel.this.quantity.getPreferredSize());
            ArticleDetailsPanel.this.add.setLocation(ArticleDetailsPanel.this.quantity.getX() + ArticleDetailsPanel.this.quantity.getWidth() + ArticleDetailsPanel.this.horizontalBorder, (int)((double)(ArticleDetailsPanel.this.quantity.getY() + ArticleDetailsPanel.this.quantity.getHeight()) - ArticleDetailsPanel.this.add.getPreferredSize().getHeight()));
            ArticleDetailsPanel.this.add.setSize(ArticleDetailsPanel.this.add.getPreferredSize());
            ArticleDetailsPanel.this.sep1.setLocation(ArticleDetailsPanel.this.add.getX() + ArticleDetailsPanel.this.add.getWidth() + ArticleDetailsPanel.this.horizontalBorder, 1);
            ArticleDetailsPanel.this.sep1.setSize((int)ArticleDetailsPanel.this.sep1.getPreferredSize().getWidth(), ArticleDetailsPanel.this.add.getY() + ArticleDetailsPanel.this.add.getHeight() + ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.receiveDepartment.setLocation(ArticleDetailsPanel.this.sep1.getX() + ArticleDetailsPanel.this.sep1.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.receiveDepartment.setSize(243, (int)ArticleDetailsPanel.this.receiveDepartment.getPreferredSize().getHeight());
            ArticleDetailsPanel.this.deliveryDate.setLocation(ArticleDetailsPanel.this.receiveDepartment.getX() + ArticleDetailsPanel.this.receiveDepartment.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.deliveryDate.setSize(ArticleDetailsPanel.this.deliveryDate.getPreferredSize());
            ArticleDetailsPanel.this.deliveryTime.setLocation(ArticleDetailsPanel.this.deliveryDate.getX() + ArticleDetailsPanel.this.deliveryDate.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.deliveryTime.setSize(60, (int)ArticleDetailsPanel.this.deliveryTime.getPreferredSize().getHeight());
            ArticleDetailsPanel.this.storePosition.setLocation(ArticleDetailsPanel.this.sep1.getX() + ArticleDetailsPanel.this.sep1.getWidth() + ArticleDetailsPanel.this.horizontalBorder, ArticleDetailsPanel.this.receiveDepartment.getY() + ArticleDetailsPanel.this.receiveDepartment.getHeight() + ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.storePosition.setSize(220, (int)ArticleDetailsPanel.this.storePosition.getPreferredSize().getHeight());
            ArticleDetailsPanel.this.setDefaults.setLocation(ArticleDetailsPanel.this.storePosition.getX() + ArticleDetailsPanel.this.storePosition.getWidth() + ArticleDetailsPanel.this.horizontalBorder, (int)((double)(ArticleDetailsPanel.this.storePosition.getY() + ArticleDetailsPanel.this.storePosition.getHeight()) - ArticleDetailsPanel.this.setDefaults.getPreferredSize().getHeight()));
            ArticleDetailsPanel.this.setDefaults.setSize(ArticleDetailsPanel.this.setDefaults.getPreferredSize());
            ArticleDetailsPanel.this.table.setLocation(2, ArticleDetailsPanel.this.storePosition.getY() + ArticleDetailsPanel.this.storePosition.getHeight() + ArticleDetailsPanel.this.verticalBorder);
            ArticleDetailsPanel.this.table.setSize(parent.getWidth() - 4, parent.getHeight() - (ArticleDetailsPanel.this.table.getY() + 2));
            ArticleDetailsPanel.this.sep1.setSize((int)ArticleDetailsPanel.this.sep1.getPreferredSize().getWidth(), parent.getHeight() - (ArticleDetailsPanel.this.table.getY() + 1));
        }
    }
}

