/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retail.details;

import ch.icit.pegasus.client.gui.modules.flight.details.utils.FlightProviderRule;
import ch.icit.pegasus.client.gui.modules.flight.utils.FlightEditableChecker;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDSearchComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.CalendarUtil;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete;
import ch.icit.pegasus.server.core.dtos.ordering.CustomsDocumentComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class TimeDetailsPanel
extends DefaultDetailsPanel<FlightLight> {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private Node<FlightComplete> root;
    private final FlightEditableChecker checker;
    private TitledItem<DateChooser> deliveryDate;
    private TitledItem<DateChooser> invoiceDate;
    private TitledItem<RDTextField> customerOrderNumber;
    private TitledItem<RDSearchComboBox> commissionSalesPerson;

    public TimeDetailsPanel(RowEditor<FlightLight> editor, RDProvider provider) {
        super(editor, provider);
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        this.checker = new FlightEditableChecker();
        this.setTitleText(Words.DETAILS);
        this.setCustomLayouter(new Layout());
        this.deliveryDate = new TitledItem<DateChooser>(new DateChooser(null), Words.DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.invoiceDate = new TitledItem<DateChooser>(new DateChooser(null), Words.INVOICE_DATE, TitledItem.TitledItemOrientation.NORTH);
        if (!this.isSolarCompany) {
            this.customerOrderNumber = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.CUSTOMER_ORDER_NUMBER, TitledItem.TitledItemOrientation.NORTH);
            this.addToView(this.customerOrderNumber);
            if (Boolean.TRUE.equals(settings.getProductCommissionActive())) {
                this.commissionSalesPerson = new TitledItem<RDSearchComboBox>(new RDSearchComboBox(provider, RDSearchComboBox.BoxSearchTypes.SALES_MAN), Words.SALES_PERSON, TitledItem.TitledItemOrientation.NORTH);
                this.addToView(this.commissionSalesPerson);
            }
        }
        this.addToView(this.deliveryDate);
        this.addToView(this.invoiceDate);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        this.setEnabled(this.isEnabled());
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        FlightLight value;
        boolean enabled = this.checker.canEditFlight(this.root, this.provider, isEnabled);
        super.setEnabled(enabled);
        this.deliveryDate.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.customerOrderNumber.setEnabled(isEnabled);
            if (this.commissionSalesPerson != null) {
                this.commissionSalesPerson.setEnabled(isEnabled);
            }
        }
        boolean invoiceClosed = (value = (FlightLight)this.root.getValue(FlightLight.class)) != null ? Boolean.TRUE.equals(value.getIsInvoiceClosed()) : false;
        this.invoiceDate.setEnabled(isEnabled && !invoiceClosed);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryDate.kill();
        this.deliveryDate = null;
        if (!this.isSolarCompany) {
            this.customerOrderNumber.kill();
        }
        this.customerOrderNumber = null;
        if (this.commissionSalesPerson != null) {
            this.commissionSalesPerson.kill();
            this.commissionSalesPerson = null;
        }
        this.invoiceDate.kill();
        this.invoiceDate = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.invoiceDate);
        CheckedListAdder.addToList(focusList, this.customerOrderNumber);
        CheckedListAdder.addToList(focusList, this.commissionSalesPerson);
        return focusList;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.root = node;
        if (this.provider.getAdditionalRule() == null) {
            this.provider.setAdditionalRule(new FlightProviderRule((FlightComplete)node.getValue(FlightComplete.class)));
        }
        if (node.getChildNamed(FlightComplete_.realstd).getValue() == null) {
            node.getChildNamed(FlightComplete_.realstd).setValue((Object)new Timestamp(System.currentTimeMillis()), 0L);
        }
        this.deliveryDate.getElement().setNode(node.getChildNamed(FlightComplete_.realstd));
        Node invoiceDateNode = node.getChildNamed(FlightComplete_.defaultInvoiceDate);
        if (invoiceDateNode.getValue() == null) {
            invoiceDateNode.setValue((Object)new Date(((Timestamp)node.getChildNamed(FlightComplete_.std).getValue()).getTime()), 0L);
        }
        this.invoiceDate.getElement().setNode(invoiceDateNode);
        if (!this.isSolarCompany) {
            Node orderNumbers = node.getChildNamed(FlightLight_.customsDocuments);
            if (orderNumbers.getValue() == null) {
                orderNumbers.setValue(new ArrayList(), System.currentTimeMillis());
            }
            if (orderNumbers.getChildCount() == 0) {
                CustomsDocumentComplete documentComplete = new CustomsDocumentComplete();
                documentComplete.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)documentComplete, true, false);
                orderNumbers.addChild(n, System.currentTimeMillis());
            }
            Node doc = orderNumbers.getChildAt(0);
            this.customerOrderNumber.getElement().setNode(doc.getChildNamed(CustomsDocumentComplete_.customsDocumentId));
            if (this.commissionSalesPerson != null) {
                this.commissionSalesPerson.getElement().setNode(node.getChildNamed(FlightLight_.commissionSalesPerson));
            }
        }
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        Timestamp stdD = CalendarUtil.getTimestamp((Node)this.deliveryDate.getElement().getNode());
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.realstd).setValue((Object)stdD, 0L);
        this.editor.getModel().getNode().getChildNamed(FlightComplete_.realstd).commit();
        return super.commitParagraph();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = TimeDetailsPanel.this.verticalBorder;
            h += TimeDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TimeDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            h += TimeDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + TimeDetailsPanel.this.invoiceDate.getPreferredSize().getHeight());
            if (!TimeDetailsPanel.this.isSolarCompany) {
                h += TimeDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + TimeDetailsPanel.this.customerOrderNumber.getPreferredSize().getHeight());
            }
            if (TimeDetailsPanel.this.commissionSalesPerson != null) {
                h += TimeDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + TimeDetailsPanel.this.commissionSalesPerson.getPreferredSize().getHeight());
            }
            return new Dimension(200, h += TimeDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            TimeDetailsPanel.this.deliveryDate.setLocation(TimeDetailsPanel.this.horizontalBorder, TimeDetailsPanel.this.verticalBorder);
            TimeDetailsPanel.this.deliveryDate.setSize(TimeDetailsPanel.this.deliveryDate.getPreferredSize());
            TimeDetailsPanel.this.invoiceDate.setLocation(TimeDetailsPanel.this.horizontalBorder, TimeDetailsPanel.this.deliveryDate.getY() + TimeDetailsPanel.this.deliveryDate.getHeight() + TimeDetailsPanel.this.inner_verticalBorder);
            TimeDetailsPanel.this.invoiceDate.setSize(TimeDetailsPanel.this.invoiceDate.getPreferredSize());
            if (!TimeDetailsPanel.this.isSolarCompany) {
                TimeDetailsPanel.this.customerOrderNumber.setLocation(TimeDetailsPanel.this.horizontalBorder, TimeDetailsPanel.this.invoiceDate.getY() + TimeDetailsPanel.this.invoiceDate.getHeight() + TimeDetailsPanel.this.inner_verticalBorder);
                TimeDetailsPanel.this.customerOrderNumber.setSize(parent.getWidth() - 2 * TimeDetailsPanel.this.horizontalBorder, (int)TimeDetailsPanel.this.customerOrderNumber.getPreferredSize().getHeight());
                if (TimeDetailsPanel.this.commissionSalesPerson != null) {
                    TimeDetailsPanel.this.commissionSalesPerson.setLocation(TimeDetailsPanel.this.horizontalBorder, TimeDetailsPanel.this.customerOrderNumber.getY() + TimeDetailsPanel.this.customerOrderNumber.getHeight() + TimeDetailsPanel.this.inner_verticalBorder);
                    TimeDetailsPanel.this.commissionSalesPerson.setSize(parent.getWidth() - 2 * TimeDetailsPanel.this.horizontalBorder, (int)TimeDetailsPanel.this.commissionSalesPerson.getPreferredSize().getHeight());
                }
            }
        }
    }
}

