/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.retailinmotion.details;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateTimeChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportComplete_;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionDataImportLight;
import ch.icit.pegasus.server.core.dtos.retailinmotion.RetailInMotionTransactionDataComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class TransactionDetailsPanel
extends TableDetailsPanel<RetailInMotionDataImportLight> {
    private static final long serialVersionUID = 1L;

    public TransactionDetailsPanel(RowEditor<RetailInMotionDataImportLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.TRANSACTIONS);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(RetailInMotionDataImportComplete_.transactions));
    }

    @Override
    public void resetParagraph() {
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(RetailInMotionDataImportComplete_.transactions));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        return validationObjects;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.FLIGHT, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.PRODUCT, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.FLIGHT, null, null, null, "", 100, 100, 100));
        int dw = DateTimeChooser.getPreferredWidth(this) - 15;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.STD, null, null, null, "", dw, dw, dw));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.EQUIPMENT, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.TRANSACTION_DATE, null, null, null, "", dw, dw, dw));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.TRANSACTION_TYPE, null, null, null, "", 40, 40, 40));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.PRODUCT_NUMBER, null, null, null, "", 75, 75, 75));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.PRODUCT_NAME, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.PRODUCT_SUPPLIER_NUMBER, null, null, null, "", 100, 100, 100));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.AMOUNT, null, null, null, "", 50, 50, 50));
        dw = CheckBox.getPreferredWidth() + this.table.getCellPadding() * 2;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.CORRECTED, null, null, null, "", dw, dw, dw));
        ((TableColumnInfo)headers.get(0)).setxExpand(0.5);
        ((TableColumnInfo)headers.get(1)).setxExpand(0.5);
        ((TableColumnInfo)headers.get(2)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(3)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(4)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(5)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(6)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(7)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(8)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(9)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(10)).setxExpand(0.0);
        ((TableColumnInfo)headers.get(11)).setxExpand(0.0);
        return headers;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<FlightLight> flightSearch;
        private SearchTextField2<ProductComplete> productSearch;
        private TextLabel flight;
        private TextLabel std;
        private TextLabel equipment;
        private TextLabel transactionDate;
        private TextLabel transactionType;
        private TextLabel productNo;
        private TextLabel productName;
        private TextLabel productSupplierNumber;
        private TextLabel amount;
        private CheckBox corrected;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.flightSearch = SearchTextField2Factory.getFlightSearchField(true, m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flight));
            this.productSearch = SearchTextField2Factory.getProductSearchField(true, m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.product));
            this.flightSearch.setAdditionalSearchField(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flightStd));
            this.flight = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flightCode));
            this.std = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flightStd), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.equipment = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.equipmentId), ConverterRegistry.getConverter(StringConverter.class));
            this.transactionDate = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.transactionTimestamp), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.transactionType = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.transactionType));
            this.productNo = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.productNumber));
            this.productName = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.productName));
            this.productSupplierNumber = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.productSupplierNumber));
            this.amount = new TextLabel(m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.amount), ConverterRegistry.getConverter(IntegerConverter.class));
            this.corrected = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.corrected));
            this.setLayout(new Layout());
            this.add(this.flightSearch);
            this.add(this.productSearch);
            this.add(this.flight);
            this.add(this.std);
            this.add(this.equipment);
            this.add(this.transactionDate);
            this.add(this.transactionType);
            this.add(this.productNo);
            this.add(this.productName);
            this.add(this.productSupplierNumber);
            this.add(this.amount);
            this.add(this.corrected);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            if (!TransactionDetailsPanel.this.provider.isWritable(RetailInMotionTransactionDataComplete_.flight)) {
                this.flightSearch.setEnabled(false);
            }
            if (!TransactionDetailsPanel.this.provider.isWritable(RetailInMotionTransactionDataComplete_.product)) {
                this.productSearch.setEnabled(false);
            }
            this.corrected.setEnabled(false);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.flightSearch);
            CheckedListAdder.addToList(a, this.productSearch);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flight).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.product).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flightCode).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.flightStd).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.equipmentId).getValue();
                }
                case 5: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.transactionTimestamp).getValue();
                }
                case 6: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.transactionType).getValue();
                }
                case 7: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.productNumber).getValue();
                }
                case 8: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.productName).getValue();
                }
                case 9: {
                    return this.model.getNode().getChildNamed(RetailInMotionTransactionDataComplete_.productSupplierNumber).getValue();
                }
                case 10: 
                case 11: {
                    return null;
                }
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.flightSearch.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flightSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flightSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flightSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.productSearch.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSearch.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSearch.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSearch.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.flight.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.flight.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.flight.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.flight.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.std.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.std.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.std.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.std.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.equipment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.equipment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.equipment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.equipment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.transactionDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.transactionDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.transactionDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.transactionDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(6);
                TableRowImpl.this.transactionType.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.transactionType.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.transactionType.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.transactionType.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(7);
                TableRowImpl.this.productNo.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productNo.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productNo.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productNo.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(8);
                TableRowImpl.this.productName.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productName.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productName.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productName.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(9);
                TableRowImpl.this.productSupplierNumber.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.productSupplierNumber.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.productSupplierNumber.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.productSupplierNumber.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(10);
                TableRowImpl.this.amount.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amount.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.amount.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.amount.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(11);
                TableRowImpl.this.corrected.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.corrected.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.corrected.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.corrected.getPreferredSize().getHeight());
            }
        }
    }
}

