/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.serviceproduct.details;

import ch.icit.pegasus.client.converter.PriceConverter2;
import ch.icit.pegasus.client.converter.TaxRateConverter;
import ch.icit.pegasus.client.converter.TaxRateRateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.serviceproduct.details.utils.Loader;
import ch.icit.pegasus.client.gui.screentemplates.details.StateDependantTableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.priceanimation.LoadingGroup;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.toolkits.PriceToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.TaxRateComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductComplete;
import ch.icit.pegasus.server.core.dtos.serviceproduct.ServiceProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TaxDetailsPanel
extends StateDependantTableDetailsPanel<ServiceProductComplete>
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Loader loader;

    public TaxDetailsPanel(RowEditor<ServiceProductComplete> editor, RDProvider provider) {
        super(editor, provider, true, true, true, true);
        this.setTitleText(Words.TAXES);
        this.loader = new Loader(this);
    }

    public boolean isDeletable() {
        return this.provider.isDeletable(ServiceProductVariantComplete_.taxRates);
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.TAX, null, null, null, "", 40, Integer.MAX_VALUE, 40));
        int tw1 = 2 * this.table.getCellPadding() + InputComboBox2.getPreferredWidth(this, 11);
        columns.add(new TableColumnInfo(Words.FACTOR, null, null, null, "", tw1, tw1, tw1));
        columns.add(new TableColumnInfo(Words.COST, null, null, null, "", tw1, tw1, tw1));
        int tw = 2 * this.table.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        return columns;
    }

    @Override
    public void configTable(Table2 table) {
        table.setRequestFocusOnAdd(true);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
        TaxRateComplete d = this.getFreeTax();
        if (d != null) {
            this.table.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)d, true, true), 0L);
        }
        this.ensureAddState();
    }

    @Override
    public void childRemoved() {
        this.ensureAddState();
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    @Override
    public DtoField<ModificationStateE> getStateChildName() {
        return ServiceProductVariantComplete_.state;
    }

    private void ensureAddState() {
        this.table.enableAddButton(this.getFreeTax() != null);
    }

    private TaxRateComplete getFreeTax() {
        Iterator it = NodeToolkit.getAffixList(TaxRateComplete.class).getChilds();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            boolean found = false;
            for (Table2RowPanel p : this.table.getRows()) {
                if (!p.getModel().getNode().getValue().equals(n.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (TaxRateComplete)n.getValue();
        }
        return null;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.node != null) {
            this.node.getChildNamed(ServiceProductVariantComplete_.salesPrice).removeNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.price}).removeNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}).removeNodeListener((NodeListener)this);
        }
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.node != null) {
            this.node.getChildNamed(ServiceProductVariantComplete_.salesPrice).removeNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.price}).removeNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}).removeNodeListener((NodeListener)this);
        }
        if (this.node != null) {
            this.node.getChildNamed(ServiceProductVariantComplete_.salesPrice).addNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.price}).addNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}).addNodeListener((NodeListener)this);
            this.table.getModel().setNode(node.getChildNamed(ServiceProductVariantComplete_.taxRates));
        }
    }

    @Override
    public void valueChanged(Node<?> node) {
        this.loader.updateAll();
    }

    @Override
    public void childAdded(Node<?> source, Node<?> child) {
    }

    @Override
    public void childRemoved(Node<?> source, Node<?> child) {
    }

    @Override
    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public boolean isSwingOnly() {
        return true;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private ComboBox tax;
        private TextLabel taxRate;
        private ReloadablePriceView costs;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.tax = new ComboBox(m.getNode(), NodeToolkit.getAffixList(TaxRateComplete.class), ConverterRegistry.getConverter(TaxRateConverter.class), false, true);
            m.getNode().addNodeListener((NodeListener)this);
            this.taxRate = new TextLabel(m.getNode(), ConverterRegistry.getConverter(TaxRateRateConverter.class));
            this.costs = new ReloadablePriceView((LoadingGroup)TaxDetailsPanel.this.loader, ConverterRegistry.getConverter(PriceConverter2.class));
            this.installCalculation();
            TaxDetailsPanel.this.loader.addTaxCosts(this.costs);
            if (TaxDetailsPanel.this.isDeletable()) {
                this.delete = new DeleteButton();
                this.delete.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.tax);
            this.add(this.taxRate);
            this.add(this.costs);
            if (this.delete != null) {
                this.add(this.delete);
            }
            this.costs.load(true);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.tax);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        public void installCalculation() {
            if (this.costs != null) {
                CalculationRunnable run = new CalculationRunnable(){

                    @Override
                    public void run() {
                        double d = (Double)TaxDetailsPanel.this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.price}).getValue();
                        CurrencyComplete c = (CurrencyComplete)TaxDetailsPanel.this.node.getChildNamed(new DtoField[]{ServiceProductVariantComplete_.salesPrice, PriceComplete_.currency}).getValue();
                        PriceComplete p1 = new PriceComplete();
                        p1.setPrice(Double.valueOf(d));
                        p1.setCurrency(c);
                        PriceComplete p3 = new PriceComplete();
                        p3.setClientOId(Long.valueOf(p3.getNextId()));
                        p3.setCurrency(p1.getCurrency());
                        p3.setPrice(p1.getPrice());
                        TaxRateComplete r = (TaxRateComplete)TableRowImpl.this.model.getNode().getValue();
                        d = r.getRate();
                        p3.setPrice(Double.valueOf(p3.getPrice() * (d /= 100.0)));
                        p3.setPrice(PriceToolkit.ensureDoubleFinite(p3.getPrice()));
                        Node pn = TableRowImpl.this.costs.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            TableRowImpl.this.costs.setNode(pn);
                        }
                        if (pn.getChildNamed(PriceComplete_.price) == null) {
                            Node pp = new Node();
                            pp.setName(PriceComplete_.price);
                            pn.addChild(pp, 0L);
                        }
                        pn.getChildNamed(PriceComplete_.price).setValue((Object)p3.getPrice(), 0L);
                        pn.setValue((Object)p3, 0L);
                    }

                    @Override
                    public boolean isAlive() {
                        if (TableRowImpl.this.costs != null) {
                            return !TableRowImpl.this.costs.isKilled();
                        }
                        return false;
                    }
                };
                this.costs.setRunnable(run);
            }
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return ((TaxRateComplete)this.tax.getNode().getValue()).getName();
                }
                case 1: {
                    return this.taxRate.getNode().getValue();
                }
                case 2: {
                    return this.costs.getNode().getValue();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.tax.setEnabled(isEnabled);
            this.costs.setEnabled(isEnabled);
            this.taxRate.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.model.getNode().removeNodeListener((NodeListener)this);
            this.tax.kill();
            this.costs.kill();
            this.taxRate.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            this.tax = null;
            this.costs = null;
            this.taxRate = null;
            this.delete = null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), 0L);
            }
        }

        public void valueChanged(Node<?> node) {
            this.costs.load(true);
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return false;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.tax.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.tax.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.tax.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.tax.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.taxRate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.taxRate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.taxRate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.taxRate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.costs.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.costs.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.costs.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.costs.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

