/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.spotcheck.documentscan.details;

import ch.icit.pegasus.client.converter.PurchaseOrderConverter;
import ch.icit.pegasus.client.converter.SupplierConverter;
import ch.icit.pegasus.client.converter.TimestampConverter;
import ch.icit.pegasus.client.converter.UserSignConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.screentemplates.details.TableDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.icons.impl.CheckBoxRO;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionLight_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReceivingGroupComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.allergen.AllergenSpotCheckReviewComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckReviewComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckReviewEntryComplete_;
import ch.icit.pegasus.server.core.dtos.spotcheck.documentscan.DocumentScanSpotCheckReviewLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class DocumentDetails
extends TableDetailsPanel<DocumentScanSpotCheckReviewLight> {
    private static final long serialVersionUID = 1L;

    public DocumentDetails(RowEditor<DocumentScanSpotCheckReviewLight> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.DETAILED_VIEW);
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode(node.getChildNamed(AllergenSpotCheckReviewComplete_.entries));
    }

    @Override
    public void resetParagraph() {
        this.table.getModel().setNode(this.editor.getModel().getNode().getChildNamed(DocumentScanSpotCheckReviewComplete_.entries));
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        return rets;
    }

    @Override
    public List<TableColumnInfo> getColumns(boolean add) {
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        headers.add(new TableColumnInfo(0.0, Words.DATE, TableColumnInfo.dateTimeColumnWidth + 2 * this.table.getCellPadding()));
        headers.add(new TableColumnInfo(0.0, Words.PURCHASE_ORDER, 100));
        headers.add(new TableColumnInfo(0.5, Words.SUPPLIER, 150));
        headers.add(new TableColumnInfo(0.0, Words.OK, TableColumnInfo.checkBoxColumnWith + 2 * this.table.getCellPadding()));
        headers.add(new TableColumnInfo(0.0, Words.NAME, TableColumnInfo.userColumnWidth + 2 * this.table.getCellPadding()));
        headers.add(new TableColumnInfo(0.5, Words.COMMENT, 100));
        headers.add(new TableColumnInfo(0.0, Words.REVIEWED, TableColumnInfo.checkBoxColumnWith + 2 * this.table.getCellPadding()));
        return headers;
    }

    @Override
    public void configTable(Table2 table) {
        table.setDontUseScrollBar(15);
        table.setSortedColumn(2);
        table.setSortDirection(false);
    }

    @Override
    public void addButtonPressed(int x, int y, Button source) {
    }

    @Override
    public void childRemoved() {
        this.editor.revalidate();
    }

    @Override
    public Table2RowPanel generateView(Table2RowModel model, boolean isHeader) {
        TableRowImpl p = new TableRowImpl(model);
        p.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
        return p;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel date;
        private TextLabel purchase;
        private TextLabel supplier;
        private CheckBoxRO docSpotCheck;
        private TextLabel user;
        private TextField reviewComment;
        private CheckBox approved;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            Node entry = m.getNode();
            Node recGroup = m.getNode().getChildNamed(DocumentScanSpotCheckReviewEntryComplete_.receivingGroup);
            Node order = recGroup.getChildNamed(PurchaseOrderPositionLight_.order);
            this.date = new TextLabel(recGroup.getChildNamed(PurchaseOrderReceivingGroupComplete_.creationDate), ConverterRegistry.getConverter(TimestampConverter.class));
            this.purchase = new TextLabel(order, ConverterRegistry.getConverter(PurchaseOrderConverter.class));
            this.supplier = new TextLabel(order.getChildNamed(PurchaseOrderComplete_.supplier), ConverterRegistry.getConverter(SupplierConverter.class));
            boolean hasDocument = recGroup.getChildNamed(PurchaseOrderReceivingGroupComplete_.documentScan).getValue() != null;
            ViewNode hasDocNode = new ViewNode("hasDoc");
            hasDocNode.setValue((Object)hasDocument, 0L);
            this.docSpotCheck = new CheckBoxRO((Node<Boolean>)hasDocNode);
            this.user = new TextLabel(recGroup.getChildNamed(PurchaseOrderReceivingGroupComplete_.creationUser), ConverterRegistry.getConverter(UserSignConverter.class));
            this.reviewComment = new TextField(entry.getChildNamed(DocumentScanSpotCheckReviewEntryComplete_.comment));
            this.approved = new CheckBox((Node<Boolean>)entry.getChildNamed(DocumentScanSpotCheckReviewEntryComplete_.reviewed));
            this.setLayout(new Layout());
            this.add(this.date);
            this.add(this.supplier);
            this.add(this.purchase);
            this.add(this.docSpotCheck);
            this.add(this.user);
            this.add(this.reviewComment);
            this.add(this.approved);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.reviewComment);
            CheckedListAdder.addToList(focusList, this.approved);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.date.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.date.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.date.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.date.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.purchase.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.purchase.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.purchase.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.purchase.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.supplier.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.supplier.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.supplier.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.supplier.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.docSpotCheck.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.docSpotCheck.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.docSpotCheck.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.docSpotCheck.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.user.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.user.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.user.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.user.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(5);
                TableRowImpl.this.reviewComment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.reviewComment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.reviewComment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.reviewComment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(6);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.approved.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.approved.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.approved.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.approved.getPreferredSize().getHeight());
            }
        }
    }
}

