/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.stock.details;

import ch.icit.pegasus.client.converter.ArticleCategoryConverter2;
import ch.icit.pegasus.client.converter.BasicArticleConverter;
import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DeletedBooleanConverter;
import ch.icit.pegasus.client.converter.InUseBooleanConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.ArticleLabelsPopup;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.BatchPositionConverter;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.BatchPositionRemoteConverter;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.EditChargePriceUnitExpiryPopup;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.PricePerUnit2Converter;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.PricePerUnitConverter;
import ch.icit.pegasus.client.gui.modules.stock.details.utils.StockExportPopup;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.renderer.CellViewBooleanRenderer;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.EditButton;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.buttons.InfoButton;
import ch.icit.pegasus.client.gui.utils.buttons.PrintScreenButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateRenderer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StoreArticleContentSearchAlgorithm;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.StoreAccess;
import ch.icit.pegasus.server.core.dtos.search.ABasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreArticleContentSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete_;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight_;
import ch.icit.pegasus.server.core.dtos.store.StoreArticleContentComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.DeletedStateE;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StockContentDetailsPanel
extends DefaultDetailsPanel<StoreLight>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private PageableTable2 table;
    private ComboBox mainCat;
    private ComboBox mainGroup;
    private ComboBox subCat;
    private ComboBox filterBonded;
    private ComboBox deleted;
    private ComboBox inUse;
    private TitledItem<PrintScreenButton> exportStoreContent;
    private TitledItem<PrintScreenButton> printArticleLabels;
    private UserComplete currentUser;
    private static final String FILTER_ARTICLE_NAME = "Article";
    private static final String FILTER_CUSTOMER = "Customer";
    private static final String FILTER_CHECKBOX = "Checkbox";
    private static final String FILTER_MAIN_CATEGORY = "MainCat";
    private static final String FILTER_MAIN_GROUP = "MainGroup";
    private static final String FILTER_SUB_CATEGORY = "SubCat";
    private static final String FILTER_BONDED = "Bonded";
    private static final String FILTER_DELETED = "Deleted";
    private static final String FILTER_IN_USE = "Inuse";
    private String fc1;
    private CustomerReference fc2;
    private ArticleCategoryReference fc3;
    private ArticleCategoryReference fc4;
    private ArticleCategoryReference fc5;
    private boolean isChargeEditable = true;
    private boolean fc6;
    private BondedStateE fc7 = BondedStateE.ALL;
    private DeletedStateE fc8 = DeletedStateE.ALL;
    private InUseStateE fc9 = InUseStateE.ALL;

    public StockContentDetailsPanel(RowEditor<StoreLight> editor, RDProvider provider, UserComplete currentUser) {
        super(editor, provider);
        final boolean isSolarCompany = Boolean.TRUE.equals(((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()).getCompany().getSolarCompanyType());
        this.currentUser = currentUser;
        this.isChargeEditable = provider.isWritable(StoreAccess.EDIT_CHARGE);
        this.setTitleText(Words.ARTICLES);
        this.table = new PageableTable2("", true, false, false){

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(StoreArticleContentSearchAlgorithm.class);
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                return StockContentDetailsPanel.this.filterChainValueChanged(id, value);
            }

            @Override
            public void fillFilterChain() {
                this.filterChain.addSeachField(StockContentDetailsPanel.FILTER_ARTICLE_NAME, Words.ARTICLE);
                if (!isSolarCompany) {
                    this.filterChain.addCustomerSearchField(StockContentDetailsPanel.FILTER_CUSTOMER);
                    this.filterChain.addCheckBox(StockContentDetailsPanel.FILTER_CHECKBOX, Words.CUSTOMER_NO, false);
                }
                StockContentDetailsPanel.this.mainCat = new ComboBox(null, null, ConverterRegistry.getConverter(ArticleCategoryConverter2.class));
                StockContentDetailsPanel.this.mainCat.addItem(Words.ALL);
                StockContentDetailsPanel.this.mainGroup = new ComboBox(null, null, ConverterRegistry.getConverter(ArticleCategoryConverter2.class));
                StockContentDetailsPanel.this.mainGroup.addItem(Words.ALL);
                StockContentDetailsPanel.this.subCat = new ComboBox(null, null, ConverterRegistry.getConverter(ArticleCategoryConverter2.class));
                StockContentDetailsPanel.this.subCat.addItem(Words.ALL);
                StockContentDetailsPanel.this.deleted = new ComboBox();
                StockContentDetailsPanel.this.deleted.addItem(DeletedStateE.ALL);
                StockContentDetailsPanel.this.deleted.addItem(DeletedStateE.NOT_DELETED);
                StockContentDetailsPanel.this.deleted.addItem(DeletedStateE.ONLY_DELETED);
                StockContentDetailsPanel.this.inUse = new ComboBox();
                StockContentDetailsPanel.this.inUse.addItem(InUseStateE.ALL);
                StockContentDetailsPanel.this.inUse.addItem(InUseStateE.NOT_USED);
                StockContentDetailsPanel.this.inUse.addItem(InUseStateE.ONLY_USED);
                if (!isSolarCompany) {
                    StockContentDetailsPanel.this.filterBonded = new ComboBox(null, NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class));
                }
                this.filterChain.addSelectionCombo(StockContentDetailsPanel.FILTER_MAIN_CATEGORY, Words.CATEGORY, StockContentDetailsPanel.this.mainCat);
                this.filterChain.addSelectionCombo(StockContentDetailsPanel.FILTER_MAIN_GROUP, Words.MAIN_GROUP, StockContentDetailsPanel.this.mainGroup);
                this.filterChain.addSelectionCombo(StockContentDetailsPanel.FILTER_SUB_CATEGORY, Words.SUB_GROUP, StockContentDetailsPanel.this.subCat);
                if (!isSolarCompany) {
                    this.filterChain.addSelectionCombo(StockContentDetailsPanel.FILTER_BONDED, Words.BONDED, StockContentDetailsPanel.this.filterBonded);
                }
                this.filterChain.addSelectionCombo(StockContentDetailsPanel.FILTER_DELETED, Words.DELETED, StockContentDetailsPanel.this.deleted);
                this.filterChain.addSelectionCombo(StockContentDetailsPanel.FILTER_IN_USE, Words.IN_USE, StockContentDetailsPanel.this.inUse);
                StockContentDetailsPanel.this.mainCat.addItemListener(StockContentDetailsPanel.this);
                StockContentDetailsPanel.this.mainGroup.addItemListener(StockContentDetailsPanel.this);
                StockContentDetailsPanel.this.subCat.addItemListener(StockContentDetailsPanel.this);
                StockContentDetailsPanel.this.exportStoreContent = new TitledItem<PrintScreenButton>(new PrintScreenButton(), Words.EXPORT, TitledItem.TitledItemOrientation.WEST);
                ((PrintScreenButton)StockContentDetailsPanel.this.exportStoreContent.getElement()).addButtonListener(StockContentDetailsPanel.this);
                StockContentDetailsPanel.this.printArticleLabels = new TitledItem<PrintScreenButton>(new PrintScreenButton(), Words.PRINT_LABELS, TitledItem.TitledItemOrientation.WEST);
                ((PrintScreenButton)StockContentDetailsPanel.this.printArticleLabels.getElement()).addButtonListener(StockContentDetailsPanel.this);
                this.filterChain.addSpecialComponent(StockContentDetailsPanel.this.exportStoreContent);
                this.filterChain.addSpecialComponent(StockContentDetailsPanel.this.printArticleLabels);
            }
        };
        ArrayList<TableColumnInfo> headers = new ArrayList<TableColumnInfo>();
        int expWidth = ExpandIcon.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        headers.add(new TableColumnInfo(0.0, 0.0, "", null, null, null, "", expWidth += 2 * this.table.getCellPadding(), expWidth, expWidth));
        headers.add(new TableColumnInfo(1.0, 0.0, Words.ARTICLE, null, null, (Enum<?>)ABasicArticleSearchConfiguration.BASIC_ARTICLE_COLUMN.NUMBER, "", 70, 70, 70));
        expWidth = QuantityRenderer.getPreferredSize(this) + 100 + 2 * this.table.getCellPadding() + this.table.getInnerCellPadding() + InfoButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        headers.add(new TableColumnInfo(0.0, 0.0, Words.IN_STOCK, null, null, null, "", expWidth, expWidth, expWidth));
        expWidth = DateRenderer.getPreferredWidth(this) + this.table.getCellPadding() * 2;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.EXPIRY, null, null, null, "", expWidth, expWidth, expWidth));
        expWidth = QuantityRenderer.getPreferredSize(this) + 4 * this.table.getCellPadding();
        headers.add(new TableColumnInfo(0.0, 0.0, Words.DAY_PRICE, null, null, null, "", expWidth, expWidth, expWidth));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.VALUE, null, null, null, "", 150, 150, 150));
        expWidth = DateRenderer.getPreferredWidth(this) + this.table.getCellPadding() * 2;
        headers.add(new TableColumnInfo(0.0, 0.0, Words.LAST_INVENTORY, null, null, null, "", expWidth, expWidth, expWidth));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.IN_USE, null, null, null, "", 45, 45, 45));
        headers.add(new TableColumnInfo(0.0, 0.0, Words.DELETED, null, null, null, "", 45, 45, 45));
        this.table.setModel(new Table2Model(headers, model -> {
            if (model.getNode().getValue() instanceof StoreArticleContentComplete) {
                return new TableRowImplParent(model);
            }
            return new TableRowImplChild(model);
        }));
        this.table.setProgress(1.0f);
        this.table.initSortedColumn(1, true);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.exportStoreContent.getElement()) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.exportStoreContent, true, true, Words.EXPORT_STOCK);
            popUp.setView(new StockExportPopup(this.editor.getModel().getNode(), this.currentUser, this));
            popUp.showPopUp(x, y, -1, -1, null, this.exportStoreContent);
        } else if (source == this.printArticleLabels.getElement()) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            popUp.setAttributes(this.printArticleLabels, true, true, Words.PRINT_ARTICLE_LABELS);
            popUp.setView(new ArticleLabelsPopup(this.editor.getModel().getNode(), this.currentUser, this));
            popUp.showPopUp(x, y, 250, 600, null, this.exportStoreContent);
        }
    }

    public StoreArticleContentSearchConfiguration getSearchConfig(boolean filtered) {
        return this.filterChainValueChanged(null, null);
    }

    public StoreArticleContentSearchConfiguration filterChainValueChanged(String id, Object value) {
        if (id != null) {
            if (FILTER_ARTICLE_NAME.equals(id)) {
                this.fc1 = (String)value;
            } else if (FILTER_CUSTOMER.equals(id)) {
                this.fc2 = value instanceof Node ? (CustomerReference)((Node)value).getValue() : (value instanceof CustomerLight ? (CustomerReference)value : null);
            } else if (FILTER_MAIN_CATEGORY.equals(id)) {
                if (value instanceof Node) {
                    this.fc3 = (ArticleCategoryReference)((Node)value).getValue();
                } else {
                    this.fc3 = null;
                    this.fc4 = null;
                    this.fc5 = null;
                }
            } else if (FILTER_MAIN_GROUP.equals(id)) {
                if (value instanceof Node) {
                    this.fc4 = (ArticleCategoryReference)((Node)value).getValue();
                } else {
                    this.fc4 = null;
                    this.fc5 = null;
                }
            } else if (FILTER_SUB_CATEGORY.equals(id)) {
                this.fc5 = value instanceof Node ? (ArticleCategoryReference)((Node)value).getValue() : null;
            } else if (FILTER_CHECKBOX.equals(id)) {
                if (value instanceof Boolean) {
                    this.fc6 = (Boolean)value;
                }
            } else if (FILTER_BONDED.equals(id)) {
                if (value instanceof BondedStateE) {
                    this.fc7 = (BondedStateE)value;
                } else if (value instanceof Node && ((Node)value).getValue() instanceof BondedStateE) {
                    this.fc7 = (BondedStateE)((Node)value).getValue();
                }
            } else if (FILTER_DELETED.equals(id)) {
                if (value instanceof DeletedStateE) {
                    this.fc8 = (DeletedStateE)value;
                }
            } else if (FILTER_IN_USE.equals(id) && value instanceof InUseStateE) {
                this.fc9 = (InUseStateE)value;
            }
        }
        if (this.fc1 != null && this.fc1.trim().isEmpty()) {
            this.fc1 = null;
        }
        StoreArticleContentSearchConfiguration c = new StoreArticleContentSearchConfiguration();
        c.setNumResults(30);
        if (this.fc6) {
            c.setCustomerArticleNo(this.fc1);
            c.setName(null);
            c.setNumber(null);
        } else {
            try {
                int i = Integer.valueOf(this.fc1);
                c.setNumber(Integer.valueOf(i));
                c.setName(this.fc1);
            }
            catch (NumberFormatException e) {
                c.setName(this.fc1);
            }
            c.setCustomerArticleNo(null);
        }
        c.setStore((StoreReference)this.editor.getModel().getNode().getValue());
        c.setCustomer(this.fc2);
        c.setAttribute3Category(this.fc3);
        c.setTemperatureCategory(this.fc4);
        c.setOwnershipCategory(this.fc5);
        if (this.fc7 != null) {
            switch (this.fc7) {
                case ALL: {
                    c.setBondedOnly(null);
                    break;
                }
                case NOT_BONDED: {
                    c.setBondedOnly(Boolean.valueOf(false));
                    break;
                }
                case ONLY_BONDED: {
                    c.setBondedOnly(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setBondedOnly(null);
                }
            }
        }
        if (this.fc8 != null) {
            switch (this.fc8) {
                case ALL: {
                    c.setIsDeleted(null);
                    break;
                }
                case NOT_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(false));
                    break;
                }
                case ONLY_DELETED: {
                    c.setIsDeleted(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setIsDeleted(null);
                }
            }
        }
        if (this.fc9 != null) {
            switch (this.fc9) {
                case ALL: {
                    c.setInUse(null);
                    break;
                }
                case NOT_USED: {
                    c.setInUse(Boolean.valueOf(false));
                    break;
                }
                case ONLY_USED: {
                    c.setInUse(Boolean.valueOf(true));
                    break;
                }
                default: {
                    c.setInUse(null);
                }
            }
        }
        c.setSortColumn((Enum)((ABasicArticleSearchConfiguration.BASIC_ARTICLE_COLUMN)this.table.getSortedColumn()));
        return c;
    }

    @Override
    public void setNode(Node<?> node) {
        this.table.getModel().setNode((Node)new ViewNode(""));
        this.table.invokeDefaultSearch();
        this.mainCat.refreshPossibleValues(NodeToolkit.getAffixList(ArticleCategoryComplete.class));
        this.mainCat.addItem(Words.ALL);
        this.mainCat.setSelectedItem(Words.ALL);
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.table.getFilterChain().isBlind()) {
            return;
        }
        this.table.getFilterChain().setBlind(true);
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.mainCat) {
                if (this.mainCat.getSelectedItem() instanceof Node) {
                    this.mainGroup.refreshPossibleValues(((Node)this.mainCat.getSelectedItem()).getChildNamed(ArticleCategoryComplete_.subCategories));
                    this.mainGroup.addItem(Words.ALL);
                    this.mainGroup.setSelectedItem(Words.ALL);
                } else {
                    this.mainGroup.removeAllItems();
                    this.mainGroup.addItem(Words.ALL);
                }
                this.subCat.removeAllItems();
                this.subCat.addItem(Words.ALL);
            } else if (e.getSource() == this.mainGroup) {
                if (this.mainGroup.getSelectedItem() instanceof Node) {
                    this.subCat.refreshPossibleValues(((Node)this.mainGroup.getSelectedItem()).getChildNamed(ArticleCategoryComplete_.subCategories));
                    this.subCat.addItem(Words.ALL);
                    this.subCat.setSelectedItem(Words.ALL);
                } else {
                    this.subCat.removeAllItems();
                    this.subCat.addItem(Words.ALL);
                }
            }
        }
        this.table.getFilterChain().setBlind(false);
    }

    private class TableRowImplChild
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel chargeC;
        private QuantityRenderer inStockC;
        private TextLabel expiryC;
        private TextLabel dayPriceC;
        private EditButton editCharge;
        private TextLabel valueC;
        private TextLabel lastInventoryC;
        private InfoButton infoButton;
        private final BasicArticleComplete artC;
        private final Timestamp validity;

        public TableRowImplChild(Table2RowModel m) {
            super(m);
            Node charge = m.getNode().getChildNamed(ArticleChargeBatchComplete_.charge);
            this.chargeC = CompanyUtil.isNoPro((SystemSettingsComplete)StockContentDetailsPanel.this.settings) ? new TextLabel(m.getNode(), ConverterRegistry.getConverter(BatchPositionRemoteConverter.class)) : new TextLabel(m.getNode(), ConverterRegistry.getConverter(BatchPositionConverter.class));
            this.artC = (BasicArticleComplete)charge.getChildNamed(ArticleChargeComplete_.basicArticle).getValue(BasicArticleComplete.class);
            this.validity = ((ArticleChargeComplete)charge.getValue(ArticleChargeComplete.class)).getCreationDate();
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            ArticleChargeBatchComplete batch = (ArticleChargeBatchComplete)m.getNode().getValue();
            QuantityComplete nq = UnitConversionToolkit.getOptimalStoreQuantity((ArticleChargeBatchComplete)batch, (SystemSettingsComplete)s, (BasicArticleComplete)this.artC);
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nq, false, false);
            this.inStockC = new QuantityRenderer((Node<?>)n);
            this.expiryC = new TextLabel(charge.getChildNamed(ArticleChargeComplete_.expiryDate), ConverterRegistry.getConverter(DateConverter.class));
            this.dayPriceC = new TextLabel(charge.getChildNamed(ArticleChargeComplete_.price), ConverterRegistry.getConverter(PricePerUnitConverter.class));
            if (StockContentDetailsPanel.this.isChargeEditable) {
                this.editCharge = new EditButton();
                this.editCharge.addButtonListener(this);
            }
            this.valueC = new TextLabel(this.createValueView(m.getNode(), charge), ConverterRegistry.getConverter(PriceConverter1.class));
            this.lastInventoryC = new TextLabel(m.getNode().getChildNamed(ArticleChargeBatchComplete_.lastInventory), ConverterRegistry.getConverter(DateConverter.class));
            this.infoButton = new InfoButton();
            String t = TransactionToolkit.getArticleChargeBatchInfo((ArticleChargeBatchComplete)m.getNode().getValue());
            this.infoButton.installStringViewer(t);
            this.setLayout(new TRICLayout());
            this.add(this.chargeC);
            this.add(this.infoButton);
            this.add(this.inStockC);
            this.add(this.expiryC);
            this.add(this.dayPriceC);
            if (StockContentDetailsPanel.this.isChargeEditable) {
                this.add(this.editCharge);
            }
            this.add(this.valueC);
            this.add(this.lastInventoryC);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.chargeC != null) {
                this.chargeC.kill();
            }
            this.chargeC = null;
            if (this.inStockC != null) {
                this.inStockC.kill();
            }
            this.inStockC = null;
            if (this.expiryC != null) {
                this.expiryC.kill();
            }
            this.expiryC = null;
            if (this.infoButton != null) {
                this.infoButton.kill();
            }
            this.infoButton = null;
            if (this.dayPriceC != null) {
                this.dayPriceC.kill();
            }
            this.dayPriceC = null;
            if (StockContentDetailsPanel.this.isChargeEditable && this.editCharge != null) {
                this.editCharge.kill();
            }
            this.editCharge = null;
            if (this.valueC != null) {
                this.valueC.kill();
            }
            this.valueC = null;
            if (this.lastInventoryC != null) {
                this.lastInventoryC.kill();
            }
            this.lastInventoryC = null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private Node<?> createValueView(Node<?> batch, Node charge) {
            ViewNode price = new ViewNode("Value");
            PriceComplete np = null;
            Node quant = batch.getChildNamed(ArticleChargeBatchComplete_.quantity);
            double amount = 0.0;
            UnitComplete unit = null;
            if (quant.getValue() instanceof StoreQuantityComplete) {
                amount = ((StoreQuantityComplete)quant.getValue()).getAmount().longValue();
                unit = ((StoreQuantityComplete)quant.getValue()).getUnit();
            }
            if (quant.getValue() instanceof QuantityComplete) {
                amount = ((QuantityComplete)quant.getValue()).getAmount();
                unit = ((QuantityComplete)quant.getValue()).getUnit();
            }
            Node acharge = batch.getChildNamed(ArticleChargeBatchComplete_.charge);
            List packagingQuantities = (List)acharge.getChildNamed(ArticleChargeComplete_.packingQuantities).getValue();
            Node article = acharge.getChildNamed(ArticleChargeComplete_.basicArticle);
            Node priceDto = acharge.getChildNamed(ArticleChargeComplete_.price);
            Node priceUnit = acharge.getChildNamed(ArticleChargeComplete_.priceUnit);
            double a = UnitConversionToolkit.convertUnit((UnitComplete)unit, (UnitComplete)((UnitComplete)priceUnit.getValue()), (double)amount, (BasicArticleLight)((BasicArticleLight)article.getValue(BasicArticleComplete.class)), (List)packagingQuantities);
            double b = a * ((PriceComplete)priceDto.getValue()).getPrice();
            if (np == null) {
                np = new PriceComplete(((PriceComplete)priceDto.getValue()).getCurrency(), Double.valueOf(0.0));
            }
            np.setPrice(Double.valueOf(np.getPrice() + b));
            price.setValue((Object)np, 0L);
            return price;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.infoButton.setEnabled(isEnabled);
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.editCharge) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.editCharge, true, true, Words.EDIT_CHARGE);
                popUp.setView(new EditChargePriceUnitExpiryPopup(this.model.getNode()));
                popUp.showPopUp(x, y, 250, 260, new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs == null) {
                            return;
                        }
                        TableRowImplChild.this.dayPriceC.getNode().getChildNamed(PriceComplete_.price).setValue(((Node)xargs[0]).getValue(), 0L);
                        TableRowImplChild.this.dayPriceC.getNode().getChildNamed(PriceComplete_.currency).setValue(((Node)xargs[1]).getValue(), 0L);
                        TableRowImplChild.this.dayPriceC.getNode().getParent().getChildNamed(ArticleChargeComplete_.priceUnit).setValue(xargs[3], 0L);
                        TableRowImplChild.this.dayPriceC.getNode().commit();
                        TableRowImplChild.this.dayPriceC.setLeftUpperCornerPainting(true, AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("productionplanner_stocksetted_color")));
                        TableRowImplChild.this.dayPriceC.updateString();
                    }
                }, this.editCharge);
            }
        }

        private class TRICLayout
        extends DefaultLayout {
            private TRICLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w;
                int currentX = w = TableRowImplChild.this.model.getParentModel().getColumnWidth(0);
                w = TableRowImplChild.this.model.getParentModel().getColumnWidth(1);
                TableRowImplChild.this.chargeC.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.chargeC.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.chargeC.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplChild.this.chargeC.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplChild.this.model.getParentModel().getColumnWidth(2);
                TableRowImplChild.this.inStockC.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.inStockC.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.inStockC.setSize((int)((double)w - ((double)(2 * StockContentDetailsPanel.this.table.getCellPadding() + StockContentDetailsPanel.this.inner_horizontalBorder) + TableRowImplChild.this.infoButton.getPreferredSize().getWidth())), (int)TableRowImplChild.this.inStockC.getPreferredSize().getHeight());
                TableRowImplChild.this.infoButton.setLocation(TableRowImplChild.this.inStockC.getX() + TableRowImplChild.this.inStockC.getWidth() + TableRowImplChild.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.infoButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.infoButton.setSize(TableRowImplChild.this.infoButton.getPreferredSize());
                currentX += w;
                w = TableRowImplChild.this.model.getParentModel().getColumnWidth(3);
                TableRowImplChild.this.expiryC.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.expiryC.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.expiryC.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplChild.this.expiryC.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplChild.this.model.getParentModel().getColumnWidth(4);
                int ab = 0;
                if (StockContentDetailsPanel.this.isChargeEditable) {
                    ab = (int)((double)ab + ((double)TableRowImplChild.this.getInnerCellPadding() + TableRowImplChild.this.editCharge.getPreferredSize().getWidth()));
                }
                TableRowImplChild.this.dayPriceC.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.dayPriceC.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.dayPriceC.setSize(w - (2 * StockContentDetailsPanel.this.table.getCellPadding() + ab), (int)TableRowImplChild.this.dayPriceC.getPreferredSize().getHeight());
                if (StockContentDetailsPanel.this.isChargeEditable) {
                    TableRowImplChild.this.editCharge.setLocation(TableRowImplChild.this.dayPriceC.getX() + TableRowImplChild.this.dayPriceC.getWidth() + TableRowImplChild.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.editCharge.getPreferredSize().getHeight()) / 2.0));
                    TableRowImplChild.this.editCharge.setSize(TableRowImplChild.this.editCharge.getPreferredSize());
                }
                currentX += w;
                w = TableRowImplChild.this.model.getParentModel().getColumnWidth(5);
                TableRowImplChild.this.valueC.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.valueC.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.valueC.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplChild.this.valueC.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplChild.this.model.getParentModel().getColumnWidth(6);
                TableRowImplChild.this.lastInventoryC.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImplChild.this.lastInventoryC.getPreferredSize().getHeight()) / 2.0));
                TableRowImplChild.this.lastInventoryC.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplChild.this.lastInventoryC.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplChild.this.getDefaultRowHeight());
            }
        }
    }

    private class TableRowImplParent
    extends Table2RowPanel
    implements NodeListener,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private ExpandIcon expand;
        private TextLabel article;
        private QuantityRenderer inStock;
        private TextLabel expiry;
        private TextLabel dayPrice;
        private TextLabel value;
        private TextLabel lastInventory;
        private CellViewBooleanRenderer inUseCol;
        private CellViewBooleanRenderer deletedCol;
        private BasicArticleComplete artC;
        private Timestamp validity;

        public TableRowImplParent(Table2RowModel m) {
            super(m);
            this.artC = null;
            if (m.getNode().getChildNamed(DtoFieldConstants.batches).getChildCount() > 0) {
                Node batch = m.getNode().getChildNamed(DtoFieldConstants.batches).getChildAt(0);
                Node charge = batch.getChildNamed(ArticleChargeBatchComplete_.charge);
                this.validity = ((ArticleChargeComplete)charge.getValue(ArticleChargeComplete.class)).getCreationDate();
                this.artC = (BasicArticleComplete)charge.getChildNamed(ArticleChargeLight_.basicArticle).getValue(BasicArticleComplete.class);
            } else {
                this.validity = new Timestamp(System.currentTimeMillis());
                this.artC = (BasicArticleComplete)m.getNode().getChildNamed(DtoFieldConstants.article).getValue(BasicArticleComplete.class);
            }
            this.setLayoutInnerChildsSelf(true);
            this.setExpanded(false, true);
            this.setLayout(new TRIPLayout());
            this.expand = new ExpandIcon();
            this.expand.addButtonListener(this);
            this.article = new TextLabel(m.getNode().getChildNamed(DtoFieldConstants.article), ConverterRegistry.getConverter(BasicArticleConverter.class));
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            StoreArticleContentComplete articleContent = (StoreArticleContentComplete)m.getNode().getValue();
            QuantityComplete nq = UnitConversionToolkit.getTotalQuantityInStoreUnit((StoreArticleContentComplete)articleContent);
            Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)nq, false, false);
            this.inStock = new QuantityRenderer((Node<?>)n);
            this.inStock.setViewConverter(ConverterRegistry.getConverter(QuantityConverter0Decimal.class));
            this.expiry = new TextLabel(this.createExpiryView(m.getNode().getChildNamed(DtoFieldConstants.batches)), ConverterRegistry.getConverter(DateConverter.class));
            this.dayPrice = new TextLabel(this.createDayPriceView(m.getNode().getChildNamed(DtoFieldConstants.batches)), ConverterRegistry.getConverter(PricePerUnit2Converter.class));
            this.lastInventory = new TextLabel(this.getLastInventory(), ConverterRegistry.getConverter(DateConverter.class));
            this.value = new TextLabel(this.createValueView(m.getNode(), m.getNode().getChildNamed(DtoFieldConstants.batches).getChildAt(0).getChildNamed(ArticleChargeBatchComplete_.charge)), ConverterRegistry.getConverter(PriceConverter1.class));
            this.inUseCol = new CellViewBooleanRenderer((Boolean)m.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.article, BasicArticleLight_.isInUse}).getValue(), false);
            this.inUseCol.setToolTipText(((InUseBooleanConverter)ConverterRegistry.getConverter(InUseBooleanConverter.class)).convert((Boolean)m.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.article, BasicArticleLight_.isInUse}).getValue(), null, new Object[0]));
            this.deletedCol = new CellViewBooleanRenderer((Boolean)m.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.article, BasicArticleLight_.isDeleted}).getValue() == false, false);
            this.deletedCol.setToolTipText(((DeletedBooleanConverter)ConverterRegistry.getConverter(DeletedBooleanConverter.class)).convert((Boolean)m.getNode().getChildNamed(new DtoField[]{DtoFieldConstants.article, BasicArticleLight_.isDeleted}).getValue(), null, new Object[0]));
            m.getNode().getChildNamed(DtoFieldConstants.batches).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(DtoFieldConstants.batches).getAllChildAddEventsFor((NodeListener)this, new String[0]);
            this.article.setProgress(1.0f);
            this.inStock.setProgress(1.0f);
            this.expiry.setProgress(1.0f);
            this.dayPrice.setProgress(1.0f);
            this.value.setProgress(1.0f);
            this.lastInventory.setProgress(1.0f);
            this.add(this.expand);
            this.add(this.article);
            this.add(this.inStock);
            this.add(this.expiry);
            this.add(this.dayPrice);
            this.add(this.value);
            this.add(this.lastInventory);
            this.add(this.inUseCol);
            this.add(this.deletedCol);
        }

        private Node getLastInventory() {
            Node ii = null;
            Iterator it = this.model.getNode().getChildNamed(DtoFieldConstants.batches).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                Node i = n.getChildNamed(ArticleChargeBatchComplete_.lastInventory);
                if (ii == null) {
                    ii = i;
                    continue;
                }
                if (ii.getValue() == null) {
                    ii = i;
                    continue;
                }
                if (i.getValue() == null) continue;
                Timestamp i1 = (Timestamp)ii.getValue();
                Timestamp i2 = (Timestamp)i.getValue();
                if (i2.getTime() <= i1.getTime()) continue;
                ii = i;
            }
            return ii;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.expand.kill();
            this.expand = null;
            this.article.kill();
            this.article = null;
            this.inStock.kill();
            this.inStock = null;
            this.expiry.kill();
            this.expiry = null;
            this.dayPrice.kill();
            this.dayPrice = null;
            this.value.kill();
            this.value = null;
            this.lastInventory.kill();
            this.lastInventory = null;
            this.inUseCol.kill();
            this.inUseCol = null;
            this.deletedCol.kill();
            this.deletedCol = null;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private Node<?> createExpiryView(Node<?> chargesList) {
            Node exp = null;
            Iterator it = chargesList.getChilds();
            while (it.hasNext()) {
                Node batch = (Node)it.next();
                Node c = batch.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.expiryDate});
                if (exp == null) {
                    exp = c;
                    continue;
                }
                if (exp.getValue() == null) {
                    exp = c;
                    continue;
                }
                Date d1 = (Date)exp.getValue();
                Date d2 = (Date)c.getValue();
                if (d1 == null || d2 == null) {
                    exp = c;
                    continue;
                }
                if (d1.getTime() >= d2.getTime()) continue;
                exp = c;
            }
            return exp;
        }

        private Node<?> createDayPriceView(Node<?> chargesList) {
            PriceComplete q = new PriceComplete();
            double totalAmount = 0.0;
            double totalPrice = 0.0;
            Iterator it = chargesList.getChilds();
            while (it.hasNext()) {
                QuantityComplete qty;
                StoreQuantityComplete s;
                Node batch = (Node)it.next();
                PriceComplete cp = (PriceComplete)batch.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.price}).getValue();
                Node quantity = batch.getChildNamed(ArticleChargeBatchComplete_.quantity);
                if (quantity.getValue() instanceof StoreQuantityComplete) {
                    s = (StoreQuantityComplete)quantity.getValue();
                    qty = new QuantityComplete(s);
                } else {
                    s = (QuantityComplete)quantity.getValue();
                    qty = new QuantityComplete((QuantityComplete)s);
                }
                double a = UnitConversionToolkit.convertUnit((UnitComplete)qty.getUnit(), (UnitComplete)this.artC.getPriceUnit(), (double)qty.getAmount(), (BasicArticleLight)this.artC, (Timestamp)this.validity);
                totalAmount += a;
                double p = UnitConversionToolkit.convertUnit((UnitComplete)((UnitComplete)batch.getChildNamed(new DtoField[]{ArticleChargeBatchComplete_.charge, ArticleChargeComplete_.priceUnit}).getValue()), (UnitComplete)this.artC.getPriceUnit(), (double)cp.getPrice(), (BasicArticleLight)this.artC, (Timestamp)this.validity);
                totalPrice += a * p;
                if (q.getCurrency() != null) continue;
                q.setCurrency(cp.getCurrency());
            }
            double amount = 0.0;
            if (totalAmount > 0.0) {
                amount = totalPrice / totalAmount;
            }
            q.setPrice(Double.valueOf(amount));
            return INodeCreator.getDefaultImpl().getNode4DTO((Object)q, false, false);
        }

        private Node<?> createValueView(Node node, Node charge) {
            ViewNode price = new ViewNode("Value");
            PriceComplete np = null;
            Iterator it = node.getChildNamed(DtoFieldConstants.batches).getChilds();
            while (it.hasNext()) {
                QuantityComplete qty;
                StoreQuantityComplete s;
                Node batch = (Node)it.next();
                Node quant = batch.getChildNamed(ArticleChargeBatchComplete_.quantity);
                if (quant.getValue() instanceof StoreQuantityComplete) {
                    s = (StoreQuantityComplete)quant.getValue();
                    qty = new QuantityComplete(s);
                } else {
                    s = (QuantityComplete)quant.getValue();
                    qty = new QuantityComplete((QuantityComplete)s);
                }
                Node acharge = batch.getChildNamed(ArticleChargeBatchComplete_.charge);
                List packagingQuantities = (List)acharge.getChildNamed(ArticleChargeComplete_.packingQuantities).getValue();
                Node article = acharge.getChildNamed(ArticleChargeComplete_.basicArticle);
                Node priceDto = acharge.getChildNamed(ArticleChargeComplete_.price);
                Node priceUnit = acharge.getChildNamed(ArticleChargeComplete_.priceUnit);
                double a = UnitConversionToolkit.convertUnit((UnitComplete)qty.getUnit(), (UnitComplete)((UnitComplete)priceUnit.getValue()), (double)qty.getAmount(), (BasicArticleLight)((BasicArticleLight)article.getValue(BasicArticleComplete.class)), (List)packagingQuantities);
                double b = a * ((PriceComplete)priceDto.getValue()).getPrice();
                if (np == null) {
                    np = new PriceComplete(((PriceComplete)priceDto.getValue()).getCurrency(), Double.valueOf(0.0));
                }
                np.setPrice(Double.valueOf(np.getPrice() + b));
            }
            price.setValue(np, 0L);
            return price;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.expand.setEnabled(isEnabled);
            this.article.setEnabled(isEnabled);
            this.inStock.setEnabled(isEnabled);
            this.expiry.setEnabled(isEnabled);
            this.dayPrice.setEnabled(isEnabled);
            this.value.setEnabled(isEnabled);
            this.lastInventory.setEnabled(isEnabled);
            this.inUseCol.setEnabled(isEnabled);
            this.deletedCol.setEnabled(isEnabled);
        }

        public void childAdded(Node<?> source, Node<?> child) {
            if (source.getName().equals(ArticleChargeComplete_.batches.getFieldName())) {
                this.addRow(child);
            }
        }

        public void childRemoved(Node<?> source, Node<?> child) {
            Table2RowPanel p = this.getChild4Node(child);
            if (p != null) {
                this.removeRow(p);
            }
        }

        public void valueChanged(Node<?> node) {
        }

        @Override
        public List<Component> getFocusComponents() {
            return null;
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.expand) {
                this.setExpanded(!this.isExpanded(), true);
                StockContentDetailsPanel.this.editor.validate();
            }
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class TRIPLayout
        extends DefaultLayout {
            private TRIPLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImplParent.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImplParent.this.expand.setLocation(StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.expand.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.expand.setSize(TableRowImplParent.this.expand.getPreferredSize());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(1);
                TableRowImplParent.this.article.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.article.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(2);
                TableRowImplParent.this.inStock.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.inStock.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.inStock.setSize((int)TableRowImplParent.this.inStock.getPreferredSize().getWidth(), (int)TableRowImplParent.this.inStock.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(3);
                TableRowImplParent.this.expiry.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.expiry.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.expiry.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.expiry.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(4);
                TableRowImplParent.this.dayPrice.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.dayPrice.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.dayPrice.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.dayPrice.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(5);
                TableRowImplParent.this.value.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.value.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.value.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.value.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(6);
                TableRowImplParent.this.lastInventory.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.lastInventory.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.lastInventory.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.lastInventory.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(7);
                TableRowImplParent.this.inUseCol.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.inUseCol.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.inUseCol.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.inUseCol.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImplParent.this.model.getParentModel().getColumnWidth(8);
                TableRowImplParent.this.deletedCol.setLocation(currentX + StockContentDetailsPanel.this.table.getCellPadding(), (int)(((double)TableRowImplParent.this.getDefaultRowHeight() - TableRowImplParent.this.deletedCol.getPreferredSize().getHeight()) / 2.0));
                TableRowImplParent.this.deletedCol.setSize(w - 2 * StockContentDetailsPanel.this.table.getCellPadding(), (int)TableRowImplParent.this.deletedCol.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImplParent.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            StockContentDetailsPanel.this.table.setLocation(0, 0);
            StockContentDetailsPanel.this.table.setSize(parent.getWidth() - 0, parent.getHeight() - 0);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 350);
        }
    }
}

