/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.overview;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.enums.DeleteStateE;
import ch.icit.pegasus.client.gui.hud.ConnectionToOutside;
import ch.icit.pegasus.client.gui.hud.smartscreen.RowSmartScreen;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.AnalysisSubModuleProvider;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.DtoSubModuleProvider;
import ch.icit.pegasus.client.gui.hud.submoduleprovider.RowSubModuleProvider;
import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.screentemplates.TitledScreenInsert;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableAddRow;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.toolbar.ScreenToolView;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.RowPanel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenTableRow;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.RowTransferObject;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChain;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainListener;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanel;
import ch.icit.pegasus.client.gui.utils.pagination.PaginationPanelListener;
import ch.icit.pegasus.client.gui.utils.panels.FrameIconBar;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.panels.ScreenMessagePanel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchfield.SearchTextField;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.DefaultServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.exception.SearchException;
import ch.icit.pegasus.server.core.dtos.masterdata.UserLight;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightsE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO;
import ch.icit.pegasus.server.core.dtos.system.ADeletableDTO_;
import ch.icit.pegasus.server.core.dtos.system.IDeletableDTO;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class ScreenTableView<T extends IUniversal, E extends Enum<E>>
extends TitledScreenInsert<T>
implements RowSubModuleProvider<T>,
DtoSubModuleProvider<T>,
AnalysisSubModuleProvider<T>,
AttributeListener,
FilterChainListener,
RemoteLoader,
ConnectionToOutside<T, E>,
PaginationPanelListener,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private Table<T, E> table;
    protected FilterChain filterChain;
    protected FrameIconBar otherTitleThing;
    protected PaginationPanel pagination;
    protected TextLabel subTitle;
    private Boolean deletedState;
    protected int titleIconsConfiguration = 6545;
    protected int vertical_gap_to_title;
    protected int vertical_gap_to_screenTitle;
    protected int vertical_gap_to_chain_Title;
    protected int vertical_gap_to_filterChain;
    protected int vertical_gap_to_tableTitle;
    protected ScreenToolView tools;
    private boolean firstLoadingDone;
    protected E currentColumnAttribute;
    protected boolean isAsc;
    protected static final String sortedColumnAttName = "sortedColumn";
    private ASearchConfiguration<T, E> lastSearch;
    protected boolean isSynchronSearch = false;
    protected int numberOfShownResults = 10;
    protected SearchResult<T> currentResult;
    private ScreenMessagePanel screenMessage;
    protected boolean isInstalled = false;
    protected long loadingId;
    protected boolean isLoadingData;
    protected boolean hasFilterChain;
    protected boolean isInit = false;
    protected boolean notYetLoaded = true;
    protected boolean dontSaveConfig;
    protected boolean errorIsShown;
    private static final String FILTER_DELETE = "delete_filter";
    private final Class<T> type;
    protected TableModel<T, E> tableModel;

    public ScreenTableView(Class<T> type) {
        this(type, true);
    }

    public ScreenTableView(Class<T> type, boolean withFilterChain) {
        this.type = type;
        this.isInit = true;
        this.firstLoadingDone = false;
        if (this.isPrintable()) {
            this.titleIconsConfiguration *= 13;
        }
        this.hasFilterChain = withFilterChain;
        this.loadingId = System.currentTimeMillis();
        this.numberOfShownResults = AttributesConverter.getInteger4String(ApplicationSettingsLoader.getLoader().getAttribute("number_of_shown_results"));
    }

    @Override
    public RDProvider getCurrentProvider() {
        RDProvider p = new RDProvider(this.getCurrentAccessRight(this.getInvoker()), false);
        return p;
    }

    @Override
    public String getOverriddenModuleRights() {
        return null;
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public abstract SearchAlgorithm<T> getSearchAlgorithm();

    public ASearchConfiguration<T, E> getSearchConfiguration() {
        return this.getSearchAlgorithm().getSearchConfiguration();
    }

    @Override
    public int getPageNumber() {
        int page = this.pagination.getCurrentPage() - 1;
        if (page < 0) {
            page = 0;
        }
        return page;
    }

    public ScreenTableAddRow<T> createNewAddRow(DefaultSkins clazz) {
        ScreenTableAddRow ar = new ScreenTableAddRow(WordsToolkit.toCapitalLetter((String)Words.ADD_NEW), (Skin1Field)clazz.createDynamicSkin());
        return ar;
    }

    public boolean hasAddAccess() {
        String name = this.getInvoker().getIdentifier();
        for (ModuleAccessRightComplete r : ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser().getModules()) {
            if (!r.getModule().getInvokingName().equals(name)) continue;
            for (DataAccessRightComplete rr : r.getAccessRights()) {
                if (rr.getDataAccessRight().getAccessRight() != DataRightsE.ADD) continue;
                return true;
            }
        }
        return false;
    }

    protected void installToolBar() {
        this.tools = new ScreenToolView(this);
        this.tools.setEnabled(this.isEnabled());
        this.add(this.tools);
    }

    @Override
    public ASearchConfiguration<T, ?> getFilteredSearchConfiguration() {
        return this.getSearchParameters(null, null, false, false, this.filterChain);
    }

    @Override
    public ASearchConfiguration<T, E> getEmptySearchConfiguration() {
        return this.getSearchConfiguration();
    }

    public void setSubTitle(TextLabel label) {
        this.subTitle = label;
        this.add(label);
    }

    @Override
    public RowTransferObject<T> getRowTransferObject() {
        if (this.table.getModel().getSelectedRow() == null) {
            return null;
        }
        return this.getRowAttributes(this.table.getModel().getSelectedRow());
    }

    public RowTransferObject<T> getRowAttributes(RowModel<T> model) {
        boolean mysticBoolean = true;
        RowTransferObject<T> o = new RowTransferObject<T>(model.getDTO(), new FakeSmartScreenTableRow<T>(model), model.getParentModel().getDataHandler(), mysticBoolean, model, this);
        return o;
    }

    @Override
    public TransferObject<T> getDtoTransferObject() {
        if (this.table.getModel().getSelectedRow() == null) {
            return null;
        }
        TransferObject<T> o = new TransferObject<T>(this.table.getModel().getSelectedRow().getDTO(), this);
        return o;
    }

    public T reloadDTO(T dto) throws ClientServerCallException {
        return dto;
    }

    public boolean isPrintable() {
        return true;
    }

    protected String getSortedColumnValue() {
        int i = this.table.getModel().getHeaderModel().getView().getSortedRow();
        TableColumnInfo info = this.table.getModel().getColumnInfo(i);
        if (info != null) {
            Enum<?> emo = this.table.getModel().getColumnInfo(i).getColumnAttribute();
            return emo.toString() + "<>" + this.table.getModel().getColumnInfo(i).isReversedSorting();
        }
        return null;
    }

    protected void updateSortedColumn(String tb) {
        String[] a = tb.split("<>");
        String t = a[0];
        boolean asc = false;
        try {
            asc = Boolean.valueOf(a[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TableColumnInfo info : this.table.getModel().getColumnInfos()) {
            if (info.getColumnAttribute() == null || !info.getColumnAttribute().toString().equals(t)) continue;
            this.table.getModel().getHeaderModel().getView().setTableSortAttribute(info.getColumnAttribute(), asc);
        }
    }

    public abstract FilterChainConfiguration getDefaultConfiguration();

    public void loadConfiguration() {
        this.isInit = true;
        if (this.filterChain != null) {
            FilterChainConfiguration c = FilterChainConfiguration.loadConfiguration(HUDToolkit.getInvokerNameForTopScreenClass(this.getClass().getName()), (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
            if (c == null) {
                c = this.getDefaultConfiguration();
            }
            if (c != null) {
                block8: for (String[] e : c.getProperties()) {
                    switch (e[0]) {
                        case "pageNumber": {
                            this.pagination.updateElement(e[0], e[1]);
                            continue block8;
                        }
                        case "sortedColumn": {
                            this.updateSortedColumn(e[1]);
                            continue block8;
                        }
                    }
                    this.filterChain.updateElement(e[0], e[1]);
                }
            }
        }
        this.notYetLoaded = false;
        this.isInit = false;
    }

    public FilterChainConfiguration getCurrentConfiguration() {
        FilterChainConfiguration f = this.filterChain.getCurrentConfiguration();
        f.addProperty("pageNumber", "" + this.pagination.getCurrentPage());
        String ss = this.getSortedColumnValue();
        if (ss != null) {
            f.addProperty(sortedColumnAttName, ss);
        }
        return f;
    }

    public void saveConfiguration() {
        if (this.filterChain == null) {
            return;
        }
        String t = HUDToolkit.getInvokerNameForTopScreenClass(this.getClass().getName());
        FilterChainConfiguration.saveConfiguration(t, (UserLight)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser(), this.getCurrentConfiguration(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getServerName(), ((DefaultServiceManager)ServiceManagerRegistry.getService(DefaultServiceManager.class)).getCustomerCode());
    }

    private void doSearch(final ASearchConfiguration<T, E> o, final Component source) {
        if (source instanceof SearchTextField) {
            ((SearchTextField)source).startAnimation();
        }
        this.setLoadData(true);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SearchResult res;
                ViewNode nn = ScreenTableView.this.getSearchAlgorithm().search(o);
                ScreenTableView.this.currentResult = res = (SearchResult)nn.getValue();
                if (!ScreenTableView.this.dontSaveConfig) {
                    ScreenTableView.this.saveConfiguration();
                }
                SwingUtilities.invokeLater(() -> {
                    if (ScreenTableView.this.pagination != null && res != null) {
                        ScreenTableView.this.pagination.setMinMaxPages(1, (int)((res.getNumberOfResults() != null ? res.getNumberOfResults() : 1L) / (long)(res.getPageSize() != null ? res.getPageSize() : 1)) + 1);
                        ScreenTableView.this.pagination.setCurrentPage((res.getPageNumber() != null ? res.getPageNumber() : 0) + 1);
                    }
                });
                return nn;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        if (ScreenTableView.this.getSearchAlgorithm() != null && ScreenTableView.this.table != null && ScreenTableView.this.table.getModel() != null) {
                            if (ScreenTableView.this.lastSearch != null) {
                                ASearchConfiguration x = ScreenTableView.this.lastSearch;
                                ScreenTableView.this.lastSearch = null;
                                ScreenTableView.this.doSearch(x, source);
                                return;
                            }
                            if (node != null && node.getValue() != null && node.getValue() instanceof SearchResult && ScreenTableView.this.table.getModel().getNode() != null) {
                                ScreenTableView.this.getSearchAlgorithm().mergeValues(ScreenTableView.this.table.getModel().getNode(), ((SearchResult)node.getValue()).getResults());
                            }
                            ScreenTableView.this.table.requestRelayout();
                            if (!ScreenTableView.this.firstLoadingDone) {
                                ScreenTableView.this.firstLoadingDone = true;
                                ScreenTableView.this.table.setLoadingData(true);
                                ScreenTableView.this.table.setStopItAnyWay();
                                ScreenTableView.this.table.allDownloaded();
                            }
                            if (source instanceof SearchTextField) {
                                ((SearchTextField)source).stopAnimation();
                            }
                            ScreenTableView.this.setLoadData(false);
                        }
                    }

                    public void errorOccurred(ClientException exception) {
                        if (!ScreenTableView.this.errorIsShown) {
                            ScreenTableView.this.errorIsShown = true;
                            InnerPopUp2 pop = InnerPopupFactory.showErrorDialog((Exception)exception, (Component)ScreenTableView.this);
                            pop.setListener(ScreenTableView.this);
                            if (source instanceof SearchTextField) {
                                ((SearchTextField)source).stopAnimation();
                            }
                            ScreenTableView.this.setLoadData(false);
                            if (ScreenTableView.this.isLoadingData && ScreenTableView.this.table != null) {
                                ScreenTableView.this.table.hideAnimation();
                            }
                        }
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        this.errorIsShown = false;
    }

    protected void showScreenMessage(String msg) {
        if (this.screenMessage == null) {
            this.screenMessage = new ScreenMessagePanel(msg);
        } else {
            this.screenMessage.setText(msg);
        }
        this.add((Component)this.screenMessage, 0);
        this.screenMessage.fadeIn();
        this.validate();
    }

    public void setTitleComponent(FrameIconBar com) {
        this.otherTitleThing = com;
        this.add(this.otherTitleThing);
        this.otherTitleThing.fadeIn();
    }

    public FrameIconBar getTitleComponent() {
        return this.otherTitleThing;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.table != null) {
            this.table.kill();
            this.table = null;
        }
        if (this.filterChain != null) {
            this.filterChain.kill();
            this.filterChain = null;
        }
        if (this.otherTitleThing != null) {
            this.otherTitleThing.kill();
            this.otherTitleThing = null;
        }
        if (this.screenMessage != null) {
            this.screenMessage.kill();
            this.screenMessage = null;
        }
        if (this.pagination != null) {
            this.pagination.kill();
            this.pagination = null;
        }
        if (this.subTitle != null) {
            this.subTitle.kill();
        }
        this.subTitle = null;
        if (this.tools != null) {
            this.tools.kill();
        }
        this.tools = null;
        this.currentColumnAttribute = null;
        this.lastSearch = null;
        this.currentResult = null;
        this.tableModel.kill();
        this.tableModel = null;
    }

    protected abstract Table.SmartIconConfiguration getPossibleSmartIcons();

    protected abstract RowEditorFactory<T> getRowEditorFactory();

    protected RowPanel<T> getNewAddRow() {
        return this.createNewAddRow(DefaultSkins.ModuleAddIcon);
    }

    protected abstract IDataHandler getModuleDataHandler();

    protected abstract List<TableColumnInfo> getTableColumnInfo();

    @Override
    public void setMainFrame(MainFrame mainFrame) {
        super.setMainFrame(mainFrame);
        if (!this.isInstalled) {
            this.isInstalled = true;
            this.table = new Table(this);
            RowFactory<T, E> rowFactory = this.getRowFactory();
            this.tableModel = this.getTableModel(rowFactory);
            this.setAdditionalConfiguration();
            this.table.setPossibleSmartIcons(this.getPossibleSmartIcons());
            this.table.setEnabled(false);
            this.addThings2Screen();
            this.setLoadingData(true);
            if (!(this instanceof RowSmartScreen)) {
                this.startDownload();
            }
        }
    }

    protected TableModel<T, E> getTableModel(RowFactory<T, E> rowFactory) {
        return new TableModel<T, E>(this.table, this, rowFactory, this.getModuleDataHandler(), this.hasAddAccess(), this.getTableColumnInfo());
    }

    protected RowFactory<T, E> getRowFactory() {
        return new RowFactory<T, E>(){

            @Override
            public RowPanel<T> getAddRow(RowModel<T> model) {
                RowPanel newAddRow = ScreenTableView.this.getNewAddRow();
                return newAddRow;
            }

            @Override
            public RowModel<T> getRowModel(TableModel<T, ?> tableModel, boolean isHeader, Node<T> node) {
                RowModel model = new RowModel(tableModel, isHeader, node);
                model.setExpandable(ScreenTableView.this.isRowExpandable(node));
                model.setRowEditorFactory(ScreenTableView.this.getRowEditorFactory());
                return model;
            }
        };
    }

    public boolean isRowExpandable(Node<T> node) {
        return true;
    }

    protected void setAdditionalConfiguration() {
    }

    protected void startDownload() {
        this.table.getModel().addRemoteLoaderListener(this);
        this.table.getModel().loadData();
    }

    protected abstract void createFilterChain(long var1);

    @Override
    public void filterValueChanged(Object name, Object value, boolean isReset, Component source) {
        if (this.getSearchAlgorithm() != null) {
            if (this.isSynchronSearch) {
                ASearchConfiguration<T, E> o = this.getSearchParameters(name, value, isReset, false, source);
                if (!this.isInit && !this.notYetLoaded) {
                    ViewNode nn = null;
                    ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
                    try {
                        nn = this.getSearchAlgorithm().search(o);
                    }
                    catch (SearchException e) {
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getEmbeddedException().getMessage()));
                    }
                    catch (ClientServerCallException e) {
                        rets.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()));
                    }
                    if (nn != null) {
                        List retVAlue = (List)nn.getValue();
                        this.getSearchAlgorithm().mergeValues(this.table.getModel().getNode(), retVAlue);
                    } else {
                        InnerPopupFactory.showErrorDialog(rets, "Enable to search", (Component)this);
                    }
                }
            } else {
                if (this.table == null || this.table.getModel() == null || this.table.getModel().getNode() == null) {
                    return;
                }
                ASearchConfiguration<T, E> o = this.getSearchParameters(name, value, isReset, false, source);
                if (!this.isInit && !this.notYetLoaded) {
                    if (ThreadSafeLoader.isOperationFinished()) {
                        this.lastSearch = null;
                        this.doSearch(o, source);
                    } else {
                        this.lastSearch = o;
                    }
                }
            }
        }
    }

    public abstract ASearchConfiguration<T, E> getModuleSearchParameters(Object var1, Object var2, boolean var3, boolean var4, Component var5);

    public ASearchConfiguration<T, E> getSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.deletedState = false;
        }
        if (name == FILTER_DELETE) {
            switch ((DeleteStateE)value) {
                case ALL: {
                    this.deletedState = null;
                    break;
                }
                case DELETED: {
                    this.deletedState = true;
                    break;
                }
                case NOT_DELETED: {
                    this.deletedState = false;
                    break;
                }
                default: {
                    this.deletedState = null;
                }
            }
        }
        ASearchConfiguration<T, E> o = this.getModuleSearchParameters(name, value, isReset, getEmptyConfig, source);
        if (getEmptyConfig) {
            o.setIsDeleted(null);
        } else {
            o.setIsDeleted(this.deletedState);
        }
        return o;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        if (this.hasFilterChain && this.filterChain != null) {
            this.filterChain.setEnabled(isEnabled);
        }
        if (this.otherTitleThing != null) {
            this.otherTitleThing.setEnabled(isEnabled);
        }
        if (this.tools != null) {
            this.tools.setEnabled(isEnabled);
        }
        if (this.table != null) {
            this.table.setEnabled(isEnabled);
        }
        if (this.getSmartButton1() != null) {
            this.getSmartButton1().setEnabled(isEnabled);
        }
        if (this.getSmartButton2() != null) {
            this.getSmartButton2().setEnabled(isEnabled);
        }
        if (this.getMainFrame() != null && this.getMainFrame().getTitleBar() != null) {
            this.getMainFrame().getTitleBar().setEnabled(isEnabled);
        }
        if (this.pagination != null) {
            this.pagination.setEnabled(isEnabled);
        }
    }

    public void setLoadData(boolean isLoading) {
        if (isLoading) {
            this.table.setEnabled(false);
            if (this.getMainFrame() != null && this.getMainFrame().getTitleBar() != null) {
                this.getMainFrame().getTitleBar().setHUDButtonsEnabled(false, 7735);
            }
        } else {
            this.setEnabled(true);
            if (this.getMainFrame() != null && this.getMainFrame().getTitleBar() != null) {
                this.getMainFrame().getTitleBar().setHUDButtonsEnabled(true, 7735);
            }
        }
    }

    public void setLoadingData(boolean isLoadingData) {
        if (isLoadingData) {
            this.setEnabled(false);
            this.table.activateDataLoadingAnimation(null, null, null);
            if (this.hasFilterChain) {
                this.filterChain.activateDataLoadingAnimation(null, null, null);
            }
        } else {
            this.table.deactivateDataLoadingAnimation();
            if (this.hasFilterChain) {
                this.filterChain.deactivateDataLoadingAnimation();
            }
        }
        this.isLoadingData = isLoadingData;
    }

    public boolean isLoadingData() {
        return this.isLoadingData;
    }

    @Override
    public void stopAnimationsImmediately() {
        this.table.stopAnimationImmediately();
        if (this.hasFilterChain) {
            this.filterChain.stopAnimationImmediately();
        }
    }

    public LoadingAnimation startAnimation(String t) {
        this.setEnabled(false);
        return this.table.setLoadingAnimationText(t);
    }

    public void hideAnimation() {
        this.setEnabled(true);
        this.table.hideAnimation();
    }

    protected void addThings2Screen() {
        this.setLayout(new TableViewLayout());
        if (this.hasFilterChain) {
            this.filterChain = new FilterChain(this.getClass());
            this.filterChain.addFilterChainListener(this);
        }
        this.attributeChanged("All attributes changed");
        this.createFilterChain(this.loadingId);
        if (this.hasFilterChain) {
            if (this.showDeletedComboBox()) {
                this.filterChain.addDeleteFilter(FILTER_DELETE);
            }
            this.filterChain.createFocusCycle();
        }
        this.pagination = new PaginationPanel();
        this.pagination.addPaginationListener(this);
        this.add(this.table);
        this.add(this.pagination);
        if (this.hasFilterChain) {
            this.add(this.filterChain);
        }
    }

    protected boolean showDeletedComboBox() {
        return ADeletableDTO.class.isAssignableFrom(this.type);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            if (this.hasFilterChain) {
                this.filterChain.setSize(this.filterChain.getWidth(), AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_filter_chain_height")));
            }
            this.vertical_gap_to_chain_Title = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_chaintitle"));
            this.vertical_gap_to_filterChain = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_filter_chain"));
            this.vertical_gap_to_screenTitle = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_screentitle"));
            this.vertical_gap_to_tableTitle = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_tabletitle"));
            this.vertical_gap_to_title = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("screen_vertical_border_to_apptitle"));
        }
        this.setSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void configureHUDButtons(boolean isEnabled) {
        this.getMainFrame().getTitleBar().setHUDButtonsEnabled(isEnabled, this.titleIconsConfiguration);
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (this.notYetLoaded) {
            this.notYetLoaded = false;
            this.lastSearch = null;
        }
        this.isInit = false;
        if (this.table == null) {
            return;
        }
        if (this.hasFilterChain) {
            this.filterChain.deactivateDataLoadingAnimation();
        }
        if (this.getSearchAlgorithm() != null) {
            this.lastSearch = null;
            if (this.filterChain != null) {
                // empty if block
            }
            this.loadConfiguration();
            ASearchConfiguration<T, E> o = this.getSearchParameters(null, null, false, false, this.pagination);
            this.doSearch(o, this);
        } else {
            this.notYetLoaded = true;
            this.configureHUDButtons(true);
        }
    }

    @Override
    public void errorOccurred(ClientException exception) {
        this.setEnabled(true);
        this.hideAnimation();
        this.setCursor(Cursor.getDefaultCursor());
        InnerPopupFactory.showErrorDialog((Exception)exception, "Error occurred", (Component)this);
    }

    public void redo() {
    }

    public void undo() {
    }

    public void commitSent() {
    }

    @Override
    public void escapeKeyPressed() {
        if (this.table.getModel().getExpandedModel() == null || !this.table.getModel().getExpandedModel().isLoaded()) {
            return;
        }
        RowModel<T> m = this.table.getModel().getExpandedModel();
        m.cancelRow();
    }

    @Override
    public void saveKeyPressed() {
        if (this.table.getModel().getExpandedModel() == null) {
            return;
        }
        RowModel<T> m = this.table.getModel().getExpandedModel();
        m.saveRow();
    }

    @Override
    public void screenSet() {
        super.screenSet();
        this.table.setReady(true);
        this.table.configureSmartScreenButtonOnRows();
    }

    @Override
    public void sortColumn(E att, boolean isAsc) {
        this.currentColumnAttribute = att;
        this.isAsc = isAsc;
        this.filterValueChanged(null, null, false, this.filterChain);
    }

    @Override
    public Object getValidationAttributes(RowPanel<T> p) {
        return null;
    }

    @Override
    public void pageChanged(PaginationPanel source, int currentPage) {
        this.filterValueChanged(null, null, false, source);
    }

    @Override
    public final String getScreenTitle() {
        return new AppModulesUtils().getModuleDisplayName(this.getInvoker());
    }

    public abstract AccessDefinitionComplete getInvoker();

    public void reloadData() {
        this.doSearch(this.getSearchParameters(null, null, false, false, this.pagination), this);
    }

    public void showMessage(List<ScreenValidationObject> res) {
        if (res != null && !res.isEmpty()) {
            InnerPopupFactory.showErrorDialog(res, "Unable to open all Flights, please review Flights:", (Component)this);
        }
    }

    public boolean isExpanded() {
        return this.table.getModel().getExpandedModel() != null;
    }

    public ASearchConfiguration<T, E> getCurrentSearchConfig() {
        return this.getSearchParameters(null, null, false, false, this);
    }

    @Override
    public boolean isDeletable(RowModel<T> model) {
        if (model != null && model.getNode() != null && model.getNode().getValue() instanceof IDeletableDTO && model.getNode().getChildNamed(ADeletableDTO_.isDeleted) != null) {
            Boolean b = (Boolean)model.getNode().getValueForNamed(ADeletableDTO_.isDeleted);
            return b == false;
        }
        return false;
    }

    @Override
    public boolean isRestorable(RowModel<T> model) {
        if (model != null && model.getNode() != null && model.getNode().getValue() instanceof IDeletableDTO && model.getNode().getChildNamed(ADeletableDTO_.isDeleted) != null) {
            Boolean b = (Boolean)model.getNode().getValueForNamed(ADeletableDTO_.isDeleted);
            return b;
        }
        return false;
    }

    public void commitingFinished() {
    }

    public Table<T, E> getTable() {
        return this.table;
    }

    public void setTable(Table<T, E> table) {
        this.table = table;
    }

    public RDProvider createProvider(boolean isAddRow) {
        return new RDProvider(this.getCurrentAccessRight(this.getInvoker()), isAddRow);
    }

    public class TableViewLayout
    extends DefaultLayout {
        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            int currentY = 0;
            currentY += ScreenTableView.this.layoutTitle(parent);
            if (ScreenTableView.this.otherTitleThing != null) {
                ScreenTableView.this.otherTitleThing.setLocation(0, currentY + 10);
                ScreenTableView.this.otherTitleThing.setSize(w, (int)ScreenTableView.this.otherTitleThing.getPreferredSize().getHeight());
                currentY += ScreenTableView.this.vertical_gap_to_screenTitle + ScreenTableView.this.otherTitleThing.getHeight();
            }
            if (ScreenTableView.this.hasFilterChain) {
                ScreenTableView.this.filterChain.setLocation(0, currentY += ScreenTableView.this.vertical_gap_to_screenTitle);
                Dimension d = ScreenTableView.this.filterChain.getLayout().preferredLayoutSize(ScreenTableView.this);
                ScreenTableView.this.filterChain.setSize(w, (int)d.getHeight());
                currentY += ScreenTableView.this.filterChain.getHeight();
            }
            currentY += ScreenTableView.this.vertical_gap_to_filterChain;
            int toolGap = 0;
            if (ScreenTableView.this.tools != null) {
                toolGap = (int)((double)toolGap + ScreenTableView.this.tools.getPreferredSize().getHeight());
                toolGap += 10;
            }
            if (ScreenTableView.this.subTitle != null) {
                ScreenTableView.this.subTitle.setLocation(5, currentY);
                ScreenTableView.this.subTitle.setSize(parent.getWidth() - 10, (int)ScreenTableView.this.subTitle.getPreferredSize().getHeight());
                currentY += ScreenTableView.this.subTitle.getHeight();
                currentY += ScreenTableView.this.vertical_gap_to_filterChain;
            }
            ScreenTableView.this.getTable().setLocation(0, currentY);
            ScreenTableView.this.getTable().setSize(w, (int)((double)h - ((double)ScreenTableView.this.getTable().getY() + ScreenTableView.this.pagination.getPreferredSize().getHeight() + (double)toolGap)));
            if (ScreenTableView.this.screenMessage != null) {
                ScreenTableView.this.screenMessage.setLocation(0, currentY);
                ScreenTableView.this.screenMessage.setSize(ScreenTableView.this.getTable().getSize());
            }
            ScreenTableView.this.pagination.setLocation((int)((double)(ScreenTableView.this.getTable().getX() + ScreenTableView.this.getTable().getWidth()) - ScreenTableView.this.pagination.getPreferredSize().getWidth()), ScreenTableView.this.getTable().getY() + ScreenTableView.this.getTable().getHeight());
            ScreenTableView.this.pagination.setSize(ScreenTableView.this.pagination.getPreferredSize());
            if (ScreenTableView.this.tools != null) {
                ScreenTableView.this.tools.setLocation(ScreenTableView.this.getTable().getX(), ScreenTableView.this.pagination.getY() + ScreenTableView.this.pagination.getHeight() + 10);
                ScreenTableView.this.tools.setSize(ScreenTableView.this.getTable().getWidth(), (int)ScreenTableView.this.tools.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

